/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.jface.internal.databinding.swt.AsyncRunnable;
import org.eclipse.jface.internal.databinding.swt.SyncRunnable;
import org.eclipse.jface.internal.provisional.databinding.UpdatableValue;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

public class CComboUpdatableValue
extends UpdatableValue {
    private final CCombo ccombo;
    private final String attribute;
    private boolean updating = false;
    static /* synthetic */ Class class$0;

    public CComboUpdatableValue(CCombo ccombo, String attribute) {
        this.ccombo = ccombo;
        this.attribute = attribute;
        if (attribute.equals("content")) {
            attribute = "text";
        }
        if (!attribute.equals("selection") && !attribute.equals("text")) {
            throw new IllegalArgumentException();
        }
        ccombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!CComboUpdatableValue.this.updating) {
                    CComboUpdatableValue.this.fireChangeEvent(1, null, null);
                }
            }
        });
    }

    public void setValue(final Object value) {
        AsyncRunnable runnable = new AsyncRunnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                String oldValue = CComboUpdatableValue.this.ccombo.getText();
                try {
                    CComboUpdatableValue.this.updating = true;
                    if (CComboUpdatableValue.this.attribute.equals("text")) {
                        String stringValue = value != null ? value.toString() : "";
                        CComboUpdatableValue.this.ccombo.setText(stringValue);
                    } else if (CComboUpdatableValue.this.attribute.equals("selection")) {
                        String[] items = CComboUpdatableValue.this.ccombo.getItems();
                        int index = -1;
                        if (items != null && value != null) {
                            int i = 0;
                            while (i < items.length) {
                                if (value.equals(items[i])) {
                                    index = i;
                                    break;
                                }
                                ++i;
                            }
                            if (index == -1) {
                                CComboUpdatableValue.this.ccombo.setText((String)value);
                            } else {
                                CComboUpdatableValue.this.ccombo.select(index);
                            }
                        }
                    }
                    Object var5_8 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    CComboUpdatableValue.this.updating = false;
                    throw throwable;
                }
                CComboUpdatableValue.this.updating = false;
                CComboUpdatableValue.this.fireChangeEvent(1, oldValue, CComboUpdatableValue.this.ccombo.getText());
            }
        };
        runnable.runOn(this.ccombo.getDisplay());
    }

    public Object computeValue() {
        SyncRunnable runnable = new SyncRunnable(){

            public Object run() {
                if (CComboUpdatableValue.this.attribute.equals("text")) {
                    return CComboUpdatableValue.this.ccombo.getText();
                }
                Assert.isTrue((boolean)CComboUpdatableValue.this.attribute.equals("selection"), (String)("unexpected attribute: " + CComboUpdatableValue.this.attribute));
                return CComboUpdatableValue.this.ccombo.getText();
            }
        };
        return runnable.run();
    }

    public Class getValueType() {
        Assert.isTrue((this.attribute.equals("text") || this.attribute.equals("selection") ? 1 : 0) != 0, (String)("unexpected attribute: " + this.attribute));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

