/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.jface.internal.databinding.swt.AsyncRunnable;
import org.eclipse.jface.internal.databinding.swt.SyncRunnable;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.UpdatableValue;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TextUpdatableValue
extends UpdatableValue {
    private final Text text;
    private boolean updating = false;
    private int updatePolicy;
    private String bufferedValue;
    private Listener validateListener = new Listener(){

        public void handleEvent(Event event) {
            if (!TextUpdatableValue.this.updating) {
                TextUpdatableValue.this.fireChangeEvent(1, null, TextUpdatableValue.this.text.getText());
            }
        }
    };
    private Listener updateListener = new Listener(){

        public void handleEvent(Event event) {
            if (!TextUpdatableValue.this.updating) {
                String oldValue = TextUpdatableValue.this.bufferedValue;
                String newValue = TextUpdatableValue.this.text.getText();
                if (TextUpdatableValue.this.updatePolicy == 16) {
                    TextUpdatableValue.this.bufferedValue = TextUpdatableValue.this.text.getText();
                    if (!oldValue.equals(newValue)) {
                        TextUpdatableValue.this.fireChangeEvent(1, null, TextUpdatableValue.this.text.getText());
                    }
                } else {
                    TextUpdatableValue.this.fireChangeEvent(1, null, TextUpdatableValue.this.text.getText());
                }
            }
        }
    };
    private VerifyListener verifyListener;
    private KeyListener keyListener;
    static /* synthetic */ Class class$0;

    public TextUpdatableValue(final Text text, int updatePolicy) {
        this.text = text;
        this.updatePolicy = updatePolicy;
        if (updatePolicy != 0) {
            text.addListener(updatePolicy, this.updateListener);
        }
        if (updatePolicy == 24) {
            text.addListener(16, new Listener(){

                public void handleEvent(Event event) {
                    if (!TextUpdatableValue.this.updating) {
                        TextUpdatableValue.this.bufferedValue = text.getText();
                    }
                }
            });
        }
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String newText;
                String currentText;
                ChangeEvent changeEvent;
                if (!TextUpdatableValue.this.updating && (changeEvent = TextUpdatableValue.this.fireChangeEvent(8, currentText = TextUpdatableValue.this.text.getText(), newText = String.valueOf(currentText.substring(0, e.start)) + e.text + currentText.substring(e.end))).getVeto()) {
                    e.doit = false;
                }
            }
        };
        text.addVerifyListener(this.verifyListener);
        this.keyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b' && TextUpdatableValue.this.bufferedValue != null) {
                    text.setText(TextUpdatableValue.this.bufferedValue);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        text.addKeyListener(this.keyListener);
    }

    public void setValue(final Object value) {
        AsyncRunnable runnable = new AsyncRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                String oldValue = TextUpdatableValue.this.text.getText();
                try {
                    TextUpdatableValue.this.updating = true;
                    TextUpdatableValue.this.bufferedValue = (String)value;
                    TextUpdatableValue.this.text.setText(value == null ? "" : value.toString());
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    TextUpdatableValue.this.updating = false;
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                TextUpdatableValue.this.updating = false;
                TextUpdatableValue.this.fireChangeEvent(1, oldValue, TextUpdatableValue.this.text.getText());
            }
        };
        runnable.runOn(this.text.getDisplay());
    }

    public Object computeValue() {
        SyncRunnable runnable = new SyncRunnable(){

            public Object run() {
                return TextUpdatableValue.this.text.getText();
            }
        };
        return runnable.runOn(this.text.getDisplay());
    }

    public Class getValueType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void dispose() {
        if (!this.text.isDisposed()) {
            if (this.updatePolicy != 0) {
                this.text.removeListener(this.updatePolicy, this.updateListener);
            }
            this.text.removeVerifyListener(this.verifyListener);
        }
        super.dispose();
    }
}

