/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.HashMap;
import org.eclipse.jface.internal.databinding.beans.PropertyHelper;
import org.eclipse.jface.internal.databinding.viewers.TreeViewerUpdatableTree;
import org.eclipse.jface.internal.provisional.databinding.BindingException;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.IDataBindingContext;
import org.eclipse.jface.internal.provisional.databinding.converter.IConverter;
import org.eclipse.jface.internal.provisional.databinding.converters.IdentityConverter;
import org.eclipse.jface.internal.provisional.databinding.validator.IValidator;
import org.eclipse.jface.internal.provisional.databinding.viewers.TableViewerDescription;
import org.eclipse.jface.internal.provisional.databinding.viewers.TreeViewerDescription;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;

public class TreeViewerUpdatableTreeExtended
extends TreeViewerUpdatableTree {
    private HashMap columnInfos = new HashMap();
    private IDataBindingContext dataBindingContext;
    private final TreeViewerDescription treeViewerDescription;
    private final IChangeListener dummyListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
        }
    };
    static /* synthetic */ Class class$0;

    public TreeViewerUpdatableTreeExtended(TreeViewerDescription treeViewerDescription, IDataBindingContext dataBindingContext) {
        super(treeViewerDescription.getTreeViewer(), treeViewerDescription.getClassTypes());
        this.treeViewerDescription = treeViewerDescription;
        this.dataBindingContext = dataBindingContext;
        this.fillDescriptionDefaults(dataBindingContext);
        TreeViewer tableViewer = treeViewerDescription.getTreeViewer();
        tableViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        tableViewer.setCellModifier(treeViewerDescription.getCellModifier());
        int columnCount = this.getColumnCount();
        String[] columnProperties = new String[columnCount];
        CellEditor[] cellEditors = new CellEditor[columnCount];
        int i = 0;
        while (i < columnCount) {
            columnProperties[i] = Integer.toString(i);
            cellEditors[i] = this.createCellEditor(i);
            ++i;
        }
        tableViewer.setColumnProperties(columnProperties);
        tableViewer.setCellEditors(cellEditors);
    }

    private int getColumnCount() {
        int count = 0;
        Class[] types = this.treeViewerDescription.getClassTypes();
        int i = 0;
        while (i < types.length) {
            int cc = this.treeViewerDescription.getColumnCount(types[i]);
            if (cc > count) {
                count = cc;
            }
            ++i;
        }
        return count;
    }

    protected CellEditor createCellEditor(int columnIndex) {
        TableViewerDescription.Column column;
        Class[] classTypes = this.treeViewerDescription.getClassTypes();
        CellEditor customEditor = null;
        int i = 0;
        while (i < classTypes.length) {
            column = this.treeViewerDescription.getColumn(classTypes[i], columnIndex);
            if (column != null && column.getCellEditor() != null) {
                if (customEditor != null) {
                    if (customEditor != column.getCellEditor()) {
                        throw new BindingException("Different Cell Editors on Column: " + columnIndex);
                    }
                } else {
                    customEditor = column.getCellEditor();
                }
            }
            ++i;
        }
        if (customEditor == null) {
            return new TextCellEditor((Composite)this.treeViewerDescription.getTreeViewer().getTree());
        }
        i = 0;
        while (i < classTypes.length) {
            column = this.treeViewerDescription.getColumn(classTypes[i], columnIndex);
            column.setCellEditor(customEditor);
            ++i;
        }
        return customEditor;
    }

    protected ICellModifier createCellModifier(final IDataBindingContext dataBindingContext) {
        return new ICellModifier(){

            private TableViewerDescription.Column findColumn(Class instanceType, String property) {
                int index = Integer.parseInt(property);
                return TreeViewerUpdatableTreeExtended.this.treeViewerDescription.getColumn(instanceType, index);
            }

            public boolean canModify(Object element, String property) {
                TableViewerDescription.Column column;
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                if ((column = this.findColumn(element.getClass(), property)) != null && column.getPropertyName() != null) {
                    return new PropertyHelper(column.getPropertyName(), element.getClass()).canSet(element);
                }
                return false;
            }

            public Object getValue(Object element, String property) {
                TableViewerDescription.Column column;
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                if ((column = this.findColumn(element.getClass(), property)) == null) {
                    return null;
                }
                try {
                    Object value = new PropertyHelper(column.getPropertyName(), element.getClass()).get(element);
                    return column.getConverter().convertModelToTarget(value);
                }
                catch (SecurityException securityException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                return null;
            }

            public void modify(Object element, String property, Object value) {
                String errorMessage;
                TableViewerDescription.Column column;
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                if ((column = this.findColumn(element.getClass(), property)) == null) {
                    return;
                }
                value = column.getConverter().convertTargetToModel(value);
                IValidator columnValidator = column.getValidator();
                if (columnValidator != null && (errorMessage = columnValidator.isValid(value)) != null) {
                    dataBindingContext.updateValidationError(TreeViewerUpdatableTreeExtended.this.dummyListener, errorMessage);
                    return;
                }
                new PropertyHelper(column.getPropertyName(), element.getClass()).set(element, value);
                TreeViewerUpdatableTreeExtended.this.viewer.update(element, new String[]{property});
            }
        };
    }

    private void initializeColumnConverter(TableViewerDescription.Column column, Class propertyType) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        column.setConverter(this.dataBindingContext.createConverter(clazz, propertyType, this.treeViewerDescription));
    }

    private void initializeColumnValidator(TableViewerDescription.Column column, Class propertyType) {
        column.setValidator(new IValidator(){

            public String isPartiallyValid(Object value) {
                return null;
            }

            public String isValid(Object value) {
                return null;
            }
        });
    }

    protected CellEditor createCellEditor(final TableViewerDescription.Column column) {
        return new TextCellEditor((Composite)this.treeViewerDescription.getTreeViewer().getTree()){

            protected void doSetValue(Object value) {
                super.doSetValue(column.getConverter().convertModelToTarget(value));
            }

            protected Object doGetValue() {
                String textValue = (String)super.doGetValue();
                return column.getConverter().convertTargetToModel(textValue);
            }
        };
    }

    private void fillDescriptionDefaults(IDataBindingContext dataBindingContext) {
        Class[] types = this.treeViewerDescription.getClassTypes();
        if (types == null) {
            return;
        }
        int i = 0;
        while (i < types.length) {
            int colCount = this.treeViewerDescription.getColumnCount(types[i]);
            int j = 0;
            while (j < colCount) {
                TableViewerDescription.Column column = this.treeViewerDescription.getColumn(types[i], j);
                ColumnInfo info = new ColumnInfo();
                this.columnInfos.put(column, info);
                if (column.getConverter() == null) {
                    info.converterDefaulted = true;
                    if (column.getPropertyType() != null) {
                        this.initializeColumnConverter(column, column.getPropertyType());
                    } else {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        column.setConverter(new IdentityConverter(clazz));
                    }
                }
                if (column.getValidator() == null) {
                    info.validatorDefaulted = true;
                    this.initializeColumnValidator(column, column.getPropertyType());
                }
                ++j;
            }
            ++i;
        }
        if (this.treeViewerDescription.getCellModifier() == null) {
            this.treeViewerDescription.setCellModifier(this.createCellModifier(dataBindingContext));
        }
        if (this.columnInfos.isEmpty()) {
            this.columnInfos = null;
        }
    }

    protected TableViewerDescription.Column getColumn(Class instanceType, int columnIndex) {
        return this.treeViewerDescription.getColumn(instanceType, columnIndex);
    }

    protected int addElement(Object parentElement, int index, Object value, boolean fire) {
        if (this.columnInfos != null && value != null) {
            int i = 0;
            while (i < this.treeViewerDescription.getColumnCount(value.getClass())) {
                PropertyHelper helper;
                Class<?> columnType;
                TableViewerDescription.Column column = this.treeViewerDescription.getColumn(value.getClass(), i);
                ColumnInfo columnInfo = (ColumnInfo)this.columnInfos.remove(column);
                if (columnInfo != null && column.getPropertyName() != null && column.getPropertyType() == null && (columnInfo.cellEditorDefaulted || columnInfo.converterDefaulted || columnInfo.validatorDefaulted) && (columnType = (helper = new PropertyHelper(column.getPropertyName(), value.getClass())).getGetter().getReturnType()) != null) {
                    if (columnInfo.converterDefaulted) {
                        this.initializeColumnConverter(column, columnType);
                    }
                    if (columnInfo.validatorDefaulted) {
                        this.initializeColumnValidator(column, columnType);
                    }
                }
                ++i;
            }
            if (this.columnInfos.isEmpty()) {
                this.columnInfos = null;
            }
        }
        return super.addElement(parentElement, index, value, fire);
    }

    class ColumnInfo {
        boolean converterDefaulted;
        boolean validatorDefaulted;
        boolean cellEditorDefaulted;

        ColumnInfo() {
        }
    }

    class TreeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        static /* synthetic */ Class class$0;

        TreeLabelProvider() {
        }

        private Object getValue(Object element, TableViewerDescription.Column column) {
            Object value = TreeViewerUpdatableTreeExtended.this.treeViewerDescription.getCellModifier().getValue(element, Integer.toString(TreeViewerUpdatableTreeExtended.this.treeViewerDescription.getColumnIndex(element.getClass(), column)));
            return value;
        }

        private Object getConvertedValue(Object element, TableViewerDescription.Column column) {
            String propertyName = column.getPropertyName();
            Object value = propertyName == null ? element : this.getValue(element, column);
            Object convertedValue = column.getConverter().convertModelToTarget(value);
            return convertedValue;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex < TreeViewerUpdatableTreeExtended.this.treeViewerDescription.getColumnCount(element.getClass()) && columnIndex >= 0) {
                TableViewerDescription.Column column = TreeViewerUpdatableTreeExtended.this.getColumn(element.getClass(), columnIndex);
                IConverter converter = column.getConverter();
                Class clazz = converter.getTargetType();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.jface.viewers.ViewerLabel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) {
                    ViewerLabel viewerLabel = (ViewerLabel)this.getConvertedValue(element, column);
                    return viewerLabel.getImage();
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Object convertedValue = null;
            if (columnIndex < TreeViewerUpdatableTreeExtended.this.treeViewerDescription.getColumnCount(element.getClass()) && columnIndex >= 0) {
                TableViewerDescription.Column column = TreeViewerUpdatableTreeExtended.this.getColumn(element.getClass(), columnIndex);
                convertedValue = this.getConvertedValue(element, column);
                IConverter converter = column.getConverter();
                Class clazz = converter.getTargetType();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.jface.viewers.ViewerLabel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) {
                    ViewerLabel viewerLabel = (ViewerLabel)convertedValue;
                    return viewerLabel.getText();
                }
            }
            return convertedValue == null ? "" : (String)convertedValue;
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }
}

