/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.internal.databinding.swt.SyncRunnable;
import org.eclipse.jface.internal.provisional.databinding.BindingException;
import org.eclipse.jface.internal.provisional.databinding.SelectionAwareUpdatableCollection;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class UpdatableCollectionViewer
extends SelectionAwareUpdatableCollection {
    private final AbstractListViewer viewer;
    private List elements = new ArrayList();
    private boolean updating = false;
    static /* synthetic */ Class class$0;

    public UpdatableCollectionViewer(AbstractListViewer viewer) {
        this.viewer = viewer;
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return UpdatableCollectionViewer.this.elements.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        viewer.setInput((Object)this);
    }

    public int computeSize() {
        return this.elements.size();
    }

    public int addElement(Object element, int index) {
        if (!this.updating) {
            try {
                this.updating = true;
                int position = this.primAddElement(element, index);
                if (position == this.elements.size() - 1 || this.viewer.getSorter() != null) {
                    this.viewer.add(element);
                } else {
                    this.viewer.refresh();
                }
                this.fireChangeEvent(2, null, element, position);
                int n = position;
                Object var4_5 = null;
                this.updating = false;
                return n;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.updating = false;
                throw throwable;
            }
        }
        return index;
    }

    private int primAddElement(Object element, int index) {
        int position = this.elements.size();
        if (index < 0 || index > this.elements.size()) {
            position = this.elements.size();
            this.elements.add(element);
        } else {
            this.elements.add(index, element);
            position = index;
        }
        return position;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeElement(int index) {
        if (this.updating) return;
        try {
            this.updating = true;
            Object element = this.elements.remove(index);
            this.viewer.remove(element);
            this.fireChangeEvent(4, element, null, index);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.updating = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setElement(int index, Object element) {
        if (this.updating) return;
        try {
            Object old;
            this.updating = true;
            if (this.elements.get(index).equals(element)) {
                this.viewer.update(element, null);
                old = element;
            } else {
                old = this.computeElement(index);
                this.removeElement(index);
                this.addElement(element, index);
            }
            this.fireChangeEvent(1, old, element, index);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.updating = false;
            return;
        }
    }

    public Object computeElement(int index) {
        return this.elements.get(index);
    }

    public Class getElementType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Object getSelectedObject() {
        SyncRunnable runnable = new SyncRunnable(){

            public Object run() {
                StructuredSelection selection = (StructuredSelection)UpdatableCollectionViewer.this.viewer.getSelection();
                if (selection.isEmpty()) {
                    return null;
                }
                return selection.getFirstElement();
            }
        };
        return runnable.runOn(this.viewer.getControl().getDisplay());
    }

    public void setSelectedObject(Object object) {
        StructuredSelection selection;
        if (object instanceof ISelection) {
            throw new BindingException("Selected object can not be an ISelection.");
        }
        if (object == null) {
            selection = new StructuredSelection();
        } else if (this.getElements().contains(object)) {
            selection = new StructuredSelection(object);
        } else {
            return;
        }
        StructuredSelection selectedObject = selection;
        SyncRunnable runnable = new SyncRunnable((ISelection)selectedObject){
            private final /* synthetic */ ISelection val$selectedObject;
            {
                this.val$selectedObject = iSelection;
            }

            public Object run() {
                UpdatableCollectionViewer.this.viewer.setSelection(this.val$selectedObject);
                return null;
            }
        };
        runnable.runOn(this.viewer.getControl().getDisplay());
    }

    public void setElements(List elements) {
        Object selection = this.getSelectedObject();
        super.setElements(elements);
        this.setSelectedObject(selection);
    }
}

