/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.IUpdatable;
import org.eclipse.jface.util.Assert;

public abstract class Updatable
implements IUpdatable {
    private Collection changeListeners = new ArrayList();
    private ChangeEvent staleEvent;
    private ChangeEvent notStaleEvent;

    protected final ChangeEvent createStaleEvent(boolean isStale) {
        ChangeEvent result;
        if (isStale) {
            if (this.staleEvent == null) {
                this.staleEvent = new ChangeEvent(this, 64, null, Boolean.TRUE);
            }
            result = this.staleEvent;
        } else {
            if (this.notStaleEvent == null) {
                this.notStaleEvent = new ChangeEvent(this, 64, null, Boolean.FALSE);
            }
            result = this.notStaleEvent;
        }
        result.vetoed = false;
        return result;
    }

    public void addChangeListener(IChangeListener changeListener) {
        Assert.isNotNull((Object)changeListener);
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        if (this.changeListeners.isEmpty()) {
            this.firstListenerAdded();
        }
        if (!this.changeListeners.contains(changeListener)) {
            this.changeListeners.add(changeListener);
        }
        if (this.changeListeners.size() > 32) {
            HashSet newListeners = new HashSet();
            newListeners.addAll(this.changeListeners);
            this.changeListeners = newListeners;
        }
    }

    protected void firstListenerAdded() {
    }

    protected void lastListenerRemoved() {
    }

    protected final boolean hasListeners() {
        return this.changeListeners != null && !this.changeListeners.isEmpty();
    }

    public void removeChangeListener(IChangeListener changeListener) {
        Assert.isNotNull((Object)changeListener);
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(changeListener);
        if (this.changeListeners.isEmpty()) {
            this.lastListenerRemoved();
        }
    }

    protected final ChangeEvent fireChangeEvent(int changeType, Object oldValue, Object newValue) {
        return this.fireChangeEvent(changeType, oldValue, newValue, -1);
    }

    protected final ChangeEvent fireChangeEvent(int changeType, Object oldValue, Object newValue, int position) {
        return this.fireChangeEvent(changeType, oldValue, newValue, null, position);
    }

    protected final ChangeEvent fireChangeEvent(int changeType, Object oldValue, Object newValue, Object parent, int position) {
        ChangeEvent changeEvent = null;
        if (changeType == 64 && oldValue == null && newValue instanceof Boolean) {
            changeEvent = this.createStaleEvent((Boolean)newValue);
        }
        if (changeEvent == null) {
            changeEvent = new ChangeEvent(this, changeType, oldValue, newValue, parent, position);
        }
        this.fireChangeEvent(changeEvent);
        return changeEvent;
    }

    protected final void fireChangeEvent(ChangeEvent changeEvent) {
        if (this.changeListeners == null) {
            return;
        }
        IChangeListener[] listeners = this.changeListeners.toArray(new IChangeListener[this.changeListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].handleChange(changeEvent);
            ++i;
        }
    }

    public boolean isStale() {
        return false;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.fireChangeEvent(new ChangeEvent(this, 2048, null, null));
        this.changeListeners = null;
    }

    public boolean isDisposed() {
        return this.changeListeners == null;
    }
}

