/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding.validators;

import org.eclipse.jface.internal.databinding.BindingMessages;
import org.eclipse.jface.internal.provisional.databinding.validator.IValidator;

public class String2LongValidator
implements IValidator {
    public String isPartiallyValid(Object fragment) {
        if (((String)fragment).matches("\\-?[0-9]*")) {
            return null;
        }
        return this.getHint();
    }

    public String isValid(Object value) {
        try {
            Long.parseLong((String)value);
            return null;
        }
        catch (Throwable throwable) {
            return this.getHint();
        }
    }

    private String getHint() {
        return String.valueOf(BindingMessages.getString("Validate_RangeStart")) + Long.MIN_VALUE + BindingMessages.getString("and") + Long.MAX_VALUE + ".";
    }
}

