/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding.viewers;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.IReadableSet;
import org.eclipse.jface.internal.provisional.databinding.viewers.ViewerLabelProvider;

public abstract class ListeningLabelProvider
extends ViewerLabelProvider {
    private IChangeListener listener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            block3: {
                block2: {
                    if (changeEvent.getChangeType() != 256) break block2;
                    Collection added = (Collection)changeEvent.getNewValue();
                    Iterator iter = added.iterator();
                    while (iter.hasNext()) {
                        Object next = iter.next();
                        ListeningLabelProvider.this.addListenerTo(next);
                    }
                    break block3;
                }
                if (changeEvent.getChangeType() != 512) break block3;
                Collection removed = (Collection)changeEvent.getNewValue();
                Iterator iter = removed.iterator();
                while (iter.hasNext()) {
                    Object next = iter.next();
                    ListeningLabelProvider.this.removeListenerFrom(next);
                }
            }
        }
    };
    private IReadableSet items;

    public ListeningLabelProvider(IReadableSet itemsThatNeedLabels) {
        this.items = itemsThatNeedLabels;
        this.items.addChangeListener(this.listener);
        Iterator iter = this.items.toCollection().iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            this.addListenerTo(next);
        }
    }

    protected abstract void removeListenerFrom(Object var1);

    protected abstract void addListenerTo(Object var1);

    public void dispose() {
        Iterator iter = this.items.toCollection().iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            this.removeListenerFrom(next);
        }
        this.items.removeChangeListener(this.listener);
        super.dispose();
    }
}

