/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding.viewers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.internal.provisional.databinding.converter.IConverter;
import org.eclipse.jface.internal.provisional.databinding.validator.IValidator;
import org.eclipse.jface.internal.provisional.databinding.viewers.TableViewerDescription;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TreeViewer;

public class TreeViewerDescription {
    public static final String COLUMN_PROPERTY_NESTING_SEPERATOR = ".";
    private TreeViewer treeViewer;
    private HashMap columnsMap = new HashMap();
    private ICellModifier cellModifier = null;

    public TreeViewerDescription(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public void addColumn(Class instanceType, int columnIndex, String propertyName, CellEditor cellEditor, IValidator validator, IConverter converter) {
        ArrayList<TableViewerDescription.Column> columns = (ArrayList<TableViewerDescription.Column>)this.columnsMap.get(instanceType);
        if (columns == null) {
            columns = new ArrayList<TableViewerDescription.Column>();
            this.columnsMap.put(instanceType, columns);
        }
        TableViewerDescription.Column column = new TableViewerDescription.Column(propertyName, cellEditor, validator, converter);
        if (columnIndex == -1) {
            columns.add(column);
        } else {
            columns.add(columnIndex, column);
        }
    }

    public void addColumn(Class instanceType, String propertyName, CellEditor cellEditor, IValidator validator, IConverter converter) {
        this.addColumn(instanceType, -1, propertyName, cellEditor, validator, converter);
    }

    public void addColumn(Class instanceType, int columnIndex, String propertyName, IValidator validator, IConverter converter) {
        this.addColumn(instanceType, columnIndex, propertyName, null, validator, converter);
    }

    public void addColumn(Class instanceType, String propertyName, IValidator validator, IConverter converter) {
        this.addColumn(instanceType, -1, propertyName, validator, converter);
    }

    public void addColumn(Class instanceType, String propertyName) {
        this.addColumn(instanceType, -1, propertyName, null, null, null);
    }

    public void addColumn(Class instanceType, int columnIndex, String propertyName) {
        this.addColumn(instanceType, columnIndex, propertyName, null, null, null);
    }

    public ICellModifier getCellModifier() {
        return this.cellModifier;
    }

    public void setCellModifier(ICellModifier cellModifier) {
        this.cellModifier = cellModifier;
    }

    public int getColumnCount(Class instanceType) {
        List columns = (List)this.columnsMap.get(instanceType);
        if (columns != null) {
            return columns.size();
        }
        return 0;
    }

    public TableViewerDescription.Column getColumn(Class instanceType, int columnIndex) {
        List columns = (List)this.columnsMap.get(instanceType);
        if (columns != null && columns.size() > columnIndex) {
            return (TableViewerDescription.Column)columns.get(columnIndex);
        }
        return null;
    }

    public int getColumnIndex(Class instanceType, TableViewerDescription.Column column) {
        List columns = (List)this.columnsMap.get(instanceType);
        if (columns != null) {
            return columns.indexOf(column);
        }
        return -1;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public Class[] getClassTypes() {
        if (this.columnsMap.keySet().size() == 0) {
            return null;
        }
        return this.columnsMap.keySet().toArray(new Class[this.columnsMap.keySet().size()]);
    }
}

