/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.variables;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.ui.externaltools.internal.model.ExternalToolBuilder;
import org.eclipse.ui.externaltools.internal.variables.VariableMessages;

public class BuildProjectResolver
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        IProject resource = ExternalToolBuilder.getBuildProject();
        if (argument != null && resource != null) {
            resource = resource.findMember((IPath)new Path(argument));
        }
        if (resource != null && resource.exists()) {
            return resource.getLocation().toOSString();
        }
        this.abort(MessageFormat.format(VariableMessages.BuildProjectResolver_3, this.getReferenceExpression(variable, argument)), null);
        return null;
    }

    protected void abort(String message, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.externaltools", 150, message, exception));
    }

    protected String getReferenceExpression(IDynamicVariable variable, String argument) {
        StringBuffer reference = new StringBuffer();
        reference.append("${");
        reference.append(variable.getName());
        if (argument != null) {
            reference.append(":");
            reference.append(argument);
        }
        reference.append("}");
        return reference.toString();
    }
}

