/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class PropertiesActionProvider
extends CommonActionProvider {
    private PropertyDialogAction propertiesAction;
    private ISelectionProvider delegateSelectionProvider;

    public void init(final ICommonActionExtensionSite aSite) {
        this.delegateSelectionProvider = new DelegateSelectionProvider(aSite.getViewSite().getSelectionProvider());
        this.propertiesAction = new PropertyDialogAction(new IShellProvider(){

            public Shell getShell() {
                return aSite.getViewSite().getShell();
            }
        }, this.delegateSelectionProvider);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.appendToGroup("group.properties", (IAction)this.propertiesAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.propertiesAction.selectionChanged(this.delegateSelectionProvider.getSelection());
    }

    private class DelegateIAdaptable
    implements IAdaptable {
        private Object delegate;

        DelegateIAdaptable(Object o) {
            this.delegate = o;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isInstance(this.delegate)) {
                return this.delegate;
            }
            return Platform.getAdapterManager().getAdapter(this.delegate, adapter);
        }
    }

    private class DelegateSelectionProvider
    implements ISelectionProvider {
        private ISelectionProvider delegate;

        DelegateSelectionProvider(ISelectionProvider s) {
            this.delegate = s;
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.delegate.addSelectionChangedListener(listener);
        }

        public ISelection getSelection() {
            if (this.delegate.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection sSel = (IStructuredSelection)this.delegate.getSelection();
                if (sSel.getFirstElement() instanceof IAdaptable) {
                    return sSel;
                }
                return new StructuredSelection((Object)new DelegateIAdaptable(sSel.getFirstElement()));
            }
            return this.delegate.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.delegate.removeSelectionChangedListener(listener);
        }

        public void setSelection(ISelection selection) {
            this.delegate.setSelection(selection);
        }
    }
}

