/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.ProductFile;
import org.eclipse.pde.internal.build.XMLWriter;
import org.eclipse.pde.internal.build.site.PDEState;

public class FeatureGenerator
extends AbstractScriptGenerator {
    private String featureId = null;
    private String productFile = null;
    private String[] pluginList = null;
    private String[] featureList = null;
    private ProductFile product = null;
    private boolean verify = false;

    public void generate() throws CoreException {
        List<Object> features;
        this.initialize();
        List<Object> plugins = this.pluginList != null ? Arrays.asList(this.pluginList) : new ArrayList();
        List<Object> list = features = this.featureList != null ? Arrays.asList(this.featureList) : new ArrayList();
        if (this.product != null) {
            List productElements;
            List list2 = productElements = this.product.useFeatures() ? this.product.getFeatures() : this.product.getPlugins();
            if (productElements != null && productElements.size() > 0) {
                if (this.product.useFeatures()) {
                    features.addAll(productElements);
                } else {
                    plugins.addAll(productElements);
                }
            }
        }
        try {
            this.createFeature(this.featureId, plugins, features);
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public void setProductFile(String productFile) {
        this.productFile = productFile;
    }

    public void setPluginList(String[] pluginList) {
        this.pluginList = pluginList;
    }

    public void setFeatureList(String[] featureList) {
        this.featureList = featureList;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    private void initialize() {
        if (this.productFile != null && !this.productFile.startsWith("${")) {
            File f;
            String productPath = this.findFile(this.productFile, false);
            if (productPath == null) {
                productPath = this.productFile;
            }
            if ((f = new File(productPath)).exists() && f.isFile()) {
                try {
                    this.product = new ProductFile(productPath, null);
                }
                catch (CoreException coreException) {}
            }
        }
    }

    protected void createFeature(String feature, List plugins, List features) throws CoreException, FileNotFoundException {
        block13: {
            String name;
            String location = "features/" + feature;
            File directory = new File(FeatureGenerator.getWorkingDirectory(), location);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            PDEState state = this.verify ? this.getSite(false).getRegistry() : null;
            File file = new File(directory, "feature.xml");
            FileOutputStream output = new FileOutputStream(file);
            XMLWriter writer = null;
            try {
                writer = new XMLWriter(output);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return;
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("id", feature);
            parameters.put("version", "1.0.0");
            writer.startTag("feature", parameters, true);
            Iterator iter = plugins.iterator();
            while (iter.hasNext()) {
                name = (String)iter.next();
                boolean unpack = true;
                if (this.verify) {
                    BundleDescription bundle = state.getResolvedBundle(name);
                    if (bundle != null) {
                        unpack = this.guessUnpack(bundle, (String[])state.getExtraData().get(new Long(bundle.getBundleId())));
                    } else {
                        String message = NLS.bind((String)Messages.exception_missingPlugin, (Object)name);
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 5, message, null));
                    }
                }
                parameters.clear();
                parameters.put("id", name);
                parameters.put("version", "0.0.0");
                parameters.put("unpack", unpack ? "true" : "false");
                writer.printTag("plugin", parameters, true, true, true);
            }
            iter = features.iterator();
            while (iter.hasNext()) {
                name = (String)iter.next();
                if (this.verify) {
                    this.getSite(false).findFeature(name, null, true);
                }
                parameters.clear();
                parameters.put("id", name);
                parameters.put("version", "0.0.0");
                writer.printTag("includes", parameters, true, true, true);
            }
            writer.endTag("feature");
            writer.close();
            file = new File(directory, "build.properties");
            Properties prop = new Properties();
            prop.put("pde", "marker");
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(file);
                prop.store(stream, "Marker File so that the file gets written");
                stream.flush();
            }
            catch (IOException iOException) {
                if (stream == null) break block13;
                try {
                    stream.close();
                }
                catch (IOException iOException2) {}
            }
        }
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public boolean guessUnpack(BundleDescription bundle, String[] classpath) {
        if (bundle == null) {
            return true;
        }
        if (new File(bundle.getLocation()).isFile()) {
            return false;
        }
        if (classpath.length == 0) {
            return false;
        }
        int i = 0;
        while (i < classpath.length) {
            if (classpath[i].equals(".")) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

