/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProductFile
extends DefaultHandler
implements IPDEBuildConstants {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private static final String SOLARIS_LARGE = "solarisLarge";
    private static final String SOLARIS_MEDIUM = "solarisMedium";
    private static final String SOLARIS_SMALL = "solarisSmall";
    private static final String SOLARIS_TINY = "solarisTiny";
    private static final String WIN32_16_LOW = "winSmallLow";
    private static final String WIN32_16_HIGH = "winSmallHigh";
    private static final String WIN32_32_LOW = "winMediumLow";
    private static final String WIN32_32_HIGH = "winMediumHigh";
    private static final String WIN32_48_LOW = "winLargeLow";
    private static final String WIN32_48_HIGH = "winLargeHigh";
    private static final String P_USE_ICO = "useIco";
    private SAXParser parser;
    private File location;
    private String currentOS = null;
    private boolean useIco = false;
    private ArrayList result = new ArrayList(6);
    private String launcherName = null;
    private String[] icons = null;
    private boolean parsed = false;
    private String configPath = null;
    private String id = null;
    private boolean useFeatures = false;
    private List plugins = null;
    private List features = null;
    private String splashLocation = null;
    private String productName;

    public ProductFile(String location, String os) throws CoreException {
        this.location = new File(location);
        this.currentOS = os;
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 23, e.getLocalizedMessage(), (Throwable)e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 23, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public String getLauncherName() {
        if (this.parsed) {
            return this.launcherName;
        }
        this.parse();
        return this.launcherName;
    }

    public List getPlugins() {
        if (!this.parsed) {
            this.parse();
        }
        return this.plugins;
    }

    public List getFeatures() {
        if (!this.parsed) {
            this.parse();
        }
        return this.features;
    }

    public boolean containsPlugin(String plugin) {
        if (!this.parsed) {
            this.parse();
        }
        return this.plugins != null && this.plugins.contains(plugin);
    }

    public String[] getIcons() {
        if (this.icons != null) {
            return this.icons;
        }
        if (!this.parsed) {
            this.parse();
        }
        String[] temp = new String[this.result.size()];
        int i = 0;
        Iterator iter = this.result.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            if (element == null) continue;
            temp[i++] = element;
        }
        this.icons = new String[i];
        System.arraycopy(temp, 0, this.icons, 0, i);
        return this.icons;
    }

    public String getConfigIniPath() {
        if (!this.parsed) {
            this.parse();
        }
        return this.configPath;
    }

    public String getId() {
        if (!this.parsed) {
            this.parse();
        }
        return this.id;
    }

    public String getSplashLocation() {
        if (!this.parsed) {
            this.parse();
        }
        return this.splashLocation;
    }

    public String getProductName() {
        if (!this.parsed) {
            this.parse();
        }
        return this.productName;
    }

    public boolean useFeatures() {
        if (!this.parsed) {
            this.parse();
        }
        return this.useFeatures;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse() {
        this.parsed = true;
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.location);
            try {
                try {
                    this.parser.parse(new InputSource(in), (DefaultHandler)this);
                }
                catch (SAXException sAXException) {}
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            {
                Object var2_4 = null;
                ((InputStream)in).close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("launcher".equals(localName)) {
            this.processLauncher(attributes);
        } else if ("solaris".equals(localName)) {
            this.processSolaris(attributes);
        } else if ("win".equals(localName)) {
            this.processWin(attributes);
        } else if ("linux".equals(localName)) {
            this.processLinux(attributes);
        } else if ("macosx".equals(localName)) {
            this.processMac(attributes);
        } else if ("ico".equals(localName)) {
            this.processIco(attributes);
        } else if ("bmp".equals(localName)) {
            this.processBmp(attributes);
        } else if ("configIni".equals(localName)) {
            this.processConfigIni(attributes);
        } else if ("product".equals(localName)) {
            this.processProduct(attributes);
        } else if ("plugin".equals(localName)) {
            this.processPlugin(attributes);
        } else if ("splash".equals(localName)) {
            this.splashLocation = attributes.getValue("location");
        } else if ("feature".equals(localName)) {
            this.processFeature(attributes);
        }
    }

    private void processPlugin(Attributes attributes) {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        this.plugins.add(attributes.getValue("id"));
    }

    private void processFeature(Attributes attributes) {
        if (this.features == null) {
            this.features = new ArrayList();
        }
        this.features.add(attributes.getValue("id"));
    }

    private void processProduct(Attributes attributes) {
        this.id = attributes.getValue("id");
        this.productName = attributes.getValue("name");
        String use = attributes.getValue("useFeatures");
        if (use != null) {
            this.useFeatures = "true".equalsIgnoreCase(use);
        }
    }

    private void processConfigIni(Attributes attributes) {
        if (attributes.getValue("use").equals("custom")) {
            this.configPath = attributes.getValue("path");
        }
    }

    private void processLauncher(Attributes attributes) {
        this.launcherName = attributes.getValue("name");
    }

    private boolean osMatch(String os) {
        if (os == this.currentOS) {
            return true;
        }
        if (os == null) {
            return false;
        }
        return os.equals(this.currentOS);
    }

    private void processSolaris(Attributes attributes) {
        if (!this.osMatch("solaris")) {
            return;
        }
        this.result.add(attributes.getValue(SOLARIS_LARGE));
        this.result.add(attributes.getValue(SOLARIS_MEDIUM));
        this.result.add(attributes.getValue(SOLARIS_SMALL));
        this.result.add(attributes.getValue(SOLARIS_TINY));
    }

    private void processWin(Attributes attributes) {
        if (!this.osMatch("win32")) {
            return;
        }
        this.useIco = "true".equals(attributes.getValue(P_USE_ICO));
    }

    private void processIco(Attributes attributes) {
        if (!this.osMatch("win32") || !this.useIco) {
            return;
        }
        this.result.add(attributes.getValue("path"));
    }

    private void processBmp(Attributes attributes) {
        if (!this.osMatch("win32") || this.useIco) {
            return;
        }
        this.result.add(attributes.getValue(WIN32_16_HIGH));
        this.result.add(attributes.getValue(WIN32_16_LOW));
        this.result.add(attributes.getValue(WIN32_32_HIGH));
        this.result.add(attributes.getValue(WIN32_32_LOW));
        this.result.add(attributes.getValue(WIN32_48_HIGH));
        this.result.add(attributes.getValue(WIN32_48_LOW));
    }

    private void processLinux(Attributes attributes) {
        if (!this.osMatch("linux")) {
            return;
        }
        this.result.add(attributes.getValue("icon"));
    }

    private void processMac(Attributes attributes) {
        if (!this.osMatch("macosx")) {
            return;
        }
        this.result.add(attributes.getValue("icon"));
    }
}

