/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.ui.internal.preferences.BaseConfigurationBlock;
import org.eclipse.jdt.apt.ui.internal.preferences.Messages;
import org.eclipse.jdt.apt.ui.internal.preferences.ProcessorOptionInputDialog;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AptConfigurationBlock
extends BaseConfigurationBlock {
    private static final BaseConfigurationBlock.Key KEY_APTENABLED = AptConfigurationBlock.getKey("org.eclipse.jdt.apt.core", "org.eclipse.jdt.apt.aptEnabled");
    private static final BaseConfigurationBlock.Key KEY_GENSRCDIR = AptConfigurationBlock.getKey("org.eclipse.jdt.apt.core", "org.eclipse.jdt.apt.genSrcDir");
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private final IJavaProject fJProj;
    private SelectionButtonDialogField fAptEnabledField;
    private StringDialogField fGenSrcDirField;
    private ListDialogField fProcessorOptionsField;
    private PixelConverter fPixelConverter;
    private Composite fBlockControl;
    private Map<String, String> fOriginalProcOptions;
    private String fOriginalGenSrcDir;
    private boolean fOriginalAptEnabled;

    private static BaseConfigurationBlock.Key[] getAllKeys() {
        return new BaseConfigurationBlock.Key[]{KEY_APTENABLED, KEY_GENSRCDIR};
    }

    public AptConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, AptConfigurationBlock.getAllKeys(), container);
        this.fJProj = JavaCore.create((IProject)project);
        BaseConfigurationBlock.UpdateAdapter adapter = new BaseConfigurationBlock.UpdateAdapter(this);
        if (this.fJProj != null) {
            this.fAptEnabledField = new SelectionButtonDialogField(32);
            this.fAptEnabledField.setDialogFieldListener((IDialogFieldListener)adapter);
            this.fAptEnabledField.setLabelText(Messages.AptConfigurationBlock_enable);
        } else {
            this.fAptEnabledField = null;
        }
        this.fGenSrcDirField = new StringDialogField();
        this.fGenSrcDirField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fGenSrcDirField.setLabelText(Messages.AptConfigurationBlock_generatedSrcDir);
        String[] buttons = new String[]{Messages.AptConfigurationBlock_add, Messages.AptConfigurationBlock_edit, Messages.AptConfigurationBlock_remove};
        ProcessorOptionsAdapter optionsAdapter = new ProcessorOptionsAdapter();
        this.fProcessorOptionsField = new ListDialogField((IListAdapter)optionsAdapter, buttons, (ILabelProvider)new ProcessorOptionsLabelProvider());
        this.fProcessorOptionsField.setDialogFieldListener((IDialogFieldListener)optionsAdapter);
        this.fProcessorOptionsField.setRemoveButtonIndex(2);
        String[] columnHeaders = new String[]{Messages.AptConfigurationBlock_key, Messages.AptConfigurationBlock_value};
        this.fProcessorOptionsField.setTableColumns(new ListDialogField.ColumnsDescription(columnHeaders, true));
        this.fProcessorOptionsField.setViewerSorter((ViewerSorter)new ProcessorOptionSorter());
        this.fProcessorOptionsField.setLabelText(Messages.AptConfigurationBlock_options);
        this.updateControls();
        if (this.fProcessorOptionsField.getSize() > 0) {
            this.fProcessorOptionsField.selectFirstElement();
        } else {
            this.fProcessorOptionsField.enableButton(1, false);
        }
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return workspaceSettings ? null : super.getFullBuildDialogStrings(workspaceSettings);
    }

    private List<ProcessorOption> getListElements() {
        return this.fProcessorOptionsField.getElements();
    }

    private List<ProcessorOption> getListSelection() {
        return this.fProcessorOptionsField.getSelectedElements();
    }

    private void editOrAddProcessorOption(ProcessorOption original) {
        ProcessorOptionInputDialog dialog = new ProcessorOptionInputDialog(this.getShell(), original, this.getListElements());
        if (dialog.open() == 0) {
            if (original != null) {
                this.fProcessorOptionsField.replaceElement((Object)original, (Object)dialog.getResult());
            } else {
                this.fProcessorOptionsField.addElement((Object)dialog.getResult());
            }
        }
    }

    @Override
    protected Control createContents(Composite parent) {
        DialogField[] dialogFieldArray;
        this.setShell(parent.getShell());
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.fBlockControl = new Composite(parent, 0);
        this.fBlockControl.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fBlockControl.setLayout((Layout)layout);
        if (this.fAptEnabledField != null) {
            DialogField[] dialogFieldArray2 = new DialogField[3];
            dialogFieldArray2[0] = this.fAptEnabledField;
            dialogFieldArray2[1] = this.fGenSrcDirField;
            dialogFieldArray = dialogFieldArray2;
            dialogFieldArray2[2] = this.fProcessorOptionsField;
        } else {
            DialogField[] dialogFieldArray3 = new DialogField[2];
            dialogFieldArray3[0] = this.fGenSrcDirField;
            dialogFieldArray = dialogFieldArray3;
            dialogFieldArray3[1] = this.fProcessorOptionsField;
        }
        DialogField[] fields = dialogFieldArray;
        LayoutUtil.doDefaultLayout((Composite)this.fBlockControl, (DialogField[])fields, (boolean)true, (int)-1, (int)-1);
        LayoutUtil.setHorizontalGrabbing((Control)this.fProcessorOptionsField.getListControl(null));
        Label description = new Label(this.fBlockControl, 64);
        description.setText(Messages.AptConfigurationBlock_classpathAddedAutomaticallyNote);
        GridData gdLabel = new GridData(256);
        gdLabel.horizontalSpan = 2;
        gdLabel.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(60);
        description.setLayoutData((Object)gdLabel);
        Dialog.applyDialogFont((Control)this.fBlockControl);
        this.validateSettings(null, null, null);
        return this.fBlockControl;
    }

    @Override
    protected void cacheOriginalValues() {
        super.cacheOriginalValues();
        this.fOriginalProcOptions = AptConfig.getRawProcessorOptions((IJavaProject)this.fJProj);
        this.fOriginalGenSrcDir = AptConfig.getGenSrcDir((IJavaProject)this.fJProj);
        this.fOriginalAptEnabled = AptConfig.isEnabled((IJavaProject)this.fJProj);
    }

    @Override
    protected void initContents() {
        this.loadProcessorOptions(this.fJProj);
    }

    @Override
    protected void saveSettings() {
        List<ProcessorOption> elements = this.fJProj != null && !this.fBlockControl.isEnabled() ? Collections.emptyList() : this.getListElements();
        this.saveProcessorOptions(elements);
        super.saveSettings();
        if (this.fAptProject != null) {
            if (!this.fOriginalGenSrcDir.equals(this.fGenSrcDirField.getText())) {
                this.fAptProject.preferenceChanged("org.eclipse.jdt.apt.genSrcDir");
            }
            if (this.fOriginalAptEnabled != this.fAptEnabledField.isSelected()) {
                this.fAptProject.preferenceChanged("org.eclipse.jdt.apt.aptEnabled");
            }
        }
    }

    @Override
    protected boolean settingsChanged(IScopeContext currContext) {
        HashMap<String, String> savedProcOptions = new HashMap<String, String>(this.fOriginalProcOptions);
        for (ProcessorOption o : this.getListElements()) {
            String savedVal = (String)savedProcOptions.get(o.key);
            if (savedVal != null && savedVal.equals(o.value)) {
                savedProcOptions.remove(o.key);
                continue;
            }
            return true;
        }
        if (!savedProcOptions.isEmpty()) {
            return true;
        }
        return super.settingsChanged(currContext);
    }

    @Override
    protected void validateSettings(BaseConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        IStatus status = null;
        status = this.validateGenSrcDir();
        if (status.getSeverity() == 0) {
            status = this.validateProcessorOptions();
        }
        this.fContext.statusChanged(status);
    }

    private IStatus validateGenSrcDir() {
        IFolder folder;
        String dirName = this.fGenSrcDirField.getText();
        if (!AptConfig.validateGenSrcDir((IJavaProject)this.fJProj, (String)dirName)) {
            return new StatusInfo(4, Messages.AptConfigurationBlock_genSrcDirMustBeValidRelativePath);
        }
        if (this.fJProj != null && !dirName.equals(this.fOriginalGenSrcDir) && (folder = this.fJProj.getProject().getFolder(dirName)) != null && folder.exists() && !folder.isDerived()) {
            return new StatusInfo(2, Messages.AptConfigurationBlock_warningContentsMayBeDeleted);
        }
        return new StatusInfo();
    }

    private IStatus validateProcessorOptions() {
        List<ProcessorOption> elements = this.getListElements();
        for (ProcessorOption o : elements) {
            if (!AptConfig.isAutomaticProcessorOption((String)o.key)) continue;
            return new StatusInfo(2, String.valueOf(Messages.AptConfigurationBlock_warningIgnoredOptions) + ": " + o.key);
        }
        return new StatusInfo();
    }

    @Override
    protected void updateControls() {
        String str;
        if (this.fAptEnabledField != null) {
            boolean aptEnabled = Boolean.valueOf(this.getValue(KEY_APTENABLED));
            this.fAptEnabledField.setSelection(aptEnabled);
        }
        this.fGenSrcDirField.setText((str = this.getValue(KEY_GENSRCDIR)) == null ? "" : str);
    }

    @Override
    protected final void updateModel(DialogField field) {
        if (this.fAptEnabledField != null && field == this.fAptEnabledField) {
            String newVal = String.valueOf(this.fAptEnabledField.isSelected());
            this.setValue(KEY_APTENABLED, newVal);
        } else if (field == this.fGenSrcDirField) {
            String newVal = this.fGenSrcDirField.getText();
            this.setValue(KEY_GENSRCDIR, newVal);
        }
        this.validateSettings(null, null, null);
    }

    private void saveProcessorOptions(List<ProcessorOption> elements) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(elements.size());
        for (ProcessorOption o : elements) {
            map.put(o.key, o.value);
        }
        AptConfig.setProcessorOptions(map, (IJavaProject)this.fJProj);
    }

    private void loadProcessorOptions(IJavaProject jproj) {
        ArrayList<ProcessorOption> options = new ArrayList<ProcessorOption>();
        Map parsedOptions = AptConfig.getRawProcessorOptions((IJavaProject)jproj);
        for (Map.Entry entry : parsedOptions.entrySet()) {
            ProcessorOption o = new ProcessorOption();
            o.key = (String)entry.getKey();
            o.value = (String)entry.getValue();
            options.add(o);
        }
        this.fProcessorOptionsField.setElements(options);
    }

    @Override
    public void performDefaults() {
        if (this.fJProj != null) {
            this.loadProcessorOptions(null);
        } else {
            this.fProcessorOptionsField.removeAllElements();
        }
        super.performDefaults();
    }

    private class ProcessorOptionsAdapter
    implements IListAdapter,
    IDialogFieldListener {
        ProcessorOptionsAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    AptConfigurationBlock.this.editOrAddProcessorOption(null);
                    break;
                }
                case 1: {
                    this.tryToEdit(field);
                }
            }
        }

        public void selectionChanged(ListDialogField field) {
            List selectedElements = field.getSelectedElements();
            field.enableButton(1, this.canEdit((DialogField)field, selectedElements));
        }

        public void doubleClicked(ListDialogField field) {
            this.tryToEdit(field);
        }

        public void dialogFieldChanged(DialogField field) {
            AptConfigurationBlock.this.updateModel(field);
        }

        private boolean canEdit(DialogField field, List selectedElements) {
            if (!field.isEnabled()) {
                return false;
            }
            return selectedElements.size() == 1;
        }

        private void tryToEdit(ListDialogField field) {
            List selection = AptConfigurationBlock.this.getListSelection();
            if (this.canEdit((DialogField)field, selection)) {
                AptConfigurationBlock.this.editOrAddProcessorOption((ProcessorOption)selection.get(0));
            }
        }
    }

    public static class ProcessorOption {
        public String key;
        public String value;
    }

    private static class ProcessorOptionSorter
    extends ViewerSorter {
        ProcessorOptionSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.collator.compare(((ProcessorOption)e1).key, ((ProcessorOption)e2).key);
        }
    }

    private class ProcessorOptionsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ProcessorOptionsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ProcessorOption o = (ProcessorOption)element;
            if (columnIndex == 0) {
                return o.key;
            }
            if (columnIndex == 1) {
                return o.value;
            }
            return "";
        }
    }
}

