/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.dnd;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.navigator.CustomAndExpression;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.dnd.SkeletonCommonDropAssistant;
import org.eclipse.ui.internal.navigator.extensions.INavigatorContentExtPtConstants;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;

public final class CommonDropAdapterDescriptor
implements INavigatorContentExtPtConstants {
    private final IConfigurationElement element;
    private final INavigatorContentDescriptor contentDescriptor;
    private Expression dropExpr;

    CommonDropAdapterDescriptor(IConfigurationElement aConfigElement, INavigatorContentDescriptor aContentDescriptor) {
        this.element = aConfigElement;
        this.contentDescriptor = aContentDescriptor;
        this.init();
    }

    private void init() {
        IConfigurationElement[] children = this.element.getChildren("possibleDropTargets");
        if (children.length == 1) {
            this.dropExpr = new CustomAndExpression(children[0]);
        }
    }

    public boolean isDragElementSupported(Object anElement) {
        return this.contentDescriptor.isPossibleChild(anElement);
    }

    public boolean areDragElementsSupported(IStructuredSelection aSelection) {
        if (aSelection.isEmpty()) {
            return false;
        }
        return this.contentDescriptor.arePossibleChildren(aSelection);
    }

    public boolean isDropElementSupported(Object anElement) {
        if (this.dropExpr != null && anElement != null) {
            try {
                return this.dropExpr.evaluate((IEvaluationContext)new EvaluationContext(null, anElement)) == EvaluationResult.TRUE;
            }
            catch (CoreException e) {
                NavigatorPlugin.logError(0, e.getMessage(), e);
            }
        }
        return false;
    }

    public CommonDropAdapterAssistant createDropAssistant() {
        try {
            return (CommonDropAdapterAssistant)this.element.createExecutableExtension("class");
        }
        catch (CoreException e) {
            NavigatorPlugin.logError(0, e.getMessage(), e);
        }
        catch (RuntimeException re) {
            NavigatorPlugin.logError(0, re.getMessage(), re);
        }
        return SkeletonCommonDropAssistant.INSTANCE;
    }

    public INavigatorContentDescriptor getContentDescriptor() {
        return this.contentDescriptor;
    }
}

