/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.Arrays;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class UpdateActiveFiltersOperation
extends AbstractOperation {
    private String[] filterIdsToActivate;
    private final CommonViewer commonViewer;
    private final INavigatorContentService contentService;

    public UpdateActiveFiltersOperation(CommonViewer aCommonViewer, String[] theActiveFilterIds) {
        super(CommonNavigatorMessages.UpdateFiltersOperation_Update_CommonViewer_Filter_);
        Assert.isNotNull((Object)theActiveFilterIds);
        this.commonViewer = aCommonViewer;
        this.contentService = this.commonViewer.getNavigatorContentService();
        this.filterIdsToActivate = theActiveFilterIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        boolean updateFilterActivation = false;
        Arrays.sort(this.filterIdsToActivate);
        try {
            this.commonViewer.getControl().setRedraw(false);
            INavigatorFilterService filterService = this.contentService.getFilterService();
            ICommonFilterDescriptor[] visibleFilterDescriptors = filterService.getVisibleFilterDescriptors();
            int i = 0;
            while (i < visibleFilterDescriptors.length && !updateFilterActivation) {
                int indexofFilterIdToBeActivated = Arrays.binarySearch(this.filterIdsToActivate, visibleFilterDescriptors[i].getId());
                if (indexofFilterIdToBeActivated >= 0 ^ filterService.isActive(visibleFilterDescriptors[i].getId())) {
                    updateFilterActivation = true;
                }
                ++i;
            }
            if (updateFilterActivation) {
                filterService.setActiveFilterIds(this.filterIdsToActivate);
                filterService.persistFilterActivationState();
                this.commonViewer.resetFilters();
                ViewerFilter[] visibleFilters = filterService.getVisibleFilters(true);
                int i2 = 0;
                while (i2 < visibleFilters.length) {
                    this.commonViewer.addFilter(visibleFilters[i2]);
                    ++i2;
                }
                this.commonViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.commonViewer.getControl().setRedraw(true);
            throw throwable;
        }
        this.commonViewer.getControl().setRedraw(true);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }
}

