/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.wizards;

import java.util.Iterator;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;

public class CommonWizardDescriptor {
    private static final String ATT_WIZARD_ID = "wizardId";
    private static final String ATT_TYPE = "type";
    private static final String TAG_ENABLEMENT = "enablement";
    private String wizardId;
    private String type;
    private Expression enablement;
    private IConfigurationElement configElement;

    public CommonWizardDescriptor(IConfigurationElement aConfigElement) throws WorkbenchException {
        this.configElement = aConfigElement;
        this.init();
    }

    public boolean isEnabledFor(IStructuredSelection aStructuredSelection) {
        if (this.enablement == null) {
            return false;
        }
        EvaluationContext context = null;
        Iterator elements = aStructuredSelection.iterator();
        while (elements.hasNext()) {
            context = new EvaluationContext(null, elements.next());
            try {
                if (this.enablement.evaluate((IEvaluationContext)context) != EvaluationResult.FALSE) continue;
                return false;
            }
            catch (CoreException e) {
                NavigatorPlugin.log(4, 0, e.getMessage(), e);
                return false;
            }
        }
        return true;
    }

    public boolean isEnabledFor(Object anElement) {
        if (this.enablement == null || anElement == null) {
            return false;
        }
        try {
            return this.enablement.evaluate((IEvaluationContext)new EvaluationContext(null, anElement)) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            NavigatorPlugin.log(4, 0, e.getMessage(), e);
            return false;
        }
    }

    void init() throws WorkbenchException {
        this.wizardId = this.configElement.getAttribute(ATT_WIZARD_ID);
        this.type = this.configElement.getAttribute(ATT_TYPE);
        if (this.wizardId == null || this.wizardId.length() == 0) {
            throw new WorkbenchException("Missing attribute: wizardId in common wizard extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
        if (this.type == null || this.type.length() == 0) {
            throw new WorkbenchException("Missing attribute: type in common wizard extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
        IConfigurationElement[] children = this.configElement.getChildren(TAG_ENABLEMENT);
        if (children.length == 1) {
            try {
                this.enablement = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), children[0]);
            }
            catch (CoreException e) {
                NavigatorPlugin.log(4, 0, e.getMessage(), e);
            }
        } else if (children.length > 1) {
            throw new WorkbenchException("More than one element: enablement in common wizard extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
    }

    public String getWizardId() {
        return this.wizardId;
    }

    public String getType() {
        return this.type;
    }
}

