/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.internal.navigator.wizards.CommonWizardDescriptor;

public class CommonWizardDescriptorManager {
    private static final CommonWizardDescriptorManager INSTANCE = new CommonWizardDescriptorManager();
    private static boolean isInitialized = false;
    private static final String[] NO_DESCRIPTORS = new String[0];
    public static final String WIZARD_TYPE_NEW = "new";
    private Map commonWizardDescriptors = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonWizardDescriptorManager getInstance() {
        if (isInitialized) {
            return INSTANCE;
        }
        CommonWizardDescriptorManager commonWizardDescriptorManager = INSTANCE;
        synchronized (commonWizardDescriptorManager) {
            if (!isInitialized) {
                INSTANCE.init();
                isInitialized = true;
            }
        }
        return INSTANCE;
    }

    private void init() {
        new CommonWizardRegistry().readRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommonWizardDescriptor(CommonWizardDescriptor aDesc) {
        if (aDesc == null) {
            return;
        }
        Map map = this.commonWizardDescriptors;
        synchronized (map) {
            HashSet<CommonWizardDescriptor> descriptors = (HashSet<CommonWizardDescriptor>)this.commonWizardDescriptors.get(aDesc.getType());
            if (descriptors == null) {
                descriptors = new HashSet<CommonWizardDescriptor>();
                this.commonWizardDescriptors.put(aDesc.getType(), descriptors);
            }
            if (!descriptors.contains(aDesc)) {
                descriptors.add(aDesc);
            }
        }
    }

    public String[] getEnabledCommonWizardDescriptorIds(Object anElement, String aType) {
        Set commonDescriptors = (Set)this.commonWizardDescriptors.get(aType);
        if (commonDescriptors == null) {
            return NO_DESCRIPTORS;
        }
        ArrayList<String> descriptorIds = new ArrayList<String>();
        Iterator commonWizardDescriptorsItr = commonDescriptors.iterator();
        while (commonWizardDescriptorsItr.hasNext()) {
            CommonWizardDescriptor descriptor = (CommonWizardDescriptor)commonWizardDescriptorsItr.next();
            if (descriptor.getWizardId() == null || !descriptor.isEnabledFor(anElement)) continue;
            descriptorIds.add(descriptor.getWizardId());
        }
        String[] wizardIds = new String[descriptorIds.size()];
        return descriptorIds.toArray(wizardIds);
    }

    public String[] getEnabledCommonWizardDescriptorIds(IStructuredSelection aStructuredSelection, String aType) {
        Set commonDescriptors = (Set)this.commonWizardDescriptors.get(aType);
        if (commonDescriptors == null) {
            return NO_DESCRIPTORS;
        }
        ArrayList<String> descriptorIds = new ArrayList<String>();
        Iterator commonWizardDescriptorsItr = commonDescriptors.iterator();
        while (commonWizardDescriptorsItr.hasNext()) {
            CommonWizardDescriptor descriptor = (CommonWizardDescriptor)commonWizardDescriptorsItr.next();
            if (!descriptor.isEnabledFor(aStructuredSelection)) continue;
            descriptorIds.add(descriptor.getWizardId());
        }
        String[] wizardIds = new String[descriptorIds.size()];
        return descriptorIds.toArray(wizardIds);
    }

    private class CommonWizardRegistry
    extends NavigatorContentRegistryReader {
        CommonWizardRegistry() {
        }

        protected boolean readElement(IConfigurationElement anElement) {
            if ("commonWizard".equals(anElement.getName())) {
                try {
                    CommonWizardDescriptorManager.this.addCommonWizardDescriptor(new CommonWizardDescriptor(anElement));
                    return true;
                }
                catch (WorkbenchException e) {
                    NavigatorPlugin.logError(0, e.getMessage(), e);
                }
            }
            return super.readElement(anElement);
        }
    }
}

