/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.util.HelpProperties;
import org.eclipse.help.internal.protocols.HelpURLConnection;
import org.eclipse.help.internal.protocols.HelpURLStreamHandler;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.HTMLSearchParticipant;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.PluginIndex;
import org.eclipse.help.internal.search.PluginVersionInfo;
import org.eclipse.help.internal.search.QueryBuilder;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchManager;
import org.eclipse.help.internal.toc.TocManager;
import org.eclipse.help.internal.util.ResourceLocator;
import org.eclipse.help.search.ISearchIndex;
import org.eclipse.help.search.LuceneSearchParticipant;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class SearchIndex
implements ISearchIndex {
    private IndexReader ir;
    private IndexWriter iw;
    private File indexDir;
    private String locale;
    private String relativePath;
    private TocManager tocManager;
    private AnalyzerDescriptor analyzerDescriptor;
    private PluginVersionInfo docPlugins;
    private HelpProperties indexedDocs;
    public static final String INDEXED_CONTRIBUTION_INFO_FILE = "indexed_contributions";
    public static final String INDEXED_DOCS_FILE = "indexed_docs";
    public static final String DEPENDENCIES_VERSION_FILENAME = "indexed_dependencies";
    public static final String DEPENDENCIES_KEY_LUCENE = "lucene";
    public static final String DEPENDENCIES_KEY_ANALYZER = "analyzer";
    private static final String LUCENE_PLUGIN_ID = "org.apache.lucene";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_INDEX_ID = "index_path";
    private File inconsistencyFile;
    private HTMLSearchParticipant htmlSearchParticipant;
    private IndexSearcher searcher;
    private Object searcherCreateLock = new Object();
    private HelpProperties dependencies;
    private boolean closed = false;
    private Collection searches = new ArrayList();
    private FileLock lock;

    public SearchIndex(String locale, AnalyzerDescriptor analyzerDesc, TocManager tocManager) {
        this(new File(HelpBasePlugin.getConfigurationDirectory(), "index/" + locale), locale, analyzerDesc, tocManager, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearchIndex(File indexDir, String locale, AnalyzerDescriptor analyzerDesc, TocManager tocManager, String relativePath) {
        this.locale = locale;
        this.analyzerDescriptor = analyzerDesc;
        this.tocManager = tocManager;
        this.indexDir = indexDir;
        this.relativePath = relativePath;
        this.inconsistencyFile = new File(indexDir.getParentFile(), String.valueOf(locale) + ".inconsistent");
        this.htmlSearchParticipant = new HTMLSearchParticipant(indexDir.getAbsolutePath());
        if (this.exists()) return;
        try {
            if (!this.tryLock()) return;
            try {
                this.unzipProductIndex();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.releaseLock();
                throw throwable;
            }
            {
                Object var6_8 = null;
                this.releaseLock();
                return;
            }
        }
        catch (OverlappingFileLockException overlappingFileLockException) {}
    }

    public IStatus addDocument(String name, URL url) {
        if (HelpBasePlugin.DEBUG_SEARCH) {
            System.out.println("SearchIndex.addDocument(" + name + ", " + url + ")");
        }
        try {
            Document doc = new Document();
            doc.add(Field.Keyword((String)FIELD_NAME, (String)name));
            this.addExtraFields(doc);
            String pluginId = SearchManager.getPluginId(name);
            if (this.relativePath != null) {
                doc.add(Field.Keyword((String)FIELD_INDEX_ID, (String)this.relativePath));
            }
            LuceneSearchParticipant participant = null;
            HelpURLConnection urlc = new HelpURLConnection(url);
            String id = urlc.getValue("id");
            String pid = urlc.getValue("participantId");
            if (pid != null) {
                participant = BaseHelpSystem.getSearchManager().getGlobalParticipant(pid);
            }
            if (participant == null) {
                participant = BaseHelpSystem.getSearchManager().getParticipant(pluginId, name);
            }
            if (participant != null) {
                IStatus status = participant.addDocument(this, pluginId, name, url, id, doc);
                if (status.getSeverity() == 0) {
                    String filters = doc.get("filters");
                    this.indexedDocs.put(name, filters != null ? filters : "0");
                    if (id != null) {
                        doc.add(Field.UnIndexed((String)"id", (String)id));
                    }
                    if (pid != null) {
                        doc.add(Field.UnIndexed((String)"participantId", (String)pid));
                    }
                    this.iw.addDocument(doc);
                }
                return status;
            }
            IStatus status = this.htmlSearchParticipant.addDocument(this, pluginId, name, url, id, doc);
            if (status.getSeverity() == 0) {
                this.indexedDocs.put(name, "0");
                this.iw.addDocument(doc);
            }
            return status;
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.help.base", 4, "IO exception occurred while adding document " + name + " to index " + this.indexDir.getAbsolutePath() + ".", (Throwable)e);
        }
    }

    protected void addExtraFields(Document doc) {
    }

    public synchronized boolean beginAddBatch(boolean firstOperation) {
        try {
            if (this.iw != null) {
                this.iw.close();
            }
            boolean create = false;
            if (!this.indexDir.exists() || !this.isLuceneCompatible() || !this.isAnalyzerCompatible() || this.inconsistencyFile.exists() && firstOperation) {
                create = true;
                this.indexDir.mkdirs();
                if (!this.indexDir.exists()) {
                    return false;
                }
            }
            this.indexedDocs = new HelpProperties(INDEXED_DOCS_FILE, this.indexDir);
            this.indexedDocs.restore();
            this.setInconsistent(true);
            this.iw = new IndexWriter(this.indexDir, this.analyzerDescriptor.getAnalyzer(), create);
            this.iw.mergeFactor = 20;
            this.iw.maxFieldLength = 1000000;
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError("Exception occurred in search indexing at beginAddBatch.", e);
            return false;
        }
    }

    public synchronized boolean beginDeleteBatch() {
        try {
            if (this.ir != null) {
                this.ir.close();
            }
            this.indexedDocs = new HelpProperties(INDEXED_DOCS_FILE, this.indexDir);
            this.indexedDocs.restore();
            this.setInconsistent(true);
            this.ir = IndexReader.open((File)this.indexDir);
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError("Exception occurred in search indexing at beginDeleteBatch.", e);
            return false;
        }
    }

    public synchronized boolean beginRemoveDuplicatesBatch() {
        try {
            if (this.ir != null) {
                this.ir.close();
            }
            this.ir = IndexReader.open((File)this.indexDir);
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError("Exception occurred in search indexing at beginDeleteBatch.", e);
            return false;
        }
    }

    public IStatus removeDocument(String name) {
        if (HelpBasePlugin.DEBUG_SEARCH) {
            System.out.println("SearchIndex.removeDocument(" + name + ")");
        }
        Term term = new Term(FIELD_NAME, name);
        try {
            this.ir.delete(term);
            this.indexedDocs.remove(name);
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.help.base", 4, "IO exception occurred while removing document " + name + " from index " + this.indexDir.getAbsolutePath() + ".", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public synchronized boolean endAddBatch(boolean optimize, boolean lastOperation) {
        try {
            if (this.iw == null) {
                return false;
            }
            if (optimize) {
                this.iw.optimize();
            }
            this.iw.close();
            this.iw = null;
            this.getDocPlugins().save();
            this.saveDependencies();
            if (lastOperation) {
                this.indexedDocs.save();
                this.indexedDocs = null;
                this.setInconsistent(false);
            }
            if (this.searcher != null) {
                this.searcher.close();
                this.searcher = null;
            }
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError("Exception occurred in search indexing at endAddBatch.", e);
            return false;
        }
    }

    public synchronized boolean endDeleteBatch() {
        try {
            if (this.ir == null) {
                return false;
            }
            this.ir.close();
            this.ir = null;
            this.indexedDocs.save();
            this.indexedDocs = null;
            this.getDocPlugins().save();
            this.saveDependencies();
            if (this.searcher != null) {
                this.searcher.close();
                this.searcher = null;
            }
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError("Exception occurred in search indexing at endDeleteBatch.", e);
            return false;
        }
    }

    public synchronized boolean endRemoveDuplicatesBatch() {
        try {
            if (this.ir == null) {
                return false;
            }
            this.ir.close();
            this.ir = null;
            this.indexedDocs.save();
            this.indexedDocs = null;
            this.getDocPlugins().save();
            this.saveDependencies();
            this.setInconsistent(false);
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError("Exception occurred in search indexing at endDeleteBatch.", e);
            return false;
        }
    }

    public Map merge(PluginIndex[] pluginIndexes, IProgressMonitor monitor) {
        ArrayList<FSDirectory> dirList = new ArrayList<FSDirectory>(pluginIndexes.length);
        HashMap<String, String[]> mergedDocs = new HashMap<String, String[]>();
        int p = 0;
        while (p < pluginIndexes.length) {
            List indexIds = pluginIndexes[p].getIDs();
            List indexPaths = pluginIndexes[p].getPaths();
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            int i = 0;
            while (i < indexPaths.size()) {
                block13: {
                    String indexId = (String)indexIds.get(i);
                    String indexPath = (String)indexPaths.get(i);
                    try {
                        dirList.add(FSDirectory.getDirectory((String)indexPath, (boolean)false));
                    }
                    catch (IOException ioe) {
                        HelpBasePlugin.logError("Help search indexing directory could not be created for directory " + indexPath, ioe);
                        break block13;
                    }
                    if (HelpBasePlugin.DEBUG_SEARCH) {
                        System.out.println("SearchIndex.merge merging indexId=" + indexId + ", indexPath=" + indexPath);
                    }
                    HelpProperties prebuiltDocs = new HelpProperties(INDEXED_DOCS_FILE, new File(indexPath));
                    prebuiltDocs.restore();
                    Set<Object> prebuiltHrefs = prebuiltDocs.keySet();
                    Iterator<Object> it = prebuiltHrefs.iterator();
                    while (it.hasNext()) {
                        String href = (String)it.next();
                        if (i == 0) {
                            mergedDocs.put(href, null);
                            continue;
                        }
                        if (mergedDocs.containsKey(href)) {
                            String[] dups = (String[])mergedDocs.get(href);
                            if (dups == null) {
                                mergedDocs.put(href, new String[]{indexId});
                                continue;
                            }
                            String[] newDups = new String[dups.length + 1];
                            System.arraycopy(dups, 0, newDups, 0, dups.length);
                            newDups[dups.length] = indexId;
                            mergedDocs.put(href, newDups);
                            continue;
                        }
                        mergedDocs.put(href, null);
                    }
                }
                ++i;
            }
            ++p;
        }
        Iterator it = mergedDocs.keySet().iterator();
        while (it.hasNext()) {
            this.indexedDocs.put(it.next(), "0");
        }
        Directory[] luceneDirs = dirList.toArray(new Directory[dirList.size()]);
        try {
            this.iw.addIndexes(luceneDirs);
        }
        catch (IOException ioe) {
            HelpBasePlugin.logError("Merging search indexes failed.", ioe);
            return new HashMap();
        }
        return mergedDocs;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus removeDuplicates(String name, String[] index_paths) {
        TermDocs indexDocs;
        block23: {
            if (HelpBasePlugin.DEBUG_SEARCH) {
                System.out.print("SearchIndex.removeDuplicates(" + name);
                int i = 0;
                while (true) {
                    if (i >= index_paths.length) {
                        System.out.println(")");
                        break;
                    }
                    System.out.print(", " + index_paths[i]);
                    ++i;
                }
            }
            TermDocs hrefDocs = null;
            indexDocs = null;
            Term hrefTerm = new Term(FIELD_NAME, name);
            try {
                try {
                    int i = 0;
                    while (i < index_paths.length) {
                        Term indexTerm = new Term(FIELD_INDEX_ID, index_paths[i]);
                        if (i == 0) {
                            hrefDocs = this.ir.termDocs(hrefTerm);
                            indexDocs = this.ir.termDocs(indexTerm);
                        } else {
                            hrefDocs.seek(hrefTerm);
                            indexDocs.seek(indexTerm);
                        }
                        this.removeDocuments(hrefDocs, indexDocs);
                        ++i;
                    }
                }
                catch (IOException ioe) {
                    Status status = new Status(4, "org.eclipse.help.base", 4, "IO exception occurred while removing duplicates of document " + name + " from index " + this.indexDir.getAbsolutePath() + ".", (Throwable)ioe);
                    Object var8_11 = null;
                    if (hrefDocs != null) {
                        try {
                            hrefDocs.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (indexDocs == null) return status;
                    try {
                        indexDocs.close();
                        return status;
                    }
                    catch (IOException iOException) {}
                    return status;
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (hrefDocs != null) {
                    try {}
                    catch (IOException iOException) {}
                    hrefDocs.close();
                }
                if (indexDocs == null) throw throwable;
                try {}
                catch (IOException iOException) {}
                indexDocs.close();
                throw throwable;
                throw throwable;
            }
            {
                Object var8_13 = null;
                if (hrefDocs == null) break block23;
            }
            try {}
            catch (IOException iOException) {}
            hrefDocs.close();
        }
        if (indexDocs == null) return Status.OK_STATUS;
        try {}
        catch (IOException iOException) {
            return Status.OK_STATUS;
        }
        indexDocs.close();
        return Status.OK_STATUS;
    }

    private void removeDocuments(TermDocs doc1, TermDocs docs2) throws IOException {
        if (!doc1.next()) {
            return;
        }
        if (!docs2.next()) {
            return;
        }
        while (true) {
            if (doc1.doc() < docs2.doc() ? !doc1.skipTo(docs2.doc()) && !doc1.next() : doc1.doc() > docs2.doc() && !docs2.skipTo(doc1.doc()) && !doc1.next()) {
                return;
            }
            if (doc1.doc() != docs2.doc()) continue;
            this.ir.delete(doc1.doc());
            if (!doc1.next()) {
                return;
            }
            if (!docs2.next()) break;
        }
    }

    public boolean exists() {
        return this.indexDir.exists() && !this.isInconsistent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void search(ISearchQuery searchQuery, ISearchHitCollector collector) throws QueryTooComplexException {
        block13: {
            block12: {
                try {
                    block11: {
                        try {
                            if (this.closed) {
                                Object var7_3 = null;
                                break block11;
                            }
                            this.registerSearch(Thread.currentThread());
                            if (this.closed) {
                                break block12;
                            }
                            QueryBuilder queryBuilder = new QueryBuilder(searchQuery.getSearchWord(), this.analyzerDescriptor);
                            Query luceneQuery = queryBuilder.getLuceneQuery(searchQuery.getFieldNames(), searchQuery.isFieldSearch());
                            String highlightTerms = queryBuilder.gethighlightTerms();
                            if (luceneQuery != null) {
                                if (this.searcher == null) {
                                    this.openSearcher();
                                }
                                Hits hits = this.searcher.search(luceneQuery);
                                collector.addHits(SearchManager.asList(hits), highlightTerms);
                            }
                            break block13;
                        }
                        catch (BooleanQuery.TooManyClauses tooManyClauses) {
                            throw new QueryTooComplexException();
                        }
                        catch (QueryTooComplexException qe) {
                            throw qe;
                        }
                        catch (Exception e) {
                            HelpBasePlugin.logError("Exception occurred performing search for: " + searchQuery.getSearchWord() + ".", e);
                            break block13;
                        }
                    }
                    this.unregisterSearch(Thread.currentThread());
                    return;
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    this.unregisterSearch(Thread.currentThread());
                    throw throwable;
                }
            }
            Object var7_4 = null;
            this.unregisterSearch(Thread.currentThread());
            return;
        }
        Object var7_6 = null;
        this.unregisterSearch(Thread.currentThread());
    }

    public String getLocale() {
        return this.locale;
    }

    public PluginVersionInfo getDocPlugins() {
        if (this.docPlugins == null) {
            HashSet totalIds = new HashSet();
            Collection docPluginsIds = this.tocManager.getContributingPlugins();
            Set additionalPluginIds = BaseHelpSystem.getSearchManager().getPluginsWithSearchParticipants();
            totalIds.addAll(docPluginsIds);
            totalIds.addAll(additionalPluginIds);
            this.docPlugins = new PluginVersionInfo(INDEXED_CONTRIBUTION_INFO_FILE, totalIds, this.indexDir, !this.exists());
        }
        return this.docPlugins;
    }

    public void setDocPlugins(PluginVersionInfo docPlugins) {
        this.docPlugins = docPlugins;
    }

    public HelpProperties getIndexedDocs() {
        HelpProperties indexedDocs = new HelpProperties(INDEXED_DOCS_FILE, this.indexDir);
        if (this.exists()) {
            indexedDocs.restore();
        }
        return indexedDocs;
    }

    private HelpProperties getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new HelpProperties(DEPENDENCIES_VERSION_FILENAME, this.indexDir);
            this.dependencies.restore();
        }
        return this.dependencies;
    }

    private boolean isLuceneCompatible() {
        String usedLuceneVersion = this.getDependencies().getProperty(DEPENDENCIES_KEY_LUCENE);
        return this.isLuceneCompatible(usedLuceneVersion);
    }

    public boolean isLuceneCompatible(String luceneVersion) {
        if (luceneVersion == null) {
            return false;
        }
        String currentLuceneVersion = "";
        Bundle lucenePluginDescriptor = Platform.getBundle((String)LUCENE_PLUGIN_ID);
        if (lucenePluginDescriptor != null) {
            currentLuceneVersion = String.valueOf(currentLuceneVersion) + (String)lucenePluginDescriptor.getHeaders().get("Bundle-Version");
        }
        if (currentLuceneVersion.equals(luceneVersion)) {
            return true;
        }
        Version version = new Version(currentLuceneVersion);
        Version currentVersion = new Version(luceneVersion);
        return version.getMajor() == currentVersion.getMajor() && version.getMinor() == currentVersion.getMinor() && version.getMicro() == currentVersion.getMicro();
    }

    private boolean isAnalyzerCompatible() {
        String usedAnalyzer = this.getDependencies().getProperty(DEPENDENCIES_KEY_ANALYZER);
        return this.isAnalyzerCompatible(usedAnalyzer);
    }

    public boolean isAnalyzerCompatible(String analyzerId) {
        if (analyzerId == null) {
            analyzerId = "";
        }
        return this.analyzerDescriptor.isCompatible(analyzerId);
    }

    private void saveDependencies() {
        this.getDependencies().put(DEPENDENCIES_KEY_ANALYZER, this.analyzerDescriptor.getId());
        Bundle luceneBundle = Platform.getBundle((String)LUCENE_PLUGIN_ID);
        if (luceneBundle != null) {
            String luceneBundleVersion = "" + luceneBundle.getHeaders().get("Bundle-Version");
            this.getDependencies().put(DEPENDENCIES_KEY_LUCENE, luceneBundleVersion);
        } else {
            this.getDependencies().put(DEPENDENCIES_KEY_LUCENE, "");
        }
        this.getDependencies().save();
    }

    public boolean isInconsistent() {
        if (this.inconsistencyFile.exists()) {
            return true;
        }
        return !this.isLuceneCompatible() || !this.isAnalyzerCompatible();
    }

    public void setInconsistent(boolean inconsistent) {
        if (inconsistent) {
            try {
                FileOutputStream fos = new FileOutputStream(this.inconsistencyFile);
                fos.close();
            }
            catch (IOException iOException) {}
        } else {
            this.inconsistencyFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSearcher() throws IOException {
        Object object = this.searcherCreateLock;
        synchronized (object) {
            if (this.searcher == null) {
                this.searcher = new IndexSearcher(this.indexDir.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        this.closed = true;
        var1_1 = this.searches;
        synchronized (var1_1) {
            while (true) {
                if (this.searches.size() <= 0) {
                    if (this.searcher == null) return;
                    ** try [egrp 2[TRYBLOCK] [1 : 44->54)] { 
lbl9:
                    // 1 sources

                    break;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException v0) {}
            }
            {
                this.searcher.close();
            }
lbl17:
            // 1 sources

            catch (IOException v1) {}
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unzipProductIndex() {
        String indexPluginId = HelpBasePlugin.getDefault().getPluginPreferences().getString("productIndex");
        if (indexPluginId == null) return;
        if (indexPluginId.length() <= 0) {
            return;
        }
        InputStream zipIn = ResourceLocator.openFromPlugin((String)indexPluginId, (String)"doc_index.zip", (String)this.getLocale());
        if (zipIn == null) {
            return;
        }
        this.setInconsistent(true);
        this.cleanOldIndex();
        byte[] buf = new byte[8192];
        File destDir = this.indexDir;
        ZipInputStream zis = new ZipInputStream(zipIn);
        FileOutputStream fos = null;
        try {
            block19: {
                try {
                    block10: while (true) {
                        ZipEntry zEntry;
                        if ((zEntry = zis.getNextEntry()) == null) {
                            if (HelpBasePlugin.DEBUG_SEARCH) {
                                System.out.println("SearchIndex: Prebuilt index restored to " + destDir + ".");
                            }
                            this.setInconsistent(false);
                        }
                        if (zEntry.isDirectory()) {
                            new File(destDir, zEntry.getName()).mkdirs();
                            continue;
                        }
                        String filePath = zEntry.getName();
                        int lastSeparator = filePath.lastIndexOf("/");
                        String fileDir = "";
                        if (lastSeparator >= 0) {
                            fileDir = filePath.substring(0, lastSeparator);
                        }
                        new File(destDir, fileDir).mkdirs();
                        File outFile = new File(destDir, filePath);
                        fos = new FileOutputStream(outFile);
                        int n = 0;
                        while (true) {
                            if ((n = zis.read(buf)) < 0) {
                                fos.close();
                                continue block10;
                            }
                            fos.write(buf, 0, n);
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    if (fos == null) break block19;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                zipIn.close();
                if (zis == null) throw throwable;
                zis.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        zipIn.close();
        if (zis == null) return;
        zis.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanOldIndex() {
        IndexWriter cleaner = null;
        try {
            try {
                cleaner = new IndexWriter(this.indexDir, this.analyzerDescriptor.getAnalyzer(), true);
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            try {
                if (cleaner == null) throw throwable;
                cleaner.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (cleaner == null) return;
        cleaner.close();
    }

    public synchronized boolean needsUpdating() {
        if (!this.exists()) {
            return true;
        }
        return this.getDocPlugins().detectChange();
    }

    public TocManager getTocManager() {
        return this.tocManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSearch(Thread t) {
        Collection collection = this.searches;
        synchronized (collection) {
            this.searches.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterSearch(Thread t) {
        Collection collection = this.searches;
        synchronized (collection) {
            this.searches.remove(t);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean tryLock() throws OverlappingFileLockException {
        if (this.lock != null) {
            throw new OverlappingFileLockException();
        }
        File lockFile = this.getLockFile();
        lockFile.getParentFile().mkdirs();
        try {
            RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
            FileLock l = raf.getChannel().tryLock();
            if (l != null) {
                this.lock = l;
                return true;
            }
        }
        catch (IOException iOException) {
            this.lock = null;
        }
        return false;
    }

    private File getLockFile() {
        return new File(this.indexDir.getParentFile(), String.valueOf(this.locale) + ".lock");
    }

    public synchronized boolean deleteLockFile() {
        if (this.lock != null) {
            return false;
        }
        File lockFile = this.getLockFile();
        if (lockFile.exists()) {
            return lockFile.delete();
        }
        return true;
    }

    public synchronized void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.channel().close();
            }
            catch (IOException iOException) {}
            this.lock = null;
        }
    }

    public static String getIndexableHref(String url) {
        String fileName = url.toLowerCase(Locale.ENGLISH);
        if (!(fileName.endsWith(".htm") || fileName.endsWith(".html") || fileName.endsWith(".txt") || fileName.endsWith(".xml"))) {
            if (fileName.indexOf(".htm#") >= 0 || fileName.indexOf(".html#") >= 0 || fileName.indexOf(".xml#") >= 0) {
                url = url.substring(0, url.lastIndexOf(35));
            } else {
                return BaseHelpSystem.getSearchManager().isIndexable(url) ? url : null;
            }
        }
        return url;
    }

    public static URL getIndexableURL(String locale, String url) {
        return SearchIndex.getIndexableURL(locale, url, null, null);
    }

    public static URL getIndexableURL(String locale, String url, String id, String participantId) {
        if (participantId == null) {
            url = SearchIndex.getIndexableHref(url);
        }
        if (url == null) {
            return null;
        }
        try {
            StringBuffer query = new StringBuffer();
            query.append("?");
            query.append("lang=" + locale);
            if (id != null) {
                query.append("&id=" + id);
            }
            if (participantId != null) {
                query.append("&participantId=" + participantId);
            }
            return new URL("help", null, -1, String.valueOf(url) + query.toString(), HelpURLStreamHandler.getDefault());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public IStatus addDocument(String pluginId, String name, URL url, String id, Document doc) {
        LuceneSearchParticipant participant = BaseHelpSystem.getSearchManager().getParticipant(pluginId, name);
        if (participant != null) {
            return participant.addDocument(this, pluginId, name, url, id, doc);
        }
        return this.htmlSearchParticipant.addDocument(this, pluginId, name, url, id, doc);
    }
}

