/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSModelProviderAction;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizard;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class CommitAction
extends CVSModelProviderAction
implements IPropertyChangeListener {
    public CommitAction(final ISynchronizePageConfiguration configuration) {
        super(configuration);
        configuration.addPropertyChangeListener((IPropertyChangeListener)this);
        configuration.addActionContribution(new SynchronizePageActionGroup(){

            public void dispose() {
                configuration.removePropertyChangeListener((IPropertyChangeListener)CommitAction.this);
                super.dispose();
            }
        });
    }

    protected String getBundleKeyPrefix() {
        return "WorkspaceCommitAction.";
    }

    protected boolean isEnabledForSelection(IStructuredSelection selection) {
        return this.internalIsEnabled(selection);
    }

    private boolean internalIsEnabled(IStructuredSelection selection) {
        int mode = this.getConfiguration().getMode();
        if (mode == 2 || mode == 4) {
            return this.getResourceMappings(selection).length > 0;
        }
        return false;
    }

    private ResourceMapping[] getResourceMappings(IStructuredSelection selection) {
        ArrayList<ResourceMapping> mappings = new ArrayList<ResourceMapping>();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            ResourceMapping mapping = Utils.getResourceMapping(element);
            if (mapping == null) continue;
            mappings.add(mapping);
        }
        return mappings.toArray(new ResourceMapping[mappings.size()]);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.getConfiguration() && event.getProperty() == "org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE") {
            this.setEnabled(this.internalIsEnabled(this.getStructuredSelection()));
        }
    }

    public void run() {
        ResourceMapping[] mappings = this.getResourceMappings(this.getStructuredSelection());
        Shell shell = this.getConfiguration().getSite().getShell();
        try {
            CommitWizard.run(this.getConfiguration().getSite().getPart(), shell, mappings);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }
}

