/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.repo.RefreshRemoteProjectSelectionPage;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;

public class RefreshRemoteProjectWizard
extends Wizard {
    private static final int INITIAL_WIDTH = 300;
    private static final int INITIAL_HEIGHT = 350;
    private ICVSRepositoryLocation root;
    private ICVSRemoteResource[] rootFolders;
    private RefreshRemoteProjectSelectionPage projectSelectionPage;
    private IDialogSettings settings;

    public static boolean execute(Shell shell, final ICVSRepositoryLocation root) {
        final ICVSRemoteResource[][] rootFolders = new ICVSRemoteResource[1][0];
        rootFolders[0] = null;
        try {
            new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        rootFolders[0] = CVSUIPlugin.getPlugin().getRepositoryManager().getFoldersForTag(root, CVSTag.DEFAULT, monitor);
                    }
                    catch (CVSException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(shell, null, null, e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        RefreshRemoteProjectWizard wizard = new RefreshRemoteProjectWizard(root, rootFolders[0]);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setMinimumPageSize(300, 350);
        return dialog.open() == 0;
    }

    public RefreshRemoteProjectWizard(ICVSRepositoryLocation root, ICVSRemoteResource[] rootFolders) {
        this.root = root;
        this.rootFolders = rootFolders;
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        this.settings = workbenchSettings.getSection("RefreshRemoteProjectWizard");
        if (this.settings == null) {
            this.settings = workbenchSettings.addNewSection("RefreshRemoteProjectWizard");
        }
        this.setWindowTitle(CVSUIMessages.RefreshRemoteProjectWizard_title);
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        ImageDescriptor substImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.png");
        this.projectSelectionPage = new RefreshRemoteProjectSelectionPage("ProjectSelectionPage", CVSUIMessages.RefreshRemoteProjectSelectionPage_pageTitle, substImage, CVSUIMessages.RefreshRemoteProjectSelectionPage_pageDescription, this.settings, this.root, this.rootFolders);
        this.addPage((IWizardPage)this.projectSelectionPage);
    }

    public boolean performFinish() {
        final ICVSRemoteResource[] selectedFolders = this.projectSelectionPage.getSelectedRemoteProject();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
                    manager.run(new IRunnableWithProgress(this, manager, selectedFolders){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ RepositoryManager val$manager;
                        private final /* synthetic */ ICVSRemoteResource[] val$selectedFolders;
                        {
                            this.this$1 = var1_1;
                            this.val$manager = repositoryManager;
                            this.val$selectedFolders = iCVSRemoteResourceArray;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(null, 100);
                            ICVSRemoteResource[] failedFolders = RefreshRemoteProjectWizard.access$0(2.access$0(this.this$1), this.val$manager, this.val$selectedFolders, false, Policy.subMonitorFor(monitor, 80));
                            if (failedFolders.length > 0 && RefreshRemoteProjectWizard.access$1(2.access$0(this.this$1), failedFolders)) {
                                RefreshRemoteProjectWizard.access$0(2.access$0(this.this$1), this.val$manager, failedFolders, true, Policy.subMonitorFor(monitor, 20));
                            }
                            monitor.done();
                        }
                    }, monitor);
                }

                static /* synthetic */ RefreshRemoteProjectWizard access$0(2 var0) {
                    return var0.RefreshRemoteProjectWizard.this;
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ICVSRemoteResource[] internalRefresh(RepositoryManager manager, ICVSRemoteResource[] selectedFolders, boolean recurse, IProgressMonitor monitor) throws InvocationTargetException {
        ICVSRemoteResource[] iCVSRemoteResourceArray;
        ArrayList<ICVSRemoteResource> failedFolders = new ArrayList<ICVSRemoteResource>();
        monitor.beginTask(null, 100 * selectedFolders.length);
        try {
            try {
                int i = 0;
                while (true) {
                    CVSTag[] tags;
                    if (i >= selectedFolders.length) {
                        iCVSRemoteResourceArray = failedFolders.toArray(new ICVSRemoteResource[failedFolders.size()]);
                        Object var9_11 = null;
                        break;
                    }
                    ICVSRemoteResource resource = selectedFolders[i];
                    if (resource instanceof ICVSFolder && (tags = manager.refreshDefinedTags((ICVSFolder)resource, recurse, true, Policy.subMonitorFor(monitor, 100))).length == 0) {
                        failedFolders.add(resource);
                    }
                    ++i;
                }
            }
            catch (TeamException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return iCVSRemoteResourceArray;
    }

    private boolean promptForDeepRefresh(final ICVSRemoteResource[] folders) {
        final boolean[] prompt = new boolean[1];
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(RefreshRemoteProjectWizard.this.getShell(), CVSUIMessages.RefreshRemoteProjectWizard_0, null, RefreshRemoteProjectWizard.this.getNoTagsMessage(folders), 2, new String[]{CVSUIMessages.RefreshRemoteProjectWizard_1, CVSUIMessages.RefreshRemoteProjectWizard_2}, 1);
                int code = dialog.open();
                if (code == 0) {
                    prompt[0] = true;
                }
            }
        });
        return prompt[0];
    }

    private String getNoTagsMessage(ICVSRemoteResource[] folders) {
        if (folders.length == 1) {
            return NLS.bind((String)CVSUIMessages.RefreshRemoteProjectWizard_3, (Object[])new String[]{folders[0].getRepositoryRelativePath()});
        }
        return NLS.bind((String)CVSUIMessages.RefreshRemoteProjectWizard_4, (Object[])new String[]{Integer.toString(folders.length)});
    }

    static /* synthetic */ ICVSRemoteResource[] access$0(RefreshRemoteProjectWizard refreshRemoteProjectWizard, RepositoryManager repositoryManager, ICVSRemoteResource[] iCVSRemoteResourceArray, boolean bl, IProgressMonitor iProgressMonitor) throws InvocationTargetException {
        return refreshRemoteProjectWizard.internalRefresh(repositoryManager, iCVSRemoteResourceArray, bl, iProgressMonitor);
    }

    static /* synthetic */ boolean access$1(RefreshRemoteProjectWizard refreshRemoteProjectWizard, ICVSRemoteResource[] iCVSRemoteResourceArray) {
        return refreshRemoteProjectWizard.promptForDeepRefresh(iCVSRemoteResourceArray);
    }
}

