/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public final class GenerateHashCodeEqualsOperation
implements IWorkspaceRunnable {
    private static final String JAVA_UTIL_ARRAYS = "java.util.Arrays";
    private static final String BOOLEAN_TRUE_CONSTANT = "1231";
    private static final String BOOLEAN_FALSE_CONSTANT = "1237";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String METHODNAME_GETCLASS = "getClass";
    private static final String METHODNAME_EQUALS = "equals";
    private static final String METHODNAME_HASH_CODE = "hashCode";
    private static final String PRIME_NUMBER = "31";
    private static final String INITIAL_HASHCODE_VALUE = "1";
    private static final String VARIABLE_NAME_DOUBLE_TEMPORARY = "temp";
    private static final String VARIABLE_NAME_PRIME = "PRIME";
    private static final String VARIABLE_NAME_RESULT = "result";
    private static final String VARIABLE_NAME_EQUALS_PARAM = "obj";
    private static final String VARIABLE_NAME_HASHCODE_PARAM = "array";
    private static final String VARIABLE_NAME_EQUALS_CASTED = "other";
    private static final String VARIABLE_NAME_INDEX = "index";
    private final boolean fApply;
    private TextEdit fEdit = null;
    private final IJavaElement fInsert;
    private final IVariableBinding[] fFields;
    private final boolean fForce;
    private final boolean fSave;
    private final CodeGenerationSettings fSettings;
    private final ITypeBinding fType;
    private final CompilationUnit fUnit;
    private final CompilationUnitRewrite fRewrite;
    private final AST fAst;
    private int fDoubleCount;
    private Set fCustomHashCodeTypes = new HashSet();
    static /* synthetic */ Class class$0;

    public GenerateHashCodeEqualsOperation(ITypeBinding type, IVariableBinding[] fields, CompilationUnit unit, IJavaElement insert, CodeGenerationSettings settings, boolean force, boolean apply, boolean save) {
        Assert.isNotNull(type);
        Assert.isNotNull(fields);
        Assert.isNotNull(unit);
        Assert.isNotNull(settings);
        this.fType = type;
        this.fInsert = insert;
        this.fUnit = unit;
        this.fFields = fields;
        this.fSettings = settings;
        this.fSave = save;
        this.fApply = apply;
        this.fDoubleCount = 0;
        this.fRewrite = new CompilationUnitRewrite((ICompilationUnit)this.fUnit.getJavaElement(), this.fUnit);
        this.fForce = force;
        this.fAst = this.fRewrite.getAST();
    }

    public final TextEdit getResultingEdit() {
        return this.fEdit;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            block30: {
                monitor.beginTask("", 1);
                monitor.setTaskName(CodeGenerationMessages.GenerateHashCodeEqualsOperation_description);
                this.fCustomHashCodeTypes.clear();
                AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.findDeclaration((IBinding)this.fType, (ASTNode)this.fRewrite.getRoot());
                ListRewrite rewriter = this.fRewrite.getASTRewrite().getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty());
                if (this.fType != null && rewriter != null) {
                    ICompilationUnit cu = (ICompilationUnit)this.fUnit.getJavaElement();
                    ITextFileBuffer buffer = null;
                    IDocument document = null;
                    try {
                        block29: {
                            CompilationUnitChange change;
                            TextEdit edit;
                            ITypeBinding binding;
                            if (!JavaModelUtil.isPrimary(cu)) {
                                document = new Document(cu.getBuffer().getContents());
                            } else {
                                buffer = RefactoringFileBuffers.acquire(cu);
                                document = buffer.getDocument();
                            }
                            ASTNode insertion = null;
                            if (this.fInsert instanceof IMethod) {
                                ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fRewrite.getRoot(), ((IMethod)this.fInsert).getNameRange());
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                insertion = ASTNodes.getParent(aSTNode, clazz);
                            }
                            BodyDeclaration toReplace = null;
                            if (this.fForce) {
                                List list = (List)declaration.getStructuralProperty((StructuralPropertyDescriptor)declaration.getBodyDeclarationsProperty());
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    ITypeBinding[] bindings;
                                    MethodDeclaration method;
                                    IMethodBinding binding2;
                                    BodyDeclaration bodyDecl = (BodyDeclaration)iterator.next();
                                    if (!(bodyDecl instanceof MethodDeclaration) || (binding2 = (method = (MethodDeclaration)bodyDecl).resolveBinding()) == null || !binding2.getName().equals(METHODNAME_EQUALS) || (bindings = binding2.getParameterTypes()).length != 1 || !bindings[0].getQualifiedName().equals(JAVA_LANG_OBJECT)) continue;
                                    toReplace = bodyDecl;
                                    break;
                                }
                            }
                            MethodDeclaration equalsMethod = this.createEqualsMethod();
                            this.addMethod(rewriter, insertion, equalsMethod, toReplace);
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            toReplace = null;
                            if (this.fForce) {
                                List list = (List)declaration.getStructuralProperty((StructuralPropertyDescriptor)declaration.getBodyDeclarationsProperty());
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    ITypeBinding[] bindings;
                                    MethodDeclaration method;
                                    BodyDeclaration bodyDecl = (BodyDeclaration)iterator.next();
                                    if (!(bodyDecl instanceof MethodDeclaration) || (binding = (method = (MethodDeclaration)bodyDecl).resolveBinding()) == null || !binding.getName().equals(METHODNAME_HASH_CODE) || (bindings = binding.getParameterTypes()).length != 0) continue;
                                    toReplace = bodyDecl;
                                    break;
                                }
                            }
                            MethodDeclaration hashCodeMethod = this.createHashCodeMethod();
                            this.addMethod(rewriter, (ASTNode)equalsMethod, hashCodeMethod, toReplace);
                            ASTNode previous = null;
                            Iterator iterator = this.fCustomHashCodeTypes.iterator();
                            while (iterator.hasNext()) {
                                boolean found = false;
                                binding = (ITypeBinding)iterator.next();
                                ITypeBinding typeBinding = declaration.resolveBinding();
                                if (typeBinding != null) {
                                    IMethodBinding[] bindings = typeBinding.getDeclaredMethods();
                                    int index = 0;
                                    while (index < bindings.length) {
                                        ITypeBinding parameter;
                                        IMethodBinding method = bindings[index];
                                        ITypeBinding[] parameters = method.getParameterTypes();
                                        if (method.getName().equals(METHODNAME_HASH_CODE) && parameters.length == 1 && (found = !(parameter = parameters[0]).isPrimitive() ? parameter.getQualifiedName().equals(JAVA_LANG_OBJECT) : parameter.isEqualTo((IBinding)binding))) break;
                                        ++index;
                                    }
                                }
                                if (found) continue;
                                MethodDeclaration helperDecl = this.createHashCodeHelper(binding);
                                this.addHelper(rewriter, previous, helperDecl);
                            }
                            CompilationUnitChange result = this.fRewrite.createChange();
                            if (result instanceof CompilationUnitChange && (edit = (change = result).getEdit()) != null) {
                                try {
                                    this.fEdit = edit;
                                    if (this.fApply) {
                                        edit.apply(document, 2);
                                    }
                                    if (!this.fSave) break block29;
                                    if (buffer != null) {
                                        buffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
                                    } else {
                                        cu.getBuffer().setContents(document.get());
                                    }
                                }
                                catch (Exception exception) {
                                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, exception.getLocalizedMessage(), (Throwable)exception));
                                }
                            }
                        }
                        Object var21_26 = null;
                        if (buffer == null) break block30;
                    }
                    catch (Throwable throwable) {
                        Object var21_25 = null;
                        if (buffer == null) throw throwable;
                        RefactoringFileBuffers.release(cu);
                        throw throwable;
                    }
                    RefactoringFileBuffers.release(cu);
                }
            }
            Object var23_29 = null;
        }
        catch (Throwable throwable) {
            Object var23_28 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private void addHelper(ListRewrite rewriter, ASTNode insertion, MethodDeclaration stub) {
        if (insertion != null) {
            rewriter.insertBefore((ASTNode)stub, insertion, null);
        } else {
            rewriter.insertFirst((ASTNode)stub, null);
        }
    }

    private void addMethod(ListRewrite rewriter, ASTNode insertion, MethodDeclaration stub, BodyDeclaration replace) {
        if (replace != null) {
            rewriter.replace((ASTNode)replace, (ASTNode)stub, null);
        } else if (insertion != null) {
            rewriter.insertBefore((ASTNode)stub, insertion, null);
        } else {
            rewriter.insertLast((ASTNode)stub, null);
        }
    }

    private MethodDeclaration createHashCodeMethod() throws CoreException {
        MethodDeclaration hashCodeMethod = this.fAst.newMethodDeclaration();
        hashCodeMethod.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAst, 1));
        hashCodeMethod.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
        hashCodeMethod.setConstructor(false);
        hashCodeMethod.setReturnType2((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        Block body = this.fAst.newBlock();
        hashCodeMethod.setBody(body);
        VariableDeclarationFragment frag = this.fAst.newVariableDeclarationFragment();
        frag.setName(this.fAst.newSimpleName(VARIABLE_NAME_PRIME));
        frag.setInitializer((Expression)this.fAst.newNumberLiteral(PRIME_NUMBER));
        VariableDeclarationStatement primeNumberDeclaration = this.fAst.newVariableDeclarationStatement(frag);
        primeNumberDeclaration.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        primeNumberDeclaration.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        body.statements().add(primeNumberDeclaration);
        VariableDeclarationFragment fragment = this.fAst.newVariableDeclarationFragment();
        fragment.setName(this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        VariableDeclarationStatement resultDeclaration = this.fAst.newVariableDeclarationStatement(fragment);
        resultDeclaration.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        body.statements().add(resultDeclaration);
        if (this.needsNoSuperCall(this.fType, METHODNAME_HASH_CODE, new ITypeBinding[0])) {
            fragment.setInitializer((Expression)this.fAst.newNumberLiteral(INITIAL_HASHCODE_VALUE));
        } else {
            SuperMethodInvocation invoc = this.fAst.newSuperMethodInvocation();
            invoc.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
            fragment.setInitializer((Expression)invoc);
        }
        int i = 0;
        while (i < this.fFields.length) {
            if (this.fFields[i].getType().isPrimitive()) {
                Statement[] sts = this.createAddSimpleHashCode(this.fFields[i].getType(), new IHashCodeAccessProvider(){

                    public Expression getThisAccess(String name) {
                        return GenerateHashCodeEqualsOperation.this.getThisAccessForHashCode(name);
                    }
                }, this.fFields[i].getName(), false);
                int j = 0;
                while (j < sts.length) {
                    body.statements().add(sts[j]);
                    ++j;
                }
            } else if (this.fFields[i].getType().isArray()) {
                body.statements().add(this.createAddArrayHashCode(this.fFields[i]));
            } else {
                body.statements().add(this.createAddQualifiedHashCode(this.fFields[i]));
            }
            ++i;
        }
        ReturnStatement endReturn = this.fAst.newReturnStatement();
        endReturn.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        body.statements().add(endReturn);
        if (this.fSettings != null) {
            ITypeBinding object = this.fAst.resolveWellKnownType(JAVA_LANG_OBJECT);
            IMethodBinding[] objms = object.getDeclaredMethods();
            IMethodBinding objectMethod = null;
            int i2 = 0;
            while (i2 < objms.length) {
                if (objms[i2].getName().equals(METHODNAME_HASH_CODE) && objms[i2].getParameterTypes().length == 0) {
                    objectMethod = objms[i2];
                }
                ++i2;
            }
            this.createMethodComment(hashCodeMethod, objectMethod);
        }
        return hashCodeMethod;
    }

    private Statement[] createAddSimpleHashCode(ITypeBinding type, IHashCodeAccessProvider provider, String name, boolean singleTemp) {
        ArrayList<Object> statements = new ArrayList<Object>();
        if (!type.isPrimitive()) {
            ConditionalExpression ce = this.fAst.newConditionalExpression();
            InfixExpression exp = this.fAst.newInfixExpression();
            ArrayAccess access = this.fAst.newArrayAccess();
            access.setArray((Expression)this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
            access.setIndex((Expression)this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
            exp.setLeftOperand((Expression)access);
            exp.setOperator(InfixExpression.Operator.EQUALS);
            exp.setRightOperand((Expression)this.fAst.newNullLiteral());
            ce.setExpression((Expression)exp);
            ce.setThenExpression((Expression)this.fAst.newNumberLiteral("0"));
            MethodInvocation invoc = this.fAst.newMethodInvocation();
            access = this.fAst.newArrayAccess();
            access.setArray((Expression)this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
            access.setIndex((Expression)this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
            invoc.setExpression((Expression)access);
            invoc.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
            ce.setElseExpression((Expression)invoc);
            statements.add(this.prepareAssignment(this.parenthesize((Expression)ce)));
        } else if (this.isPrimitiveType(type, PrimitiveType.BOOLEAN)) {
            ConditionalExpression ce = this.fAst.newConditionalExpression();
            ce.setExpression(provider.getThisAccess(name));
            ce.setThenExpression((Expression)this.fAst.newNumberLiteral(BOOLEAN_TRUE_CONSTANT));
            ce.setElseExpression((Expression)this.fAst.newNumberLiteral(BOOLEAN_FALSE_CONSTANT));
            statements.add(this.prepareAssignment(this.parenthesize((Expression)ce)));
        } else if (this.isPrimitiveType(type, new PrimitiveType.Code[]{PrimitiveType.CHAR, PrimitiveType.INT, PrimitiveType.SHORT})) {
            statements.add(this.prepareAssignment(provider.getThisAccess(name)));
        } else if (this.isPrimitiveType(type, PrimitiveType.FLOAT)) {
            statements.add(this.prepareAssignment(this.createFloatInvocation(provider.getThisAccess(name))));
        } else if (this.isPrimitiveType(type, PrimitiveType.LONG)) {
            statements.add(this.prepareAssignment(this.createShiftAssignment(provider.getThisAccess(name), provider.getThisAccess(name))));
        } else if (this.isPrimitiveType(type, PrimitiveType.DOUBLE)) {
            VariableDeclarationFragment fragment = null;
            if (singleTemp || this.fDoubleCount == 0) {
                fragment = this.fAst.newVariableDeclarationFragment();
                fragment.setName(this.fAst.newSimpleName(VARIABLE_NAME_DOUBLE_TEMPORARY));
                VariableDeclarationStatement st2 = this.fAst.newVariableDeclarationStatement(fragment);
                st2.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.LONG));
                statements.add(st2);
            }
            ++this.fDoubleCount;
            Expression comparison = this.createDoubleInvocation(provider.getThisAccess(name));
            if (singleTemp) {
                fragment.setInitializer(comparison);
            } else {
                Assignment ass = this.fAst.newAssignment();
                ass.setLeftHandSide((Expression)this.fAst.newSimpleName(VARIABLE_NAME_DOUBLE_TEMPORARY));
                ass.setRightHandSide(comparison);
                statements.add(this.fAst.newExpressionStatement((Expression)ass));
            }
            statements.add(this.prepareAssignment(this.createShiftAssignment((Expression)this.fAst.newSimpleName(VARIABLE_NAME_DOUBLE_TEMPORARY), (Expression)this.fAst.newSimpleName(VARIABLE_NAME_DOUBLE_TEMPORARY))));
        }
        return statements.toArray(new Statement[statements.size()]);
    }

    private Statement createAddArrayHashCode(IVariableBinding binding) {
        MethodInvocation invoc = this.fAst.newMethodInvocation();
        if (JavaModelUtil.is50OrHigher(this.fRewrite.getCu().getJavaProject())) {
            invoc.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
            invoc.setExpression((Expression)this.getQualifiedName(JAVA_UTIL_ARRAYS));
            invoc.arguments().add(this.getThisAccessForHashCode(binding.getName()));
        } else {
            invoc.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
            IJavaElement element = this.fType.getJavaElement();
            if (element != null && !"".equals(element.getElementName())) {
                invoc.setExpression((Expression)this.fAst.newSimpleName(element.getElementName()));
            }
            invoc.arguments().add(this.getThisAccessForHashCode(binding.getName()));
            ITypeBinding type = binding.getType().getElementType();
            if (!Bindings.isVoidType(type)) {
                if (type.isPrimitive() && binding.getType().getDimensions() < 2) {
                    this.fCustomHashCodeTypes.add(type);
                } else {
                    this.fCustomHashCodeTypes.add(this.fAst.resolveWellKnownType(JAVA_LANG_OBJECT));
                }
            }
        }
        return this.prepareAssignment((Expression)invoc);
    }

    private MethodDeclaration createHashCodeHelper(ITypeBinding binding) {
        Assert.isTrue(!binding.isArray());
        MethodDeclaration hashCodeMethod = this.fAst.newMethodDeclaration();
        hashCodeMethod.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAst, 10));
        hashCodeMethod.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
        hashCodeMethod.setConstructor(false);
        hashCodeMethod.setReturnType2((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        List parameters = hashCodeMethod.parameters();
        SingleVariableDeclaration hashCodeParam = this.fAst.newSingleVariableDeclaration();
        if (!binding.isPrimitive()) {
            hashCodeParam.setType((Type)this.fAst.newArrayType((Type)this.fAst.newSimpleType(this.getQualifiedName(JAVA_LANG_OBJECT)), 1));
        } else {
            hashCodeParam.setType((Type)this.fAst.newArrayType((Type)this.fAst.newPrimitiveType(PrimitiveType.toCode((String)binding.getName())), 1));
        }
        hashCodeParam.setName(this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
        parameters.add(hashCodeParam);
        Block body = this.fAst.newBlock();
        hashCodeMethod.setBody(body);
        VariableDeclarationFragment frag = this.fAst.newVariableDeclarationFragment();
        frag.setName(this.fAst.newSimpleName(VARIABLE_NAME_PRIME));
        frag.setInitializer((Expression)this.fAst.newNumberLiteral(PRIME_NUMBER));
        VariableDeclarationStatement primeNumberDeclaration = this.fAst.newVariableDeclarationStatement(frag);
        primeNumberDeclaration.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        primeNumberDeclaration.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        body.statements().add(primeNumberDeclaration);
        IfStatement ifStatement = this.fAst.newIfStatement();
        InfixExpression newInfixExpression = this.fAst.newInfixExpression();
        newInfixExpression.setLeftOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
        newInfixExpression.setRightOperand((Expression)this.fAst.newNullLiteral());
        newInfixExpression.setOperator(InfixExpression.Operator.EQUALS);
        ifStatement.setExpression((Expression)newInfixExpression);
        ReturnStatement returnStatement = this.fAst.newReturnStatement();
        returnStatement.setExpression((Expression)this.fAst.newNumberLiteral("0"));
        ifStatement.setThenStatement((Statement)returnStatement);
        body.statements().add(ifStatement);
        VariableDeclarationFragment resultFragment = this.fAst.newVariableDeclarationFragment();
        resultFragment.setName(this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        resultFragment.setInitializer((Expression)this.fAst.newNumberLiteral(INITIAL_HASHCODE_VALUE));
        VariableDeclarationStatement resultDeclaration = this.fAst.newVariableDeclarationStatement(resultFragment);
        resultDeclaration.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        body.statements().add(resultDeclaration);
        ForStatement forStatement = this.fAst.newForStatement();
        VariableDeclarationFragment indexDeclaration = this.fAst.newVariableDeclarationFragment();
        indexDeclaration.setName(this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
        indexDeclaration.setInitializer((Expression)this.fAst.newNumberLiteral("0"));
        VariableDeclarationExpression declExpression = this.fAst.newVariableDeclarationExpression(indexDeclaration);
        declExpression.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        forStatement.initializers().add(declExpression);
        InfixExpression infixExpr = this.fAst.newInfixExpression();
        infixExpr.setLeftOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
        FieldAccess access = this.fAst.newFieldAccess();
        access.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
        access.setName(this.fAst.newSimpleName("length"));
        infixExpr.setRightOperand((Expression)access);
        infixExpr.setOperator(InfixExpression.Operator.LESS);
        forStatement.setExpression((Expression)infixExpr);
        PostfixExpression postfixExpr = this.fAst.newPostfixExpression();
        postfixExpr.setOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
        postfixExpr.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpr);
        body.statements().add(forStatement);
        Block forBody = this.fAst.newBlock();
        Statement[] statements = this.createAddSimpleHashCode(binding, new IHashCodeAccessProvider(){

            public Expression getThisAccess(String name) {
                ArrayAccess a = GenerateHashCodeEqualsOperation.this.fAst.newArrayAccess();
                a.setArray((Expression)GenerateHashCodeEqualsOperation.this.fAst.newSimpleName(GenerateHashCodeEqualsOperation.VARIABLE_NAME_HASHCODE_PARAM));
                a.setIndex((Expression)GenerateHashCodeEqualsOperation.this.fAst.newSimpleName(name));
                return a;
            }
        }, VARIABLE_NAME_INDEX, true);
        int index = 0;
        while (index < statements.length) {
            forBody.statements().add(statements[index]);
            ++index;
        }
        forStatement.setBody((Statement)forBody);
        ReturnStatement endReturn = this.fAst.newReturnStatement();
        endReturn.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        body.statements().add(endReturn);
        if (this.fSettings != null && this.fSettings.createComments) {
            Javadoc javadoc = this.fAst.newJavadoc();
            TagElement tagComment = this.fAst.newTagElement();
            TextElement text = this.fAst.newTextElement();
            text.setText(CodeGenerationMessages.GenerateHashCodeEqualsOperation_hash_code_comment);
            tagComment.fragments().add(text);
            javadoc.tags().add(tagComment);
            TagElement tagParam = this.fAst.newTagElement();
            tagParam.setTagName(CodeGenerationMessages.GenerateHashCodeEqualsOperation_tag_param);
            tagParam.fragments().add(this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
            text = this.fAst.newTextElement();
            text.setText(CodeGenerationMessages.GenerateHashCodeEqualsOperation_hash_code_argument);
            tagParam.fragments().add(text);
            javadoc.tags().add(tagParam);
            TagElement tagReturn = this.fAst.newTagElement();
            tagReturn.setTagName(CodeGenerationMessages.GenerateHashCodeEqualsOperation_tag_return);
            text = this.fAst.newTextElement();
            text.setText(CodeGenerationMessages.GenerateHashCodeEqualsOperation_return_comment);
            tagReturn.fragments().add(text);
            javadoc.tags().add(tagReturn);
            hashCodeMethod.setJavadoc(javadoc);
        }
        return hashCodeMethod;
    }

    private Statement createAddQualifiedHashCode(IVariableBinding binding) {
        MethodInvocation invoc = this.fAst.newMethodInvocation();
        invoc.setExpression(this.getThisAccessForHashCode(binding.getName()));
        invoc.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
        InfixExpression expr = this.fAst.newInfixExpression();
        expr.setOperator(InfixExpression.Operator.EQUALS);
        expr.setLeftOperand(this.getThisAccessForHashCode(binding.getName()));
        expr.setRightOperand((Expression)this.fAst.newNullLiteral());
        ConditionalExpression cexpr = this.fAst.newConditionalExpression();
        cexpr.setThenExpression((Expression)this.fAst.newNumberLiteral("0"));
        cexpr.setElseExpression((Expression)invoc);
        cexpr.setExpression(this.parenthesize((Expression)expr));
        return this.prepareAssignment(this.parenthesize((Expression)cexpr));
    }

    private Expression createShiftAssignment(Expression shift1, Expression shift2) {
        CastExpression ce = this.fAst.newCastExpression();
        ce.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        InfixExpression unsignedShiftRight = this.fAst.newInfixExpression();
        unsignedShiftRight.setLeftOperand(shift1);
        unsignedShiftRight.setRightOperand((Expression)this.fAst.newNumberLiteral("32"));
        unsignedShiftRight.setOperator(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED);
        InfixExpression xor = this.fAst.newInfixExpression();
        xor.setLeftOperand(shift2);
        xor.setRightOperand(this.parenthesize((Expression)unsignedShiftRight));
        xor.setOperator(InfixExpression.Operator.XOR);
        ce.setExpression(this.parenthesize((Expression)xor));
        return ce;
    }

    private Statement prepareAssignment(Expression rightHand) {
        InfixExpression mul = this.fAst.newInfixExpression();
        mul.setLeftOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_PRIME));
        mul.setRightOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        mul.setOperator(InfixExpression.Operator.TIMES);
        Assignment ass = this.fAst.newAssignment();
        ass.setLeftHandSide((Expression)this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        InfixExpression plus = this.fAst.newInfixExpression();
        plus.setLeftOperand((Expression)mul);
        plus.setOperator(InfixExpression.Operator.PLUS);
        plus.setRightOperand(rightHand);
        ass.setRightHandSide((Expression)plus);
        return this.fAst.newExpressionStatement((Expression)ass);
    }

    private MethodDeclaration createEqualsMethod() throws CoreException {
        MethodDeclaration equalsMethodDeclaration = this.fAst.newMethodDeclaration();
        equalsMethodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAst, 1));
        equalsMethodDeclaration.setName(this.fAst.newSimpleName(METHODNAME_EQUALS));
        equalsMethodDeclaration.setConstructor(false);
        equalsMethodDeclaration.setReturnType2((Type)this.fAst.newPrimitiveType(PrimitiveType.BOOLEAN));
        List parameters = equalsMethodDeclaration.parameters();
        SingleVariableDeclaration equalsParam = this.fAst.newSingleVariableDeclaration();
        equalsParam.setType((Type)this.fAst.newSimpleType((Name)this.fAst.newSimpleName("Object")));
        equalsParam.setName(this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
        parameters.add(equalsParam);
        Block body = this.fAst.newBlock();
        equalsMethodDeclaration.setBody(body);
        body.statements().add(this.createReturningIfStatement((Expression)this.fAst.newThisExpression(), (Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM), InfixExpression.Operator.EQUALS, true));
        if (this.needsNoSuperCall(this.fType, METHODNAME_EQUALS, new ITypeBinding[]{this.fAst.resolveWellKnownType(JAVA_LANG_OBJECT)})) {
            body.statements().add(this.createReturningIfStatement((Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM), (Expression)this.fAst.newNullLiteral(), InfixExpression.Operator.EQUALS, false));
        } else {
            SuperMethodInvocation superEqualsCall = this.fAst.newSuperMethodInvocation();
            superEqualsCall.setName(this.fAst.newSimpleName(METHODNAME_EQUALS));
            superEqualsCall.arguments().add(this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
            PrefixExpression pe = this.fAst.newPrefixExpression();
            pe.setOperator(PrefixExpression.Operator.NOT);
            pe.setOperand((Expression)superEqualsCall);
            IfStatement superEqualsIf = this.fAst.newIfStatement();
            superEqualsIf.setExpression((Expression)pe);
            superEqualsIf.setThenStatement((Statement)this.getReturnFalse());
            body.statements().add(superEqualsIf);
        }
        MethodInvocation thisClass = this.fAst.newMethodInvocation();
        thisClass.setName(this.fAst.newSimpleName(METHODNAME_GETCLASS));
        MethodInvocation objGetClass = this.fAst.newMethodInvocation();
        objGetClass.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
        objGetClass.setName(this.fAst.newSimpleName(METHODNAME_GETCLASS));
        body.statements().add(this.createReturningIfStatement((Expression)thisClass, (Expression)objGetClass, InfixExpression.Operator.NOT_EQUALS, false));
        VariableDeclarationFragment sd = this.fAst.newVariableDeclarationFragment();
        sd.setName(this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_CASTED));
        CastExpression cast = this.fAst.newCastExpression();
        cast.setType((Type)this.fAst.newSimpleType((Name)this.fAst.newSimpleName(this.fType.getName())));
        cast.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
        sd.setInitializer((Expression)cast);
        VariableDeclarationStatement otherDeclaration = this.fAst.newVariableDeclarationStatement(sd);
        otherDeclaration.setType((Type)this.fAst.newSimpleType((Name)this.fAst.newSimpleName(this.fType.getName())));
        otherDeclaration.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        body.statements().add(otherDeclaration);
        int i = 0;
        while (i < this.fFields.length) {
            if (this.fFields[i].getType().isPrimitive()) {
                body.statements().add(this.createSimpleComparison(this.fFields[i]));
            } else if (this.fFields[i].getType().isArray()) {
                body.statements().add(this.createArrayComparison(this.fFields[i].getName()));
            } else {
                body.statements().add(this.createQualifiedComparison(this.fFields[i].getName()));
            }
            ++i;
        }
        ReturnStatement endReturn = this.fAst.newReturnStatement();
        endReturn.setExpression((Expression)this.fAst.newBooleanLiteral(true));
        body.statements().add(endReturn);
        if (this.fSettings != null) {
            ITypeBinding object = this.fAst.resolveWellKnownType(JAVA_LANG_OBJECT);
            IMethodBinding[] objms = object.getDeclaredMethods();
            IMethodBinding objectMethod = null;
            int i2 = 0;
            while (i2 < objms.length) {
                if (objms[i2].getName().equals(METHODNAME_EQUALS) && objms[i2].getParameterTypes().length == 1 && objms[i2].getParameterTypes()[0].getQualifiedName().equals(JAVA_LANG_OBJECT)) {
                    objectMethod = objms[i2];
                }
                ++i2;
            }
            this.createMethodComment(equalsMethodDeclaration, objectMethod);
        }
        return equalsMethodDeclaration;
    }

    private Statement createSimpleComparison(IVariableBinding binding) {
        if (this.isPrimitiveType(binding.getType(), PrimitiveType.FLOAT)) {
            return this.createReturningIfStatement(this.createFloatInvocation(this.getThisAccessForEquals(binding.getName())), this.createFloatInvocation(this.getOtherAccess(binding.getName())), InfixExpression.Operator.NOT_EQUALS, false);
        }
        if (this.isPrimitiveType(binding.getType(), PrimitiveType.DOUBLE)) {
            return this.createReturningIfStatement(this.createDoubleInvocation(this.getThisAccessForEquals(binding.getName())), this.createDoubleInvocation(this.getOtherAccess(binding.getName())), InfixExpression.Operator.NOT_EQUALS, false);
        }
        return this.createReturningIfStatement(this.getThisAccessForEquals(binding.getName()), this.getOtherAccess(binding.getName()), InfixExpression.Operator.NOT_EQUALS, false);
    }

    private Statement createArrayComparison(String name) {
        MethodInvocation invoc = this.fAst.newMethodInvocation();
        invoc.setName(this.fAst.newSimpleName(METHODNAME_EQUALS));
        invoc.setExpression((Expression)this.getQualifiedName(JAVA_UTIL_ARRAYS));
        invoc.arguments().add(this.getThisAccessForEquals(name));
        invoc.arguments().add(this.getOtherAccess(name));
        PrefixExpression pe = this.fAst.newPrefixExpression();
        pe.setOperator(PrefixExpression.Operator.NOT);
        pe.setOperand((Expression)invoc);
        IfStatement ifSt = this.fAst.newIfStatement();
        ifSt.setExpression((Expression)pe);
        ifSt.setThenStatement((Statement)this.getReturnFalse());
        return ifSt;
    }

    private Statement createQualifiedComparison(String name) {
        InfixExpression newCondition = this.fAst.newInfixExpression();
        newCondition.setOperator(InfixExpression.Operator.EQUALS);
        newCondition.setLeftOperand(this.getThisAccessForEquals(name));
        newCondition.setRightOperand((Expression)this.fAst.newNullLiteral());
        InfixExpression notEqNull = this.fAst.newInfixExpression();
        notEqNull.setOperator(InfixExpression.Operator.NOT_EQUALS);
        notEqNull.setLeftOperand(this.getOtherAccess(name));
        notEqNull.setRightOperand((Expression)this.fAst.newNullLiteral());
        IfStatement thenPart = this.fAst.newIfStatement();
        thenPart.setExpression((Expression)notEqNull);
        thenPart.setThenStatement((Statement)this.getReturnFalse());
        Block thenPart2 = this.fAst.newBlock();
        thenPart2.statements().add(thenPart);
        MethodInvocation invoc = this.fAst.newMethodInvocation();
        invoc.setName(this.fAst.newSimpleName(METHODNAME_EQUALS));
        invoc.setExpression(this.getThisAccessForEquals(name));
        invoc.arguments().add(this.getOtherAccess(name));
        PrefixExpression pe = this.fAst.newPrefixExpression();
        pe.setOperator(PrefixExpression.Operator.NOT);
        pe.setOperand((Expression)invoc);
        IfStatement elsePart = this.fAst.newIfStatement();
        elsePart.setExpression((Expression)pe);
        elsePart.setThenStatement((Statement)this.getReturnFalse());
        IfStatement isNull = this.fAst.newIfStatement();
        isNull.setExpression((Expression)newCondition);
        isNull.setThenStatement((Statement)thenPart2);
        isNull.setElseStatement((Statement)elsePart);
        return isNull;
    }

    private Statement createReturningIfStatement(Expression left, Expression right, InfixExpression.Operator operator, boolean whatToReturn) {
        InfixExpression newCondition = this.fAst.newInfixExpression();
        newCondition.setOperator(operator);
        newCondition.setLeftOperand(left);
        newCondition.setRightOperand(right);
        IfStatement firstIf = this.fAst.newIfStatement();
        firstIf.setExpression((Expression)newCondition);
        ReturnStatement returner = this.fAst.newReturnStatement();
        returner.setExpression((Expression)this.fAst.newBooleanLiteral(whatToReturn));
        firstIf.setThenStatement((Statement)returner);
        return firstIf;
    }

    private void createMethodComment(MethodDeclaration newDeclaration, IMethodBinding copyFrom) throws CoreException {
        String string;
        if (this.fSettings.createComments && (string = CodeGeneration.getMethodComment(this.fRewrite.getCu(), this.fType.getQualifiedName(), newDeclaration, copyFrom, StubUtility.getLineDelimiterUsed((IJavaElement)this.fRewrite.getCu()))) != null) {
            Javadoc javadoc = (Javadoc)this.fRewrite.getASTRewrite().createStringPlaceholder(string, 29);
            newDeclaration.setJavadoc(javadoc);
        }
        if (this.fSettings.overrideAnnotation && JavaModelUtil.is50OrHigher(this.fUnit.getJavaElement().getJavaProject())) {
            StubUtility2.addOverrideAnnotation(this.fRewrite.getASTRewrite(), newDeclaration, copyFrom);
        }
    }

    private boolean needsNoSuperCall(ITypeBinding typeBinding, String name, ITypeBinding[] parameters) {
        Assert.isNotNull(typeBinding);
        IMethodBinding binding = GenerateHashCodeEqualsOperation.findMethodInHierarchy(typeBinding, name, parameters);
        if (binding != null) {
            return binding.getDeclaringClass().getQualifiedName().equals(JAVA_LANG_OBJECT);
        }
        return true;
    }

    public static IMethodBinding findMethodInType(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        if (type.isPrimitive()) {
            return null;
        }
        IMethodBinding[] methods = type.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (parameters == null ? methodName.equals(methods[i].getName()) && !Modifier.isAbstract((int)methods[i].getModifiers()) : Bindings.isEqualMethod(methods[i], methodName, parameters) && !Modifier.isAbstract((int)methods[i].getModifiers())) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInHierarchy(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        IMethodBinding method = GenerateHashCodeEqualsOperation.findMethodInType(type, methodName, parameters);
        if (method != null) {
            return method;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (method = GenerateHashCodeEqualsOperation.findMethodInHierarchy(superClass, methodName, parameters)) != null) {
            return method;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            method = GenerateHashCodeEqualsOperation.findMethodInHierarchy(interfaces[i], methodName, parameters);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    private Expression getThisAccessForEquals(String name) {
        return this.getThisAccess(name, false);
    }

    private Expression getThisAccessForHashCode(String name) {
        return this.getThisAccess(name, true);
    }

    private Expression getThisAccess(String name, boolean forHashCode) {
        if (this.fSettings.useKeywordThis || this.needsThisQualification(name, forHashCode)) {
            FieldAccess fa = this.fAst.newFieldAccess();
            fa.setExpression((Expression)this.fAst.newThisExpression());
            fa.setName(this.fAst.newSimpleName(name));
            return fa;
        }
        return this.fAst.newSimpleName(name);
    }

    private Expression getOtherAccess(String name) {
        return this.fAst.newQualifiedName((Name)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_CASTED), this.fAst.newSimpleName(name));
    }

    private boolean isPrimitiveType(ITypeBinding binding, PrimitiveType.Code code) {
        return binding.getName().equals(code.toString());
    }

    private boolean isPrimitiveType(ITypeBinding type, PrimitiveType.Code[] codes) {
        int i = 0;
        while (i < codes.length) {
            PrimitiveType.Code code = codes[i];
            if (this.isPrimitiveType(type, code)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Name getQualifiedName(String name) {
        String importedType = this.fRewrite.getImportRewrite().addImport(name);
        return ASTNodeFactory.newName(this.fAst, importedType);
    }

    private ReturnStatement getReturnFalse() {
        ReturnStatement falseReturn = this.fAst.newReturnStatement();
        falseReturn.setExpression((Expression)this.fAst.newBooleanLiteral(false));
        return falseReturn;
    }

    private Expression parenthesize(Expression expression) {
        ParenthesizedExpression pe = this.fAst.newParenthesizedExpression();
        pe.setExpression(expression);
        return pe;
    }

    private Expression createFloatInvocation(Expression access) {
        return this.createMethodInvocation(access, "java.lang.Float", "floatToIntBits");
    }

    private Expression createDoubleInvocation(Expression access) {
        return this.createMethodInvocation(access, "java.lang.Double", "doubleToLongBits");
    }

    private Expression createMethodInvocation(Expression access, String qualifiedClassName, String methodName) {
        MethodInvocation invoc = this.fAst.newMethodInvocation();
        invoc.setExpression((Expression)this.getQualifiedName(qualifiedClassName));
        invoc.setName(this.fAst.newSimpleName(methodName));
        invoc.arguments().add(access);
        return invoc;
    }

    private boolean needsThisQualification(String name, boolean isHashCode) {
        if (isHashCode) {
            return this.fDoubleCount > 0 && name.equals(VARIABLE_NAME_DOUBLE_TEMPORARY) || name.equals(VARIABLE_NAME_PRIME) || name.equals(VARIABLE_NAME_RESULT);
        }
        return name.equals(VARIABLE_NAME_EQUALS_CASTED) || name.equals(VARIABLE_NAME_EQUALS_PARAM);
    }

    private static interface IHashCodeAccessProvider {
        public Expression getThisAccess(String var1);
    }
}

