/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.fix.AbstractSerialVersionOperation;
import org.eclipse.jdt.internal.corext.fix.PositionGroup;

public final class SerialVersionDefaultOperation
extends AbstractSerialVersionOperation {
    private static final String GROUP_INITIALIZER = "initializer";

    public SerialVersionDefaultOperation(ICompilationUnit unit, SimpleName[] simpleNames) {
        super(unit, (ASTNode[])simpleNames);
    }

    protected void addInitializer(VariableDeclarationFragment fragment, ASTNode declarationNode) {
        Assert.isNotNull(fragment);
        NumberLiteral expression = fragment.getAST().newNumberLiteral("1L");
        if (expression != null) {
            fragment.setInitializer((Expression)expression);
        }
    }

    protected void addLinkedPositions(ASTRewrite rewrite, VariableDeclarationFragment fragment, List positionGroups) {
        Assert.isNotNull(rewrite);
        Assert.isNotNull(fragment);
        Expression initializer = fragment.getInitializer();
        if (initializer != null) {
            PositionGroup group = new PositionGroup(GROUP_INITIALIZER);
            group.addFirstPosition(rewrite.track((ASTNode)initializer));
            positionGroups.add(group);
        }
    }
}

