/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.composite;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.IInitializableRefactoringComponent;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.code.CommentRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.composite.IComposableRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.composite.MultiStateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.MultiStateTextFileChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class CompositeRefactoring
extends CommentRefactoring
implements IInitializableRefactoringComponent {
    private final Map fChanges = new HashMap();
    private final Set fCustomChanges = new HashSet();
    private final Set fDisabledRefactorings = new HashSet(2);
    private WorkingCopyOwner fGlobalOwner = null;
    private final Map fLocalOwners = new HashMap();
    private final String fName;
    private boolean fRecheckInitialConditions = false;
    private final Map fRefactoringArguments = new HashMap();
    private final Refactoring[] fRefactorings;
    private final Map fWorkingCopies = new HashMap();

    public CompositeRefactoring(String name, Refactoring[] refactorings) {
        this(name, refactorings, new RefactoringArguments[0]);
    }

    public CompositeRefactoring(String name, Refactoring[] refactorings, RefactoringArguments[] arguments) {
        Assert.isNotNull(name);
        Assert.isNotNull(refactorings);
        Assert.isNotNull(arguments);
        Assert.isTrue(refactorings.length > 0);
        Assert.isTrue(arguments.length == 0 || arguments.length == refactorings.length);
        this.fName = name;
        this.fRefactorings = refactorings;
        int index = 0;
        while (index < refactorings.length) {
            Refactoring refactoring = this.fRefactorings[index];
            Assert.isTrue(refactoring instanceof IComposableRefactoring);
            IComposableRefactoring composable = (IComposableRefactoring)refactoring;
            composable.setCompositeRefactoring(this);
            ++index;
        }
        index = 0;
        while (index < arguments.length) {
            this.setRefactoringArguments(this.fRefactorings[index], arguments[index]);
            ++index;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status;
        block13: {
            RefactoringStatus refactoringStatus;
            block12: {
                RefactoringStatus refactoringStatus2;
                block11: {
                    RefactoringStatus refactoringStatus3;
                    block10: {
                        this.fChanges.clear();
                        boolean first = true;
                        monitor.beginTask("", Math.max(1, 3 * (this.fRefactorings.length - this.fDisabledRefactorings.size()) - 1));
                        monitor.setTaskName(RefactoringCoreMessages.CompositeRefactoring_checking_preconditions);
                        status = new RefactoringStatus();
                        try {
                            int index = 0;
                            while (index < this.fRefactorings.length) {
                                Refactoring refactoring = this.fRefactorings[index];
                                Assert.isTrue(refactoring instanceof IComposableRefactoring);
                                if (!this.fDisabledRefactorings.contains(refactoring)) {
                                    RefactoringStatus result;
                                    IComposableRefactoring composable = (IComposableRefactoring)refactoring;
                                    RefactoringArguments arguments = (RefactoringArguments)this.fRefactoringArguments.get(refactoring);
                                    if (arguments != null && (result = composable.initialize(arguments)).hasFatalError()) {
                                        refactoringStatus3 = result;
                                        Object var9_12 = null;
                                        break block10;
                                    }
                                    if (!first && this.fRecheckInitialConditions) {
                                        status.merge(refactoring.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                                    }
                                    first = false;
                                    if (status.hasFatalError()) {
                                        refactoringStatus2 = status;
                                        break block11;
                                    }
                                    status.merge(refactoring.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                                    if (status.hasFatalError()) {
                                        refactoringStatus = status;
                                        break block12;
                                    }
                                    Change change = refactoring.createChange((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    if (change != null) {
                                        this.registerChange(change);
                                        this.updateWorkingCopies(change);
                                    }
                                }
                                ++index;
                            }
                            break block13;
                        }
                        catch (Throwable throwable) {
                            Object var9_15 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return refactoringStatus3;
                }
                Object var9_13 = null;
                monitor.done();
                return refactoringStatus2;
            }
            Object var9_14 = null;
            monitor.done();
            return refactoringStatus;
        }
        Object var9_16 = null;
        monitor.done();
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        block8: {
            RefactoringStatus refactoringStatus;
            block7: {
                RefactoringStatus refactoringStatus2;
                block6: {
                    monitor.beginTask("", 1);
                    monitor.setTaskName(RefactoringCoreMessages.CompositeRefactoring_checking_preconditions);
                    try {
                        int index = 0;
                        while (index < this.fRefactorings.length) {
                            Refactoring refactoring = this.fRefactorings[index];
                            Assert.isTrue(refactoring instanceof IComposableRefactoring);
                            if (!this.fDisabledRefactorings.contains(refactoring)) {
                                RefactoringStatus status;
                                IComposableRefactoring composable = (IComposableRefactoring)refactoring;
                                RefactoringArguments arguments = (RefactoringArguments)this.fRefactoringArguments.get(refactoring);
                                if (arguments != null && !(status = composable.initialize(arguments)).hasFatalError()) {
                                    refactoringStatus2 = refactoring.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    Object var7_9 = null;
                                    break block6;
                                }
                                refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.CompositeRefactoring_error_setup, (Object)refactoring.getName()));
                                break block7;
                            }
                            ++index;
                        }
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return refactoringStatus2;
            }
            Object var7_10 = null;
            monitor.done();
            return refactoringStatus;
        }
        Object var7_12 = null;
        monitor.done();
        return new RefactoringStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Iterator iterator2;
        SubProgressMonitor subMonitor2;
        Throwable throwable2;
        block6: {
            Collection copies2;
            DynamicValidationStateChange dynamicValidationStateChange;
            Assert.isNotNull(monitor);
            try {
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.CompositeRefactoring_creating_change);
                HashSet changes = new HashSet(this.fChanges.values());
                changes.addAll(this.fCustomChanges);
                dynamicValidationStateChange = new DynamicValidationStateChange(this.getName(), changes.toArray(new Change[changes.size()]));
                Object var3_4 = null;
                this.fCustomChanges.clear();
                this.fChanges.clear();
                this.fGlobalOwner = null;
                this.fLocalOwners.clear();
                copies2 = this.fWorkingCopies.values();
            }
            catch (Throwable throwable2) {
                Object var3_5 = null;
                this.fCustomChanges.clear();
                this.fChanges.clear();
                this.fGlobalOwner = null;
                this.fLocalOwners.clear();
                Collection copies2 = this.fWorkingCopies.values();
                subMonitor2 = new SubProgressMonitor(monitor, 1);
                subMonitor2.beginTask(RefactoringCoreMessages.CompositeRefactoring_creating_change, copies2.size());
                iterator2 = copies2.iterator();
                break block6;
            }
            SubProgressMonitor subMonitor2 = new SubProgressMonitor(monitor, 1);
            subMonitor2.beginTask(RefactoringCoreMessages.CompositeRefactoring_creating_change, copies2.size());
            Iterator iterator2 = copies2.iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    this.fWorkingCopies.clear();
                    subMonitor2.done();
                    monitor.done();
                    return dynamicValidationStateChange;
                }
                ((ICompilationUnit)iterator2.next()).discardWorkingCopy();
                subMonitor2.worked(1);
            }
        }
        while (true) {
            if (!iterator2.hasNext()) {
                this.fWorkingCopies.clear();
                subMonitor2.done();
                monitor.done();
                throw throwable2;
            }
            ((ICompilationUnit)iterator2.next()).discardWorkingCopy();
            subMonitor2.worked(1);
        }
    }

    public final Refactoring[] getComposedRefactorings() {
        return this.fRefactorings;
    }

    public final WorkingCopyOwner getGlobalWorkingCopyOwner() {
        if (this.fGlobalOwner == null) {
            this.fGlobalOwner = new GlobalWorkingCopyOwner();
        }
        return this.fGlobalOwner;
    }

    public final WorkingCopyOwner getLocalWorkingCopyOwner(Refactoring refactoring) {
        WorkingCopyOwner owner = (WorkingCopyOwner)this.fLocalOwners.get(refactoring);
        if (owner != null) {
            return owner;
        }
        LocalWorkingCopyOwner local = new LocalWorkingCopyOwner();
        this.fLocalOwners.put(refactoring, local);
        return local;
    }

    public final String getName() {
        return this.fName;
    }

    public final ICompilationUnit getWorkingCopy(ICompilationUnit original) throws JavaModelException {
        Assert.isNotNull(original);
        if (this.fWorkingCopies.containsValue(original)) {
            return original;
        }
        ICompilationUnit cached = (ICompilationUnit)this.fWorkingCopies.get(original);
        if (cached != null) {
            return cached;
        }
        ICompilationUnit unit = original.getWorkingCopy(this.getGlobalWorkingCopyOwner(), null, null);
        this.fWorkingCopies.put(original, unit);
        return unit;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        RefactoringStatus status = new RefactoringStatus();
        int index = 0;
        while (index < this.fRefactorings.length) {
            if (!this.fDisabledRefactorings.contains(this.fRefactorings[index]) && this.fRefactorings[index] instanceof IInitializableRefactoringComponent) {
                status.merge(((IInitializableRefactoringComponent)this.fRefactorings[index]).initialize(arguments));
            }
            ++index;
        }
        return status;
    }

    protected void registerChange(Change change) {
        if (change instanceof CompositeChange) {
            CompositeChange composite = (CompositeChange)change;
            Change[] changes = composite.getChildren();
            int index = 0;
            while (index < changes.length) {
                this.registerChange(changes[index]);
                ++index;
            }
        } else if (change instanceof CompilationUnitChange) {
            CompilationUnitChange unitChange = (CompilationUnitChange)change;
            this.registerCompilationUnitChange(unitChange);
        }
    }

    protected void registerCompilationUnitChange(CompilationUnitChange change) {
        ICompilationUnit unit = change.getCompilationUnit().getPrimary();
        if (!this.fChanges.containsKey(unit)) {
            MultiStateCompilationUnitChange newChange = new MultiStateCompilationUnitChange(unit.getElementName(), unit);
            newChange.addChange((TextChange)change);
            this.fChanges.put(unit, newChange);
        } else {
            MultiStateTextFileChange existingChange = (MultiStateTextFileChange)this.fChanges.get(unit);
            if (existingChange != null) {
                existingChange.addChange((TextChange)change);
            }
        }
    }

    public final void removeRefactoringArguments(Refactoring refactoring) {
        this.fRefactoringArguments.remove(refactoring);
    }

    public final void setRecheckInitialConditions(boolean check) {
        this.fRecheckInitialConditions = check;
    }

    public final void setRefactoringArguments(Refactoring refactoring, RefactoringArguments arguments) {
        this.fRefactoringArguments.put(refactoring, arguments);
    }

    public final void setRefactoringEnabled(Refactoring refactoring, boolean enable) {
        if (enable) {
            this.fDisabledRefactorings.remove(refactoring);
        } else {
            this.fDisabledRefactorings.add(refactoring);
        }
    }

    protected void updateWorkingCopies(Change change) throws JavaModelException {
        CompilationUnitChange unitChange;
        TextEdit edit;
        if (change instanceof CompositeChange) {
            CompositeChange composite = (CompositeChange)change;
            Change[] changes = composite.getChildren();
            int index = 0;
            while (index < changes.length) {
                this.updateWorkingCopies(changes[index]);
                ++index;
            }
        } else if (change instanceof CompilationUnitChange && (edit = (unitChange = (CompilationUnitChange)change).getEdit()) != null) {
            this.updateWorkingCopy(unitChange.getCompilationUnit(), edit.copy());
        }
    }

    protected void updateWorkingCopy(ICompilationUnit unit, TextEdit edit) throws JavaModelException {
        Document document = new Document(unit.getBuffer().getContents());
        try {
            edit.apply((IDocument)document, 0);
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        unit.getBuffer().setContents(document.get());
        JavaModelUtil.reconcile(unit);
    }

    private static class GlobalWorkingCopyOwner
    extends WorkingCopyOwner {
        GlobalWorkingCopyOwner() {
        }
    }

    private static class LocalWorkingCopyOwner
    extends WorkingCopyOwner {
        LocalWorkingCopyOwner() {
        }
    }
}

