/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class RenameLocalVariableProcessor
extends JavaRenameProcessor
implements INameUpdating,
IReferenceUpdating {
    public static final String ID_RENAME_LOCAL_VARIABLE = "org.eclipse.jdt.ui.rename.local.variable";
    private static final String ATTRIBUTE_REFERENCES = "references";
    private ILocalVariable fLocalVariable;
    private ICompilationUnit fCu;
    private boolean fUpdateReferences;
    private String fCurrentName;
    private String fNewName;
    private CompilationUnit fCompilationUnitNode;
    private VariableDeclaration fTempDeclarationNode;
    private TextChange fChange;
    private boolean fIsComposite;
    private GroupCategorySet fCategorySet;
    private TextChangeManager fChangeManager;
    private RenameAnalyzeUtil.LocalAnalyzePackage fLocalAnalyzePackage;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameLocalVariableProcessor";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RenameLocalVariableProcessor(ILocalVariable localVariable) {
        this.fLocalVariable = localVariable;
        this.fUpdateReferences = true;
        if (localVariable != null) {
            this.fCu = (ICompilationUnit)localVariable.getAncestor(5);
        }
        this.fNewName = "";
        this.fIsComposite = false;
    }

    RenameLocalVariableProcessor(ILocalVariable localVariable, TextChangeManager manager, CompilationUnit node, GroupCategorySet categorySet) {
        this(localVariable);
        this.fChangeManager = manager;
        this.fCategorySet = categorySet;
        this.fCompilationUnitNode = node;
        this.fIsComposite = true;
    }

    public boolean needsSavedEditors() {
        return false;
    }

    protected final String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fLocalVariable);
    }

    public Object[] getElements() {
        return new Object[]{this.fLocalVariable};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameTempRefactoring_rename;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fLocalVariable);
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public String getCurrentElementName() {
        return this.fCurrentName;
    }

    public String getNewElementName() {
        return this.fNewName;
    }

    public void setNewElementName(String newName) {
        Assert.isNotNull(newName);
        this.fNewName = newName;
    }

    public Object getNewElement() {
        return null;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        this.initAST();
        if (this.fTempDeclarationNode == null || this.fTempDeclarationNode.resolveBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameTempRefactoring_must_select_local);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Checks.isDeclaredIn(this.fTempDeclarationNode, clazz)) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.dom.Initializer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!Checks.isDeclaredIn(this.fTempDeclarationNode, clazz2)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameTempRefactoring_only_in_methods_and_initializers);
            }
        }
        this.initNames();
        return new RefactoringStatus();
    }

    private void initAST() throws JavaModelException {
        ISourceRange sourceRange;
        ASTNode name;
        if (!this.fIsComposite) {
            this.fCompilationUnitNode = new RefactoringASTParser(3).parse(this.fCu, null, true, true, null);
        }
        if ((name = NodeFinder.perform((ASTNode)this.fCompilationUnitNode, sourceRange = this.fLocalVariable.getNameRange())) == null) {
            return;
        }
        if (name.getParent() instanceof VariableDeclaration) {
            this.fTempDeclarationNode = (VariableDeclaration)name.getParent();
        }
    }

    private void initNames() {
        this.fCurrentName = this.fTempDeclarationNode.getName().getIdentifier();
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fLocalVariable, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        return new IFile[]{ResourceUtil.getFile(this.fCu)};
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus result;
        block6: {
            RefactoringStatus refactoringStatus;
            try {
                pm.beginTask("", 1);
                result = this.checkNewElementName(this.fNewName);
                if (!result.hasFatalError()) break block6;
                refactoringStatus = result;
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var5_8 = null;
                    pm.done();
                    if (!this.fIsComposite) break block7;
                    this.fChange = null;
                    this.fCompilationUnitNode = null;
                    this.fTempDeclarationNode = null;
                }
                throw throwable;
            }
            pm.done();
            if (this.fIsComposite) {
                this.fChange = null;
                this.fCompilationUnitNode = null;
                this.fTempDeclarationNode = null;
            }
            return refactoringStatus;
        }
        this.createEdits();
        if (!this.fIsComposite) {
            RenameAnalyzeUtil.LocalAnalyzePackage[] localAnalyzePackages = new RenameAnalyzeUtil.LocalAnalyzePackage[]{this.fLocalAnalyzePackage};
            result.merge(RenameAnalyzeUtil.analyzeLocalRenames(localAnalyzePackages, this.fChange, this.fCompilationUnitNode, true));
        }
        RefactoringStatus refactoringStatus = result;
        Object var5_7 = null;
        pm.done();
        if (this.fIsComposite) {
            this.fChange = null;
            this.fCompilationUnitNode = null;
            this.fTempDeclarationNode = null;
        }
        return refactoringStatus;
    }

    public RefactoringStatus checkNewElementName(String newName) throws JavaModelException {
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (!Checks.startsWithLowerCase(newName)) {
            if (this.fIsComposite) {
                String nameOfParent = this.fLocalVariable.getParent() instanceof IMethod ? this.fLocalVariable.getParent().getElementName() : RefactoringCoreMessages.JavaElementUtil_initializer;
                String nameOfType = this.fLocalVariable.getAncestor(7).getElementName();
                result.addWarning(Messages.format(RefactoringCoreMessages.RenameTempRefactoring_lowercase2, new String[]{newName, nameOfParent, nameOfType}));
            } else {
                result.addWarning(RefactoringCoreMessages.RenameTempRefactoring_lowercase);
            }
        }
        return result;
    }

    private void createEdits() {
        TextEdit declarationEdit = this.createRenameEdit(this.fTempDeclarationNode.getName().getStartPosition());
        TextEdit[] allRenameEdits = this.getAllRenameEdits(declarationEdit);
        TextEdit[] allUnparentedRenameEdits = new TextEdit[allRenameEdits.length];
        TextEdit unparentedDeclarationEdit = null;
        this.fChange = new CompilationUnitChange(RefactoringCoreMessages.RenameTempRefactoring_rename, this.fCu);
        MultiTextEdit rootEdit = new MultiTextEdit();
        this.fChange.setEdit((TextEdit)rootEdit);
        this.fChange.setKeepPreviewEdits(true);
        String changeName = Messages.format(RefactoringCoreMessages.RenameTempRefactoring_changeName, new String[]{this.fCurrentName, this.fNewName});
        int i = 0;
        while (i < allRenameEdits.length) {
            if (this.fIsComposite) {
                TextChangeCompatibility.addTextEdit(this.fChangeManager.get(this.fCu), changeName, allRenameEdits[i].copy(), this.fCategorySet);
                allUnparentedRenameEdits[i] = allRenameEdits[i].copy();
                if (allRenameEdits[i].equals((Object)declarationEdit)) {
                    unparentedDeclarationEdit = allUnparentedRenameEdits[i];
                }
            }
            rootEdit.addChild(allRenameEdits[i]);
            this.fChange.addTextEditGroup(new TextEditGroup(changeName, allRenameEdits[i]));
            ++i;
        }
        this.fLocalAnalyzePackage = this.fIsComposite ? new RenameAnalyzeUtil.LocalAnalyzePackage(unparentedDeclarationEdit, allUnparentedRenameEdits) : new RenameAnalyzeUtil.LocalAnalyzePackage(declarationEdit, allRenameEdits);
    }

    private TextEdit[] getAllRenameEdits(TextEdit declarationEdit) {
        if (!this.fUpdateReferences) {
            return new TextEdit[]{declarationEdit};
        }
        TempOccurrenceAnalyzer fTempAnalyzer = new TempOccurrenceAnalyzer(this.fTempDeclarationNode, true);
        fTempAnalyzer.perform();
        int[] referenceOffsets = fTempAnalyzer.getReferenceAndJavadocOffsets();
        TextEdit[] allRenameEdits = new TextEdit[referenceOffsets.length + 1];
        int i = 0;
        while (i < referenceOffsets.length) {
            allRenameEdits[i] = this.createRenameEdit(referenceOffsets[i]);
            ++i;
        }
        allRenameEdits[referenceOffsets.length] = declarationEdit;
        return allRenameEdits;
    }

    private TextEdit createRenameEdit(int offset) {
        return new ReplaceEdit(offset, this.fCurrentName.length(), this.fNewName);
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        TextChange textChange;
        try {
            Object change = this.fChange;
            if (change != null) {
                final ISourceRange range = this.fLocalVariable.getNameRange();
                CompositeChange composite = new CompositeChange("", new Change[]{change}){

                    public final ChangeDescriptor getDescriptor() {
                        HashMap<String, String> arguments = new HashMap<String, String>();
                        String project = null;
                        IJavaProject javaProject = RenameLocalVariableProcessor.this.fCu.getJavaProject();
                        if (javaProject != null) {
                            project = javaProject.getElementName();
                        }
                        JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(RenameLocalVariableProcessor.ID_RENAME_LOCAL_VARIABLE, project, Messages.format(RefactoringCoreMessages.RenameLocalVariableProcessor_descriptor_description, new String[]{RenameLocalVariableProcessor.this.fCurrentName, JavaElementLabels.getElementLabel(RenameLocalVariableProcessor.this.fLocalVariable.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED), RenameLocalVariableProcessor.this.fNewName}), RenameLocalVariableProcessor.this.getComment(), arguments, 0);
                        arguments.put("input", descriptor.elementToHandle((IJavaElement)RenameLocalVariableProcessor.this.fCu));
                        arguments.put("name", RenameLocalVariableProcessor.this.getNewElementName());
                        arguments.put("selection", String.valueOf(new Integer(range.getOffset()).toString()) + " " + new Integer(range.getLength()).toString());
                        arguments.put(RenameLocalVariableProcessor.ATTRIBUTE_REFERENCES, Boolean.valueOf(RenameLocalVariableProcessor.this.fUpdateReferences).toString());
                        return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
                    }
                };
                composite.markAsSynthetic();
                change = composite;
            }
            textChange = change;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return textChange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String references;
        if (!(arguments instanceof JavaRefactoringArguments)) return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
        String handle = extended.getAttribute("input");
        if (handle == null) return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"input"));
        IJavaElement element = JavaRefactoringDescriptor.handleToElement(extended.getProject(), handle);
        if (element == null || element.getElementType() != 5) {
            return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_RENAME_LOCAL_VARIABLE));
        }
        this.fCu = (ICompilationUnit)element;
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"name"));
        }
        this.setNewElementName(name);
        if (this.fCu != null) {
            String selection = extended.getAttribute("selection");
            if (selection == null) return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"selection"));
            int offset = -1;
            int length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_illegal_argument, (Object[])new Object[]{selection, "selection"}));
            try {
                IJavaElement[] elements = this.fCu.codeSelect(offset, length);
                if (elements != null) {
                    int index = 0;
                    while (index < elements.length) {
                        IJavaElement element2 = elements[index];
                        if (element2 instanceof ILocalVariable) {
                            this.fLocalVariable = (ILocalVariable)element2;
                        }
                        ++index;
                    }
                }
                if (this.fLocalVariable == null) {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_RENAME_LOCAL_VARIABLE));
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
        if ((references = extended.getAttribute(ATTRIBUTE_REFERENCES)) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_REFERENCES));
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        return new RefactoringStatus();
    }

    public RenameAnalyzeUtil.LocalAnalyzePackage getLocalAnalyzePackage() {
        return this.fLocalAnalyzePackage;
    }
}

