/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.osgi.util.NLS;

public final class RenameTypeParameterProcessor
extends JavaRenameProcessor
implements INameUpdating,
IReferenceUpdating {
    private static final String ATTRIBUTE_REFERENCES = "references";
    private static final String ATTRIBUTE_PARAMETER = "parameter";
    private static final String ID_RENAME_TYPE_PARAMETER = "org.eclipse.jdt.ui.rename.type.parameter";
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameTypeParameterProcessor";
    private Change fChange = null;
    private ITypeParameter fTypeParameter;
    private boolean fUpdateReferences = true;

    public RenameTypeParameterProcessor(ITypeParameter parameter) {
        this.fTypeParameter = parameter;
        if (parameter != null) {
            this.setNewElementName(parameter.getElementName());
        }
    }

    public final boolean canEnableUpdateReferences() {
        return true;
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fTypeParameter, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        return new IFile[]{ResourceUtil.getFile(this.fTypeParameter.getDeclaringMember().getCompilationUnit())};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final RefactoringStatus doCheckFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status;
        block4: {
            RefactoringStatus refactoringStatus;
            block5: {
                Assert.isNotNull(monitor);
                Assert.isNotNull(context);
                status = new RefactoringStatus();
                try {
                    monitor.beginTask("", 5);
                    monitor.setTaskName(RefactoringCoreMessages.RenameTypeParameterRefactoring_checking);
                    status.merge(Checks.checkIfCuBroken(this.fTypeParameter.getDeclaringMember()));
                    monitor.worked(1);
                    if (status.hasFatalError()) break block4;
                    status.merge(this.checkNewElementName(this.getNewElementName()));
                    monitor.worked(1);
                    monitor.setTaskName(RefactoringCoreMessages.RenameTypeParameterRefactoring_searching);
                    status.merge(this.createRenameChanges((IProgressMonitor)new SubProgressMonitor(monitor, 2)));
                    monitor.setTaskName(RefactoringCoreMessages.RenameTypeParameterRefactoring_checking);
                    if (status.hasFatalError()) {
                        refactoringStatus = status;
                        Object var4_5 = null;
                        break block5;
                    }
                    monitor.worked(1);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return refactoringStatus;
        }
        Object var4_7 = null;
        monitor.done();
        return status;
    }

    public final RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull(monitor);
        if (!this.fTypeParameter.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_deleted, this.fTypeParameter.getDeclaringMember().getCompilationUnit().getElementName()));
        }
        return Checks.checkIfCuBroken(this.fTypeParameter.getDeclaringMember());
    }

    public final RefactoringStatus checkNewElementName(String name) throws CoreException {
        IMember member;
        Assert.isNotNull(name);
        RefactoringStatus result = Checks.checkTypeParameterName(name);
        if (Checks.startsWithLowerCase(name)) {
            result.addWarning(RefactoringCoreMessages.RenameTypeParameterRefactoring_should_start_lowercase);
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fTypeParameter, name)) {
            result.addFatalError(RefactoringCoreMessages.RenameTypeParameterRefactoring_another_name);
        }
        if ((member = this.fTypeParameter.getDeclaringMember()) instanceof IType) {
            IType type = (IType)member;
            if (type.getTypeParameter(name).exists()) {
                result.addFatalError(RefactoringCoreMessages.RenameTypeParameterRefactoring_class_type_parameter_already_defined);
            }
        } else if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            if (method.getTypeParameter(name).exists()) {
                result.addFatalError(RefactoringCoreMessages.RenameTypeParameterRefactoring_method_type_parameter_already_defined);
            }
        } else {
            JavaPlugin.logErrorMessage("Unexpected sub-type of IMember: " + member.getClass().getName());
            Assert.isTrue(false);
        }
        return result;
    }

    public final Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Change change;
        Assert.isNotNull(monitor);
        try {
            Object change2 = this.fChange;
            if (change2 != null) {
                CompositeChange composite = new CompositeChange("", new Change[]{change2}){

                    public final ChangeDescriptor getDescriptor() {
                        HashMap<String, String> arguments = new HashMap<String, String>();
                        String project = null;
                        IJavaProject javaProject = RenameTypeParameterProcessor.this.fTypeParameter.getJavaProject();
                        if (javaProject != null) {
                            project = javaProject.getElementName();
                        }
                        JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(RenameTypeParameterProcessor.ID_RENAME_TYPE_PARAMETER, project, Messages.format(RefactoringCoreMessages.RenameTypeParameterProcessor_descriptor_description, new String[]{RenameTypeParameterProcessor.this.fTypeParameter.getElementName(), JavaElementLabels.getElementLabel((IJavaElement)RenameTypeParameterProcessor.this.fTypeParameter.getDeclaringMember(), JavaElementLabels.ALL_FULLY_QUALIFIED), RenameTypeParameterProcessor.this.getNewElementName()}), RenameTypeParameterProcessor.this.getComment(), arguments, 0);
                        arguments.put("input", descriptor.elementToHandle((IJavaElement)RenameTypeParameterProcessor.this.fTypeParameter.getDeclaringMember()));
                        arguments.put("name", RenameTypeParameterProcessor.this.getNewElementName());
                        arguments.put(RenameTypeParameterProcessor.ATTRIBUTE_PARAMETER, RenameTypeParameterProcessor.this.fTypeParameter.getElementName());
                        arguments.put(RenameTypeParameterProcessor.ATTRIBUTE_REFERENCES, Boolean.valueOf(RenameTypeParameterProcessor.this.fUpdateReferences).toString());
                        return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
                    }
                };
                composite.markAsSynthetic();
                change2 = composite;
            }
            change = change2;
            Object var4_5 = null;
            this.fChange = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.fChange = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return change;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus createRenameChanges(IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(RefactoringCoreMessages.RenameTypeParameterRefactoring_searching, 2);
            CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.fTypeParameter.getDeclaringMember().getCompilationUnit());
            IMember member = this.fTypeParameter.getDeclaringMember();
            CompilationUnit root = rewrite.getRoot();
            MethodDeclaration declaration = null;
            if (member instanceof IMethod) {
                declaration = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, root);
            } else if (member instanceof IType) {
                declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)member, root);
            } else {
                JavaPlugin.logErrorMessage("Unexpected sub-type of IMember: " + member.getClass().getName());
                Assert.isTrue(false);
            }
            monitor.worked(1);
            RenameTypeParameterVisitor visitor = new RenameTypeParameterVisitor(rewrite, this.fTypeParameter.getNameRange(), status);
            if (declaration != null) {
                declaration.accept((ASTVisitor)visitor);
            }
            this.fChange = visitor.getResult();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        monitor.done();
        return status;
    }

    protected final String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fTypeParameter);
    }

    public final String getCurrentElementName() {
        return this.fTypeParameter.getElementName();
    }

    public final Object[] getElements() {
        return new Object[]{this.fTypeParameter};
    }

    public final String getIdentifier() {
        return IDENTIFIER;
    }

    public final Object getNewElement() throws CoreException {
        IMember member = this.fTypeParameter.getDeclaringMember();
        if (member instanceof IType) {
            IType type = (IType)member;
            return type.getTypeParameter(this.getNewElementName());
        }
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            return method.getTypeParameter(this.getNewElementName());
        }
        JavaPlugin.logErrorMessage("Unexpected sub-type of IMember: " + member.getClass().getName());
        Assert.isTrue(false);
        return null;
    }

    public final String getProcessorName() {
        return Messages.format(RefactoringCoreMessages.RenameTypeParameterProcessor_name, new String[]{this.fTypeParameter.getElementName(), this.getNewElementName()});
    }

    public final boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public final RefactoringStatus initialize(RefactoringArguments arguments) {
        String references;
        if (arguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String parameter = extended.getAttribute(ATTRIBUTE_PARAMETER);
            if (parameter == null || "".equals(parameter)) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_PARAMETER));
            }
            String handle = extended.getAttribute("input");
            if (handle != null) {
                IJavaElement element = JavaRefactoringDescriptor.handleToElement(extended.getProject(), handle);
                if (element == null) {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_RENAME_TYPE_PARAMETER));
                }
                if (element instanceof IMethod) {
                    this.fTypeParameter = ((IMethod)element).getTypeParameter(parameter);
                } else if (element instanceof IType) {
                    this.fTypeParameter = ((IType)element).getTypeParameter(parameter);
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_illegal_argument, (Object[])new Object[]{handle, "input"}));
                }
                if (this.fTypeParameter == null || !this.fTypeParameter.exists()) {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_RENAME_TYPE_PARAMETER));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"input"));
            }
            String name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"name"));
            }
            this.setNewElementName(name);
            references = extended.getAttribute(ATTRIBUTE_REFERENCES);
            if (references == null) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_REFERENCES));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        return new RefactoringStatus();
    }

    public final boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fTypeParameter);
    }

    public boolean needsSavedEditors() {
        return false;
    }

    public final void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public final class RenameTypeParameterVisitor
    extends ASTVisitor {
        private final IBinding fBinding;
        private final SimpleName fName;
        private final CompilationUnitRewrite fRewrite;
        private final RefactoringStatus fStatus;

        public RenameTypeParameterVisitor(CompilationUnitRewrite rewrite, ISourceRange range, RefactoringStatus status) {
            super(true);
            Assert.isNotNull(rewrite);
            Assert.isNotNull(range);
            Assert.isNotNull(status);
            this.fRewrite = rewrite;
            this.fName = (SimpleName)NodeFinder.perform((ASTNode)rewrite.getRoot(), range);
            this.fBinding = this.fName.resolveBinding();
            this.fStatus = status;
        }

        public final Change getResult() throws CoreException {
            return this.fRewrite.createChange();
        }

        public final boolean visit(AnnotationTypeDeclaration node) {
            String name = node.getName().getIdentifier();
            if (name.equals(RenameTypeParameterProcessor.this.getNewElementName())) {
                this.fStatus.addError(Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_type_parameter_inner_class_clash, new String[]{name}), JavaStatusContext.create(RenameTypeParameterProcessor.this.fTypeParameter.getDeclaringMember().getCompilationUnit(), (ISourceRange)new SourceRange((ASTNode)node)));
                return false;
            }
            return true;
        }

        public final boolean visit(EnumDeclaration node) {
            String name = node.getName().getIdentifier();
            if (name.equals(RenameTypeParameterProcessor.this.getNewElementName())) {
                this.fStatus.addError(Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_type_parameter_inner_class_clash, new String[]{name}), JavaStatusContext.create(RenameTypeParameterProcessor.this.fTypeParameter.getDeclaringMember().getCompilationUnit(), (ISourceRange)new SourceRange((ASTNode)node)));
                return false;
            }
            return true;
        }

        public final boolean visit(SimpleName node) {
            ITypeBinding binding = node.resolveTypeBinding();
            if (binding != null && binding.isTypeVariable() && Bindings.equals((IBinding)binding, this.fBinding) && node.getIdentifier().equals(this.fName.getIdentifier())) {
                if (node != this.fName) {
                    if (RenameTypeParameterProcessor.this.fUpdateReferences) {
                        this.fRewrite.getASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)RenameTypeParameterProcessor.this.getNewElementName(), this.fRewrite.createGroupDescription(RefactoringCoreMessages.RenameTypeParameterRefactoring_update_type_parameter_reference));
                    }
                } else {
                    this.fRewrite.getASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)RenameTypeParameterProcessor.this.getNewElementName(), this.fRewrite.createGroupDescription(RefactoringCoreMessages.RenameTypeParameterRefactoring_update_type_parameter_declaration));
                }
            }
            return true;
        }

        public final boolean visit(TypeDeclaration node) {
            String name = node.getName().getIdentifier();
            if (name.equals(RenameTypeParameterProcessor.this.getNewElementName())) {
                this.fStatus.addError(Messages.format(RefactoringCoreMessages.RenameTypeParameterRefactoring_type_parameter_inner_class_clash, new String[]{name}), JavaStatusContext.create(RenameTypeParameterProcessor.this.fTypeParameter.getDeclaringMember().getCompilationUnit(), (ISourceRange)new SourceRange((ASTNode)node)));
                return false;
            }
            return true;
        }
    }
}

