/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class CompilationUnitRewrite {
    private ICompilationUnit fCu;
    private List fTextEditGroups = new ArrayList();
    private CompilationUnit fRoot;
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;
    private ImportRemover fImportRemover;
    private boolean fResolveBindings = true;
    private boolean fStatementsRecovery = false;
    private final WorkingCopyOwner fOwner;
    static /* synthetic */ Class class$0;

    public CompilationUnitRewrite(ICompilationUnit cu) {
        this(null, cu, null);
    }

    public CompilationUnitRewrite(WorkingCopyOwner owner, ICompilationUnit cu) {
        this(owner, cu, null);
    }

    public CompilationUnitRewrite(ICompilationUnit cu, CompilationUnit root) {
        this(null, cu, root);
    }

    public CompilationUnitRewrite(WorkingCopyOwner owner, ICompilationUnit cu, CompilationUnit root) {
        this.fOwner = owner;
        this.fCu = cu;
        this.fRoot = root;
    }

    public void setResolveBindings(boolean resolve) {
        this.fResolveBindings = resolve;
    }

    public void setStatementsRecovery(boolean statementsRecovery) {
        this.fStatementsRecovery = statementsRecovery;
    }

    public void clearASTRewrite() {
        this.fRewrite = null;
        this.fTextEditGroups = new ArrayList();
    }

    public void clearImportRewrites() {
        this.fImportRewrite = null;
    }

    public void clearASTAndImportRewrites() {
        this.clearASTRewrite();
        this.fImportRewrite = null;
    }

    public CategorizedTextEditGroup createCategorizedGroupDescription(String name, GroupCategorySet set) {
        CategorizedTextEditGroup result = new CategorizedTextEditGroup(name, set);
        this.fTextEditGroups.add(result);
        return result;
    }

    public TextEditGroup createGroupDescription(String name) {
        TextEditGroup result = new TextEditGroup(name);
        this.fTextEditGroups.add(result);
        return result;
    }

    public CompilationUnitChange createChange() throws CoreException {
        return this.createChange(null);
    }

    public CompilationUnitChange createChange(IProgressMonitor monitor) throws CoreException {
        CompilationUnitChange cuChange = new CompilationUnitChange(this.fCu.getElementName(), this.fCu);
        MultiTextEdit multiEdit = new MultiTextEdit();
        cuChange.setEdit((TextEdit)multiEdit);
        return this.attachChange(cuChange, monitor);
    }

    public CompilationUnitChange attachChange(CompilationUnitChange cuChange, IProgressMonitor monitor) throws CoreException {
        CompilationUnitChange compilationUnitChange;
        block13: {
            block11: {
                CompilationUnitChange compilationUnitChange2;
                block12: {
                    boolean needsImportRewrite;
                    boolean needsImportRemoval;
                    boolean needsAstRewrite;
                    block9: {
                        CompilationUnitChange compilationUnitChange3;
                        block10: {
                            needsAstRewrite = this.fRewrite != null;
                            needsImportRemoval = this.fImportRemover != null && this.fImportRemover.hasRemovedNodes();
                            boolean bl = needsImportRewrite = this.fImportRewrite != null && this.fImportRewrite.hasRecordedChanges() || needsImportRemoval;
                            if (needsAstRewrite || needsImportRemoval || needsImportRewrite) break block9;
                            compilationUnitChange3 = null;
                            Object var9_9 = null;
                            if (monitor == null) break block10;
                            monitor.done();
                        }
                        return compilationUnitChange3;
                    }
                    try {
                        TextEdit importsEdit;
                        TextEdit rewriteEdit;
                        MultiTextEdit multiEdit = (MultiTextEdit)cuChange.getEdit();
                        if (multiEdit == null) {
                            multiEdit = new MultiTextEdit();
                            cuChange.setEdit((TextEdit)multiEdit);
                        }
                        if (needsAstRewrite && !CompilationUnitRewrite.isEmptyEdit(rewriteEdit = this.fRewrite.rewriteAST())) {
                            multiEdit.addChild(rewriteEdit);
                            Iterator iter = this.fTextEditGroups.iterator();
                            while (iter.hasNext()) {
                                cuChange.addTextEditGroup((TextEditGroup)iter.next());
                            }
                        }
                        if (needsImportRemoval) {
                            this.fImportRemover.applyRemoves(this.getImportRewrite());
                        }
                        if (needsImportRewrite && !CompilationUnitRewrite.isEmptyEdit(importsEdit = this.fImportRewrite.rewriteImports(monitor))) {
                            multiEdit.addChild(importsEdit);
                            String importUpdateName = RefactoringCoreMessages.ASTData_update_imports;
                            cuChange.addTextEditGroup(new TextEditGroup(importUpdateName, importsEdit));
                        }
                        if (!CompilationUnitRewrite.isEmptyEdit((TextEdit)multiEdit)) break block11;
                        compilationUnitChange2 = null;
                        Object var9_10 = null;
                        if (monitor == null) break block12;
                    }
                    catch (Throwable throwable) {
                        block14: {
                            Object var9_12 = null;
                            if (monitor == null) break block14;
                            monitor.done();
                        }
                        throw throwable;
                    }
                    monitor.done();
                }
                return compilationUnitChange2;
            }
            compilationUnitChange = cuChange;
            Object var9_11 = null;
            if (monitor == null) break block13;
            monitor.done();
        }
        return compilationUnitChange;
    }

    private static boolean isEmptyEdit(TextEdit edit) {
        Class<?> clazz = edit.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.text.edits.MultiTextEdit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz == clazz2 && !edit.hasChildren();
    }

    public ICompilationUnit getCu() {
        return this.fCu;
    }

    public CompilationUnit getRoot() {
        if (this.fRoot == null) {
            this.fRoot = new RefactoringASTParser(3).parse(this.fCu, this.fOwner, this.fResolveBindings, this.fStatementsRecovery, null);
        }
        return this.fRoot;
    }

    public AST getAST() {
        return this.getRoot().getAST();
    }

    public ASTRewrite getASTRewrite() {
        if (this.fRewrite == null) {
            this.fRewrite = ASTRewrite.create((AST)this.getRoot().getAST());
        }
        return this.fRewrite;
    }

    public ImportRewrite getImportRewrite() {
        if (this.fImportRewrite == null) {
            try {
                this.fImportRewrite = this.fRoot == null ? StubUtility.createImportRewrite(this.fCu, true) : StubUtility.createImportRewrite(this.getRoot(), true);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        return this.fImportRewrite;
    }

    public ImportRemover getImportRemover() {
        if (this.fImportRemover == null) {
            this.fImportRemover = new ImportRemover(this.fCu.getJavaProject(), this.getRoot());
        }
        return this.fImportRemover;
    }
}

