/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.HierarchyProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.IMemberActionInfo;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeVariableMaplet;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeVariableUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MalformedTreeException;

public final class PushDownRefactoringProcessor
extends HierarchyProcessor {
    private static final String ATTRIBUTE_ABSTRACT = "abstract";
    private static final String ATTRIBUTE_PUSH = "push";
    private static final String ID_PUSH_DOWN = "org.eclipse.jdt.ui.push.down";
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.pushDownProcessor";
    private ITypeHierarchy fCachedClassHierarchy;
    private MemberActionInfo[] fMemberInfos;

    private static MemberActionInfo[] createInfosForAllPushableFieldsAndMethods(IType type) throws JavaModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>();
        IMember[] pushableMembers = RefactoringAvailabilityTester.getPushDownMembers(type);
        int i = 0;
        while (i < pushableMembers.length) {
            result.add(MemberActionInfo.create(pushableMembers[i], 2));
            ++i;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private static IMember[] getAbstractMembers(IMember[] members) throws JavaModelException {
        ArrayList<IMember> result = new ArrayList<IMember>(members.length);
        int i = 0;
        while (i < members.length) {
            IMember member = members[i];
            if (JdtFlags.isAbstract(member)) {
                result.add(member);
            }
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    private static CompilationUnitRewrite getCompilationUnitRewrite(Map rewrites, ICompilationUnit unit) {
        Assert.isNotNull(rewrites);
        Assert.isNotNull(unit);
        CompilationUnitRewrite rewrite = (CompilationUnitRewrite)rewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(unit);
            rewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    private static IJavaElement[] getReferencingElementsFromSameClass(IMember member, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        Assert.isNotNull(member);
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)member, (int)2, (int)24));
        engine.setFiltering(true, true);
        engine.setScope(SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{member.getDeclaringType()}));
        engine.setStatus(status);
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        SearchResultGroup[] groups = (SearchResultGroup[])engine.getResults();
        HashSet<IJavaElement> result = new HashSet<IJavaElement>(3);
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            SearchMatch[] results = group.getSearchResults();
            int j = 0;
            while (j < results.length) {
                SearchMatch searchResult = results[i];
                result.add(SearchUtils.getEnclosingJavaElement(searchResult));
                ++j;
            }
            ++i;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public PushDownRefactoringProcessor(IMember[] members) {
        super(members);
        if (members != null) {
            IType type = RefactoringAvailabilityTester.getTopLevelType(members);
            try {
                if (type != null && RefactoringAvailabilityTester.getPushDownMembers(type).length != 0) {
                    this.fMembersToMove = new IMember[0];
                    this.fDeclaringType = type;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
    }

    private void addAllRequiredPushableMembers(List queue, IMember member, IProgressMonitor monitor) throws JavaModelException {
        monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_calculating_required, 2);
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
        sub.beginTask(RefactoringCoreMessages.PushDownRefactoring_calculating_required, 2);
        IMethod[] requiredMethods = ReferenceFinderUtil.getMethodsReferencedIn(new IJavaElement[]{member}, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 1));
        sub = new SubProgressMonitor((IProgressMonitor)sub, 1);
        sub.beginTask(RefactoringCoreMessages.PushDownRefactoring_calculating_required, requiredMethods.length);
        int index = 0;
        while (index < requiredMethods.length) {
            IMethod method = requiredMethods[index];
            if (!MethodChecks.isVirtual(method) && method.getDeclaringType().equals(this.getDeclaringType()) && !queue.contains(method) && RefactoringAvailabilityTester.isPushDownAvailable((IMember)method)) {
                queue.add(method);
            }
            ++index;
        }
        sub.done();
        IField[] requiredFields = ReferenceFinderUtil.getFieldsReferencedIn(new IJavaElement[]{member}, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        int index2 = 0;
        while (index2 < requiredFields.length) {
            IField field = requiredFields[index2];
            if (field.getDeclaringType().equals(this.getDeclaringType()) && !queue.contains(field) && RefactoringAvailabilityTester.isPushDownAvailable((IMember)field)) {
                queue.add(field);
            }
            ++index2;
        }
        monitor.done();
    }

    private RefactoringStatus checkAbstractMembersInDestinationClasses(IMember[] membersToPushDown, IType[] destinationClassesForAbstract) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMember[] abstractMembersToPushDown = PushDownRefactoringProcessor.getAbstractMembers(membersToPushDown);
        int index = 0;
        while (index < destinationClassesForAbstract.length) {
            result.merge(MemberCheckUtil.checkMembersInDestinationType(abstractMembersToPushDown, destinationClassesForAbstract[index]));
            ++index;
        }
        return result;
    }

    private RefactoringStatus checkAccessedFields(IType[] subclasses, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMember[] membersToPushDown = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        List<IMember> pushedDownList = Arrays.asList(membersToPushDown);
        IField[] accessedFields = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])membersToPushDown, pm);
        int i = 0;
        while (i < subclasses.length) {
            IType targetClass = subclasses[i];
            ITypeHierarchy targetSupertypes = targetClass.newSupertypeHierarchy(null);
            int j = 0;
            while (j < accessedFields.length) {
                boolean isAccessible;
                IField field = accessedFields[j];
                boolean bl = isAccessible = pushedDownList.contains(field) || this.canBeAccessedFrom((IMember)field, targetClass, targetSupertypes) || Flags.isEnum((int)field.getFlags());
                if (!isAccessible) {
                    String message = Messages.format(RefactoringCoreMessages.PushDownRefactoring_field_not_accessible, new String[]{PushDownRefactoringProcessor.createFieldLabel(field), PushDownRefactoringProcessor.createTypeLabel(targetClass)});
                    result.addError(message, JavaStatusContext.create((IMember)field));
                }
                ++j;
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedMethods(IType[] subclasses, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMember[] membersToPushDown = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        List<IMember> pushedDownList = Arrays.asList(membersToPushDown);
        IMethod[] accessedMethods = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])membersToPushDown, pm);
        int index = 0;
        while (index < subclasses.length) {
            IType targetClass = subclasses[index];
            ITypeHierarchy targetSupertypes = targetClass.newSupertypeHierarchy(null);
            int offset = 0;
            while (offset < accessedMethods.length) {
                boolean isAccessible;
                IMethod method = accessedMethods[offset];
                boolean bl = isAccessible = pushedDownList.contains(method) || this.canBeAccessedFrom((IMember)method, targetClass, targetSupertypes);
                if (!isAccessible) {
                    String message = Messages.format(RefactoringCoreMessages.PushDownRefactoring_method_not_accessible, new String[]{PushDownRefactoringProcessor.createMethodLabel(method), PushDownRefactoringProcessor.createTypeLabel(targetClass)});
                    result.addError(message, JavaStatusContext.create((IMember)method));
                }
                ++offset;
            }
            ++index;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedTypes(IType[] subclasses, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] accessedTypes = this.getTypesReferencedInMovedMembers(pm);
        int index = 0;
        while (index < subclasses.length) {
            IType targetClass = subclasses[index];
            ITypeHierarchy targetSupertypes = targetClass.newSupertypeHierarchy(null);
            int offset = 0;
            while (offset < accessedTypes.length) {
                IType type = accessedTypes[offset];
                if (!this.canBeAccessedFrom((IMember)type, targetClass, targetSupertypes)) {
                    String message = Messages.format(RefactoringCoreMessages.PushDownRefactoring_type_not_accessible, new String[]{PushDownRefactoringProcessor.createTypeLabel(type), PushDownRefactoringProcessor.createTypeLabel(targetClass)});
                    result.addError(message, JavaStatusContext.create((IMember)type));
                }
                ++offset;
            }
            ++index;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkElementsAccessedByModifiedMembers(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(RefactoringCoreMessages.PushDownRefactoring_check_references, 3);
        IType[] subclasses = this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(pm, 1));
        result.merge(this.checkAccessedTypes(subclasses, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedFields(subclasses, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedMethods(subclasses, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus result;
        block5: {
            RefactoringStatus refactoringStatus;
            try {
                monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 5);
                this.clearCaches();
                result = new RefactoringStatus();
                result.merge(this.checkMembersInDestinationClasses((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                result.merge(this.checkElementsAccessedByModifiedMembers((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                result.merge(this.checkReferencesToPushedDownMembers((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                if (!JdtFlags.isAbstract((IMember)this.getDeclaringType()) && this.getAbstractDeclarationInfos().length != 0) {
                    result.merge(PushDownRefactoringProcessor.checkCallsToClassConstructors(this.getDeclaringType(), (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                } else {
                    monitor.worked(1);
                }
                if (!result.hasFatalError()) break block5;
                refactoringStatus = result;
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return refactoringStatus;
        }
        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(monitor, 1), result);
        result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), this.getRefactoring().getValidationContext()));
        RefactoringStatus refactoringStatus = result;
        Object var4_7 = null;
        monitor.done();
        return refactoringStatus;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus;
        RefactoringStatus result;
        block9: {
            block8: {
                block7: {
                    monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 1);
                    result = new RefactoringStatus();
                    this.fMembersToMove = WorkingCopyUtil.getOriginals(this.fMembersToMove);
                    result.merge(this.checkPossibleSubclasses((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                    if (!result.hasFatalError()) break block7;
                    RefactoringStatus refactoringStatus2 = result;
                    Object var6_7 = null;
                    monitor.done();
                    return refactoringStatus2;
                }
                result.merge(this.checkDeclaringType((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                if (!result.hasFatalError()) break block8;
                RefactoringStatus refactoringStatus3 = result;
                Object var6_8 = null;
                monitor.done();
                return refactoringStatus3;
            }
            result.merge(this.checkIfMembersExist());
            if (!result.hasFatalError()) break block9;
            RefactoringStatus refactoringStatus4 = result;
            Object var6_9 = null;
            monitor.done();
            return refactoringStatus4;
        }
        try {
            this.fMemberInfos = PushDownRefactoringProcessor.createInfosForAllPushableFieldsAndMethods(this.getDeclaringType());
            List<IMember> list = Arrays.asList(this.fMembersToMove);
            int offset = 0;
            while (offset < this.fMemberInfos.length) {
                MemberActionInfo info = this.fMemberInfos[offset];
                if (list.contains(info.getMember())) {
                    info.setAction(0);
                }
                ++offset;
            }
            refactoringStatus = result;
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkMembersInDestinationClasses(IProgressMonitor monitor) throws JavaModelException {
        monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 2);
        RefactoringStatus result = new RefactoringStatus();
        IMember[] membersToPushDown = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        IType[] destinationClassesForNonAbstract = this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        result.merge(this.checkNonAbstractMembersInDestinationClasses(membersToPushDown, destinationClassesForNonAbstract));
        List<IMember> list = Arrays.asList(PushDownRefactoringProcessor.getAbstractMembers((IMember[])this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(monitor, 1))));
        IType[] destinationClassesForAbstract = list.toArray(new IType[list.size()]);
        result.merge(this.checkAbstractMembersInDestinationClasses(membersToPushDown, destinationClassesForAbstract));
        monitor.done();
        return result;
    }

    private RefactoringStatus checkNonAbstractMembersInDestinationClasses(IMember[] membersToPushDown, IType[] destinationClassesForNonAbstract) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        ArrayList<IMember> list = new ArrayList<IMember>();
        list.addAll(Arrays.asList(membersToPushDown));
        list.removeAll(Arrays.asList(PushDownRefactoringProcessor.getAbstractMembers(membersToPushDown)));
        IMember[] nonAbstractMembersToPushDown = list.toArray(new IMember[list.size()]);
        int i = 0;
        while (i < destinationClassesForNonAbstract.length) {
            result.merge(MemberCheckUtil.checkMembersInDestinationType(nonAbstractMembersToPushDown, destinationClassesForNonAbstract[i]));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkPossibleSubclasses(IProgressMonitor pm) throws JavaModelException {
        IType[] modifiableSubclasses = this.getAbstractDestinations(pm);
        if (modifiableSubclasses.length == 0) {
            String msg = Messages.format(RefactoringCoreMessages.PushDownRefactoring_no_subclasses, new String[]{PushDownRefactoringProcessor.createTypeLabel(this.getDeclaringType())});
            return RefactoringStatus.createFatalErrorStatus((String)msg);
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkReferencesToPushedDownMembers(IProgressMonitor monitor) throws JavaModelException {
        ArrayList<IMember> fields = new ArrayList<IMember>(this.fMemberInfos.length);
        int index = 0;
        while (index < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[index];
            if (info.isToBePushedDown()) {
                fields.add(info.getMember());
            }
            ++index;
        }
        IMember[] membersToPush = fields.toArray(new IMember[fields.size()]);
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> movedMembers = Arrays.asList(MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass()));
        monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_check_references, membersToPush.length);
        int index2 = 0;
        while (index2 < membersToPush.length) {
            IMember member = membersToPush[index2];
            String label = PushDownRefactoringProcessor.createLabel(member);
            IJavaElement[] referencing = PushDownRefactoringProcessor.getReferencingElementsFromSameClass(member, (IProgressMonitor)new SubProgressMonitor(monitor, 1), result);
            int offset = 0;
            while (offset < referencing.length) {
                IJavaElement element = referencing[offset];
                if (!movedMembers.contains(element) && element instanceof IMember) {
                    IMember referencingMember = (IMember)element;
                    Object[] keys = new Object[]{label, PushDownRefactoringProcessor.createLabel(referencingMember)};
                    String msg = Messages.format(RefactoringCoreMessages.PushDownRefactoring_referenced, keys);
                    result.addError(msg, JavaStatusContext.create(referencingMember));
                }
                ++offset;
            }
            ++index2;
        }
        monitor.done();
        return result;
    }

    public void computeAdditionalRequiredMembersToPushDown(IProgressMonitor monitor) throws JavaModelException {
        List<IMember> list = Arrays.asList(this.getAdditionalRequiredMembers(monitor));
        int index = 0;
        while (index < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[index];
            if (list.contains(info.getMember())) {
                info.setAction(0);
            }
            ++index;
        }
    }

    private void copyBodyOfPushedDownMethod(ASTRewrite targetRewrite, IMethod method, MethodDeclaration oldMethod, MethodDeclaration newMethod, TypeVariableMaplet[] mapping) throws JavaModelException {
        Block body = oldMethod.getBody();
        if (body == null) {
            newMethod.setBody(null);
            return;
        }
        try {
            Document document = new Document(method.getCompilationUnit().getBuffer().getContents());
            ASTRewrite rewriter = ASTRewrite.create((AST)body.getAST());
            ITrackedNodePosition position = rewriter.track((ASTNode)body);
            body.accept((ASTVisitor)new HierarchyProcessor.TypeVariableMapper(rewriter, mapping));
            rewriter.rewriteAST((IDocument)document, this.getDeclaringType().getCompilationUnit().getJavaProject().getOptions(true)).apply((IDocument)document, 0);
            String content = document.get(position.getStartPosition(), position.getLength());
            String[] lines = Strings.convertIntoLines(content);
            Strings.trimIndentation(lines, method.getJavaProject(), false);
            content = Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)method));
            newMethod.setBody((Block)targetRewrite.createStringPlaceholder(content, 8));
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyMembers(Collection adjustors, Map adjustments, Map rewrites, RefactoringStatus status, MemberActionInfo[] infos, IType[] destinations, CompilationUnitRewrite sourceRewriter, CompilationUnitRewrite unitRewriter, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 1);
            IType type = null;
            TypeVariableMaplet[] mapping = null;
            int index = 0;
            while (index < destinations.length) {
                type = destinations[index];
                mapping = TypeVariableUtil.superTypeToInheritedType(this.getDeclaringType(), type);
                if (unitRewriter.getCu().equals(type.getCompilationUnit())) {
                    IMember member = null;
                    MemberVisibilityAdjustor adjustor = null;
                    AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(type, unitRewriter.getRoot());
                    int offset = infos.length - 1;
                    while (offset >= 0) {
                        member = infos[offset].getMember();
                        adjustor = new MemberVisibilityAdjustor((IJavaElement)type, member);
                        if (infos[offset].isNewMethodToBeDeclaredAbstract()) {
                            adjustor.setIncoming(false);
                        }
                        adjustor.setRewrite(sourceRewriter.getASTRewrite(), sourceRewriter.getRoot());
                        adjustor.setRewrites(rewrites);
                        adjustor.setFailureSeverity(2);
                        adjustor.setStatus(status);
                        adjustor.setAdjustments(adjustments);
                        adjustor.adjustVisibility((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        adjustments.remove(member);
                        adjustors.add(adjustor);
                        if (infos[offset].isFieldInfo()) {
                            VariableDeclarationFragment oldField = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)infos[offset].getMember(), sourceRewriter.getRoot());
                            if (oldField != null) {
                                FieldDeclaration newField = this.createNewFieldDeclarationNode(infos[offset], sourceRewriter.getRoot(), mapping, unitRewriter.getASTRewrite(), oldField);
                                unitRewriter.getASTRewrite().getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newField, ASTNodes.getInsertionIndex((BodyDeclaration)newField, declaration.bodyDeclarations()), unitRewriter.createGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member));
                                ImportRewriteUtil.addImports(unitRewriter, oldField.getParent(), new HashMap(), new HashMap(), false);
                            }
                        } else {
                            MethodDeclaration oldMethod = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)infos[offset].getMember(), sourceRewriter.getRoot());
                            if (oldMethod != null) {
                                MethodDeclaration newMethod = this.createNewMethodDeclarationNode(infos[offset], sourceRewriter.getRoot(), mapping, unitRewriter, oldMethod);
                                unitRewriter.getASTRewrite().getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newMethod, ASTNodes.getInsertionIndex((BodyDeclaration)newMethod, declaration.bodyDeclarations()), unitRewriter.createGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member));
                                ImportRewriteUtil.addImports(unitRewriter, (ASTNode)oldMethod, new HashMap(), new HashMap(), false);
                            }
                        }
                        --offset;
                    }
                }
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var19_21 = null;
        }
        monitor.done();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        DynamicValidationStateChange dynamicValidationStateChange;
        try {
            dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.PushDownRefactoring_change_name, (Change[])this.fChangeManager.getAllChanges()){

                public final ChangeDescriptor getDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    String project = null;
                    IType declaring = PushDownRefactoringProcessor.this.getDeclaringType();
                    IJavaProject javaProject = declaring.getJavaProject();
                    if (javaProject != null) {
                        project = javaProject.getElementName();
                    }
                    JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(PushDownRefactoringProcessor.ID_PUSH_DOWN, project, PushDownRefactoringProcessor.this.fMembersToMove.length == 1 ? NLS.bind((String)RefactoringCoreMessages.PushDownRefactoring_descriptor_description_full, (Object[])new String[]{JavaElementLabels.getElementLabel((IJavaElement)PushDownRefactoringProcessor.this.fMembersToMove[0], JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)declaring, JavaElementLabels.ALL_FULLY_QUALIFIED)}) : NLS.bind((String)RefactoringCoreMessages.PushDownRefactoring_descriptor_description, (Object[])new String[]{JavaElementLabels.getElementLabel((IJavaElement)declaring, JavaElementLabels.ALL_FULLY_QUALIFIED)}), PushDownRefactoringProcessor.this.getComment(), arguments, 65542);
                    if (PushDownRefactoringProcessor.this.fDeclaringType != null) {
                        arguments.put("input", descriptor.elementToHandle((IJavaElement)PushDownRefactoringProcessor.this.fDeclaringType));
                    }
                    int index = 0;
                    while (index < PushDownRefactoringProcessor.this.fMembersToMove.length) {
                        arguments.put("element" + (index + 1), descriptor.elementToHandle((IJavaElement)PushDownRefactoringProcessor.this.fMembersToMove[index]));
                        int offset = 0;
                        while (offset < PushDownRefactoringProcessor.this.fMemberInfos.length) {
                            if (PushDownRefactoringProcessor.this.fMemberInfos[offset].getMember().equals(PushDownRefactoringProcessor.this.fMembersToMove[index])) {
                                switch (PushDownRefactoringProcessor.this.fMemberInfos[offset].getAction()) {
                                    case 1: {
                                        arguments.put(PushDownRefactoringProcessor.ATTRIBUTE_ABSTRACT + (index + 1), Boolean.valueOf(true).toString());
                                        break;
                                    }
                                    case 0: {
                                        arguments.put(PushDownRefactoringProcessor.ATTRIBUTE_PUSH + (index + 1), Boolean.valueOf(true).toString());
                                    }
                                }
                            }
                            ++offset;
                        }
                        ++index;
                    }
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
                }
            };
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            this.clearCaches();
            throw throwable;
        }
        pm.done();
        this.clearCaches();
        return dynamicValidationStateChange;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TextChangeManager createChangeManager(IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        TextChangeManager textChangeManager;
        Assert.isNotNull(monitor);
        Assert.isNotNull(status);
        try {
            SubProgressMonitor sub;
            CompilationUnitRewrite rewrite;
            ICompilationUnit unit;
            ArrayList adjustors;
            HashMap adjustments;
            monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, 7);
            ICompilationUnit source = this.getDeclaringType().getCompilationUnit();
            CompilationUnitRewrite sourceRewriter = new CompilationUnitRewrite(source);
            HashMap<ICompilationUnit, CompilationUnitRewrite> rewrites = new HashMap<ICompilationUnit, CompilationUnitRewrite>(2);
            rewrites.put(source, sourceRewriter);
            IType[] types = this.getHierarchyOfDeclaringClass((IProgressMonitor)new SubProgressMonitor(monitor, 1)).getSubclasses(this.getDeclaringType());
            HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>(types.length + 1);
            int index = 0;
            while (true) {
                if (index >= types.length) {
                    result.add(source);
                    adjustments = new HashMap();
                    adjustors = new ArrayList();
                    ICompilationUnit[] units = result.toArray(new ICompilationUnit[result.size()]);
                    unit = null;
                    rewrite = null;
                    sub = new SubProgressMonitor(monitor, 4);
                    try {
                        sub.beginTask(RefactoringCoreMessages.PushDownRefactoring_checking, units.length * 4);
                        int index2 = 0;
                        while (index2 < units.length) {
                            int offset;
                            unit = units[index2];
                            rewrite = PushDownRefactoringProcessor.getCompilationUnitRewrite(rewrites, unit);
                            if (unit.equals(sourceRewriter.getCu())) {
                                AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(this.getDeclaringType(), rewrite.getRoot());
                                if (!JdtFlags.isAbstract((IMember)this.getDeclaringType()) && this.getAbstractDeclarationInfos().length != 0) {
                                    ModifierRewrite.create(rewrite.getASTRewrite(), (ASTNode)declaration).setModifiers(0x400 | declaration.getModifiers(), null);
                                }
                                PushDownRefactoringProcessor.deleteDeclarationNodes(sourceRewriter, false, rewrite, Arrays.asList(this.getDeletableMembers()));
                                MemberActionInfo[] methods = this.getAbstractDeclarationInfos();
                                offset = 0;
                                while (offset < methods.length) {
                                    this.declareMethodAbstract(methods[offset], sourceRewriter, rewrite);
                                    ++offset;
                                }
                            }
                            IMember[] members = PushDownRefactoringProcessor.getAbstractMembers((IMember[])this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                            IType[] classes = new IType[members.length];
                            offset = 0;
                            while (true) {
                                if (offset >= members.length) {
                                    this.copyMembers(adjustors, adjustments, rewrites, status, this.getAbstractMemberInfos(), classes, sourceRewriter, rewrite, (IProgressMonitor)sub);
                                    this.copyMembers(adjustors, adjustments, rewrites, status, this.getEffectedMemberInfos(), this.getAbstractDestinations((IProgressMonitor)new SubProgressMonitor(monitor, 1)), sourceRewriter, rewrite, (IProgressMonitor)sub);
                                    if (!monitor.isCanceled()) break;
                                    throw new OperationCanceledException();
                                }
                                classes[offset] = (IType)members[offset];
                                ++offset;
                            }
                            ++index2;
                        }
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var18_22 = null;
                        sub.done();
                        throw throwable;
                    }
                }
                result.add(types[index].getCompilationUnit());
                ++index;
            }
            {
                Object var18_23 = null;
            }
            sub.done();
            if (!adjustors.isEmpty() && !adjustments.isEmpty()) {
                MemberVisibilityAdjustor adjustor = (MemberVisibilityAdjustor)adjustors.get(0);
                adjustor.rewriteVisibility((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            TextChangeManager manager = new TextChangeManager();
            Iterator iterator = rewrites.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    textChangeManager = manager;
                    Object var20_25 = null;
                    break;
                }
                unit = (ICompilationUnit)iterator.next();
                rewrite = (CompilationUnitRewrite)rewrites.get(unit);
                if (rewrite == null) continue;
                manager.manage(unit, (TextChange)rewrite.createChange());
            }
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return textChangeManager;
    }

    private FieldDeclaration createNewFieldDeclarationNode(MemberActionInfo info, CompilationUnit declaringCuNode, TypeVariableMaplet[] mapping, ASTRewrite rewrite, VariableDeclarationFragment oldFieldFragment) throws JavaModelException {
        Assert.isTrue(info.isFieldInfo());
        IField field = (IField)info.getMember();
        AST ast = rewrite.getAST();
        VariableDeclarationFragment newFragment = ast.newVariableDeclarationFragment();
        newFragment.setExtraDimensions(oldFieldFragment.getExtraDimensions());
        Expression initializer = oldFieldFragment.getInitializer();
        if (initializer != null) {
            Expression newInitializer = null;
            newInitializer = mapping.length > 0 ? PushDownRefactoringProcessor.createPlaceholderForExpression(initializer, field.getCompilationUnit(), mapping, rewrite) : PushDownRefactoringProcessor.createPlaceholderForExpression(initializer, field.getCompilationUnit(), rewrite);
            newFragment.setInitializer(newInitializer);
        }
        newFragment.setName(ast.newSimpleName(oldFieldFragment.getName().getIdentifier()));
        FieldDeclaration newField = ast.newFieldDeclaration(newFragment);
        FieldDeclaration oldField = ASTNodeSearchUtil.getFieldDeclarationNode(field, declaringCuNode);
        if (info.copyJavadocToCopiesInSubclasses()) {
            PushDownRefactoringProcessor.copyJavadocNode(rewrite, (IMember)field, (BodyDeclaration)oldField, (BodyDeclaration)newField);
        }
        PushDownRefactoringProcessor.copyAnnotations(oldField, newField);
        newField.modifiers().addAll(ASTNodeFactory.newModifiers(ast, info.getNewModifiersForCopyInSubclass(oldField.getModifiers())));
        Type oldType = oldField.getType();
        ICompilationUnit cu = field.getCompilationUnit();
        Type newType = null;
        newType = mapping.length > 0 ? PushDownRefactoringProcessor.createPlaceholderForType(oldType, cu, mapping, rewrite) : PushDownRefactoringProcessor.createPlaceholderForType(oldType, cu, rewrite);
        newField.setType(newType);
        return newField;
    }

    private MethodDeclaration createNewMethodDeclarationNode(MemberActionInfo info, CompilationUnit declaringCuNode, TypeVariableMaplet[] mapping, CompilationUnitRewrite rewriter, MethodDeclaration oldMethod) throws JavaModelException {
        Assert.isTrue(!info.isFieldInfo());
        IMethod method = (IMethod)info.getMember();
        ASTRewrite rewrite = rewriter.getASTRewrite();
        AST ast = rewrite.getAST();
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        this.copyBodyOfPushedDownMethod(rewrite, method, oldMethod, newMethod, mapping);
        newMethod.setConstructor(oldMethod.isConstructor());
        newMethod.setExtraDimensions(oldMethod.getExtraDimensions());
        if (info.copyJavadocToCopiesInSubclasses()) {
            PushDownRefactoringProcessor.copyJavadocNode(rewrite, (IMember)method, (BodyDeclaration)oldMethod, (BodyDeclaration)newMethod);
        }
        IJavaProject project = rewriter.getCu().getJavaProject();
        if (info.isNewMethodToBeDeclaredAbstract() && JavaModelUtil.is50OrHigher(project) && JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)project).overrideAnnotation) {
            MarkerAnnotation annotation = ast.newMarkerAnnotation();
            annotation.setTypeName((Name)ast.newSimpleName("Override"));
            newMethod.modifiers().add(annotation);
        }
        PushDownRefactoringProcessor.copyAnnotations(oldMethod, newMethod);
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(ast, info.getNewModifiersForCopyInSubclass(oldMethod.getModifiers())));
        newMethod.setName(ast.newSimpleName(oldMethod.getName().getIdentifier()));
        this.copyReturnType(rewrite, method.getCompilationUnit(), oldMethod, newMethod, mapping);
        this.copyParameters(rewrite, method.getCompilationUnit(), oldMethod, newMethod, mapping);
        PushDownRefactoringProcessor.copyThrownExceptions(oldMethod, newMethod);
        PushDownRefactoringProcessor.copyTypeParameters(oldMethod, newMethod);
        return newMethod;
    }

    private void declareMethodAbstract(MemberActionInfo info, CompilationUnitRewrite sourceRewrite, CompilationUnitRewrite unitRewrite) throws JavaModelException {
        Assert.isTrue(!info.isFieldInfo());
        IMethod method = (IMethod)info.getMember();
        if (JdtFlags.isAbstract((IMember)method)) {
            return;
        }
        MethodDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(method, sourceRewrite.getRoot());
        unitRewrite.getASTRewrite().remove((ASTNode)declaration.getBody(), null);
        sourceRewrite.getImportRemover().registerRemovedNode((ASTNode)declaration.getBody());
        ModifierRewrite.create(unitRewrite.getASTRewrite(), (ASTNode)declaration).setModifiers(info.getNewModifiersForOriginal(declaration.getModifiers()), null);
    }

    private MemberActionInfo[] getAbstractDeclarationInfos() throws JavaModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        int index = 0;
        while (index < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[index];
            if (info.isNewMethodToBeDeclaredAbstract()) {
                result.add(info);
            }
            ++index;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private IType[] getAbstractDestinations(IProgressMonitor monitor) throws JavaModelException {
        IType[] allDirectSubclasses = this.getHierarchyOfDeclaringClass(monitor).getSubclasses(this.getDeclaringType());
        ArrayList<IType> result = new ArrayList<IType>(allDirectSubclasses.length);
        int index = 0;
        while (index < allDirectSubclasses.length) {
            IType subclass = allDirectSubclasses[index];
            if (subclass.exists() && !subclass.isBinary() && !subclass.isReadOnly() && subclass.getCompilationUnit() != null && subclass.isStructureKnown()) {
                result.add(subclass);
            }
            ++index;
        }
        return result.toArray(new IType[result.size()]);
    }

    private MemberActionInfo[] getAbstractMemberInfos() throws JavaModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        int index = 0;
        while (index < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[index];
            if (info.isToBeCreatedInSubclassesOfDeclaringClass() && JdtFlags.isAbstract(info.getMember())) {
                result.add(info);
            }
            ++index;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    public IMember[] getAdditionalRequiredMembers(IProgressMonitor monitor) throws JavaModelException {
        IMember current;
        IMember[] members = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        monitor.beginTask(RefactoringCoreMessages.PushDownRefactoring_calculating_required, members.length);
        ArrayList<IMember> queue = new ArrayList<IMember>(members.length);
        queue.addAll(Arrays.asList(members));
        if (queue.isEmpty()) {
            return new IMember[0];
        }
        int i = 0;
        do {
            current = (IMember)queue.get(i);
            this.addAllRequiredPushableMembers(queue, current, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (queue.size() != ++i) continue;
            current = null;
        } while (current != null);
        queue.removeAll(Arrays.asList(members));
        return queue.toArray(new IMember[queue.size()]);
    }

    private IMember[] getDeletableMembers() {
        ArrayList<IMember> result = new ArrayList<IMember>(this.fMemberInfos.length);
        int i = 0;
        while (i < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[i];
            if (info.isToBeDeletedFromDeclaringClass()) {
                result.add(info.getMember());
            }
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    private MemberActionInfo[] getEffectedMemberInfos() throws JavaModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        int i = 0;
        while (i < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[i];
            if (info.isToBeCreatedInSubclassesOfDeclaringClass() && !JdtFlags.isAbstract(info.getMember())) {
                result.add(info);
            }
            ++i;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    public Object[] getElements() {
        return this.fMembersToMove;
    }

    private ITypeHierarchy getHierarchyOfDeclaringClass(IProgressMonitor monitor) throws JavaModelException {
        block3: {
            ITypeHierarchy iTypeHierarchy;
            try {
                if (this.fCachedClassHierarchy == null) break block3;
                iTypeHierarchy = this.fCachedClassHierarchy;
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return iTypeHierarchy;
        }
        ITypeHierarchy iTypeHierarchy = this.fCachedClassHierarchy = this.getDeclaringType().newTypeHierarchy(monitor);
        Object var2_5 = null;
        monitor.done();
        return iTypeHierarchy;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    private MemberActionInfo[] getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass() throws JavaModelException {
        MemberActionInfo[] abs = this.getAbstractMemberInfos();
        MemberActionInfo[] nonabs = this.getEffectedMemberInfos();
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(abs.length + nonabs.length);
        result.addAll(Arrays.asList(abs));
        result.addAll(Arrays.asList(nonabs));
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    public MemberActionInfo[] getMemberActionInfos() {
        return this.fMemberInfos;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.PushDownRefactoring_name;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (arguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                IJavaElement element = JavaRefactoringDescriptor.handleToElement(extended.getProject(), handle);
                if (element == null || element.getElementType() != 7) {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_PUSH_DOWN));
                }
                this.fDeclaringType = (IType)element;
            }
            int count = 1;
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            ArrayList<MemberActionInfo> infos = new ArrayList<MemberActionInfo>();
            String attribute = "element" + count;
            RefactoringStatus status = new RefactoringStatus();
            while ((handle = extended.getAttribute(attribute)) != null) {
                IJavaElement element = JavaRefactoringDescriptor.handleToElement(extended.getProject(), handle);
                if (element == null) {
                    status.merge(RefactoringStatus.createWarningStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_PUSH_DOWN)));
                } else {
                    elements.add(element);
                }
                if (extended.getAttribute(ATTRIBUTE_ABSTRACT + count) != null) {
                    infos.add(MemberActionInfo.create((IMember)element, 1));
                } else if (extended.getAttribute(ATTRIBUTE_PUSH + count) != null) {
                    infos.add(MemberActionInfo.create((IMember)element, 0));
                } else {
                    infos.add(MemberActionInfo.create((IMember)element, 2));
                }
                attribute = "element" + ++count;
            }
            this.fMembersToMove = elements.toArray(new IMember[elements.size()]);
            this.fMemberInfos = infos.toArray(new MemberActionInfo[infos.size()]);
            if (!status.isOK()) {
                return status;
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isPushDownAvailable(this.fMembersToMove);
    }

    protected void rewriteTypeOccurrences(TextChangeManager manager, ASTRequestor requestor, CompilationUnitRewrite rewrite, ICompilationUnit unit, CompilationUnit node, Set replacements) throws CoreException {
    }

    public static class MemberActionInfo
    implements IMemberActionInfo {
        public static final int NO_ACTION = 2;
        public static final int PUSH_ABSTRACT_ACTION = 1;
        public static final int PUSH_DOWN_ACTION = 0;
        private int fAction;
        private final IMember fMember;

        private static void assertValidAction(IMember member, int action) {
            if (member instanceof IMethod) {
                Assert.isTrue(action == 1 || action == 2 || action == 0);
            } else if (member instanceof IField) {
                Assert.isTrue(action == 2 || action == 0);
            }
        }

        public static MemberActionInfo create(IMember member, int action) {
            return new MemberActionInfo(member, action);
        }

        static IMember[] getMembers(MemberActionInfo[] infos) {
            IMember[] result = new IMember[infos.length];
            int i = 0;
            while (i < result.length) {
                result[i] = infos[i].getMember();
                ++i;
            }
            return result;
        }

        private MemberActionInfo(IMember member, int action) {
            MemberActionInfo.assertValidAction(member, action);
            Assert.isTrue(member instanceof IField || member instanceof IMethod);
            this.fMember = member;
            this.fAction = action;
        }

        boolean copyJavadocToCopiesInSubclasses() {
            return this.isToBeDeletedFromDeclaringClass();
        }

        public int getAction() {
            return this.fAction;
        }

        public int[] getAvailableActions() {
            if (this.isFieldInfo()) {
                int[] nArray = new int[2];
                nArray[1] = 2;
                return nArray;
            }
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            return nArray;
        }

        public IMember getMember() {
            return this.fMember;
        }

        int getNewModifiersForCopyInSubclass(int oldModifiers) throws JavaModelException {
            if (this.isFieldInfo()) {
                return oldModifiers;
            }
            if (this.isToBeDeletedFromDeclaringClass()) {
                return oldModifiers;
            }
            int modifiers = oldModifiers;
            if (this.isNewMethodToBeDeclaredAbstract() && !JdtFlags.isPublic(this.fMember)) {
                modifiers = 4 | JdtFlags.clearAccessModifiers(modifiers);
            }
            return modifiers;
        }

        int getNewModifiersForOriginal(int oldModifiers) throws JavaModelException {
            if (this.isFieldInfo()) {
                return oldModifiers;
            }
            if (this.isToBeDeletedFromDeclaringClass()) {
                return oldModifiers;
            }
            int modifiers = oldModifiers;
            if (this.isNewMethodToBeDeclaredAbstract()) {
                modifiers = JdtFlags.clearFlag(272, oldModifiers);
                modifiers |= 0x400;
                if (!JdtFlags.isPublic(this.fMember)) {
                    modifiers = 4 | JdtFlags.clearAccessModifiers(modifiers);
                }
            }
            return modifiers;
        }

        public boolean isActive() {
            return this.getAction() != 2;
        }

        public boolean isEditable() {
            if (this.isFieldInfo()) {
                return false;
            }
            return this.getAction() != 2;
        }

        boolean isFieldInfo() {
            return this.fMember instanceof IField;
        }

        boolean isNewMethodToBeDeclaredAbstract() throws JavaModelException {
            return !this.isFieldInfo() && !JdtFlags.isAbstract(this.fMember) && this.fAction == 1;
        }

        boolean isToBeCreatedInSubclassesOfDeclaringClass() {
            return this.fAction != 2;
        }

        boolean isToBeDeletedFromDeclaringClass() {
            return this.isToBePushedDown();
        }

        public boolean isToBePushedDown() {
            return this.fAction == 0;
        }

        public void setAction(int action) {
            MemberActionInfo.assertValidAction(this.fMember, action);
            if (this.isFieldInfo()) {
                Assert.isTrue(action != 1);
            }
            this.fAction = action;
        }
    }
}

