/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;

public abstract class JavaElementResourceMapping
extends ResourceMapping {
    JavaElementResourceMapping() {
    }

    public IJavaElement getJavaElement() {
        Object o = this.getModelObject();
        if (o instanceof IJavaElement) {
            return (IJavaElement)o;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JavaElementResourceMapping)) {
            return false;
        }
        return this.getJavaElement().equals(((JavaElementResourceMapping)((Object)obj)).getJavaElement());
    }

    public int hashCode() {
        IJavaElement javaElement = this.getJavaElement();
        if (javaElement == null) {
            return super.hashCode();
        }
        return javaElement.hashCode();
    }

    public String getModelProviderId() {
        return "org.eclipse.jdt.ui.modelProvider";
    }

    private static IFile[] getPackageContent(IPackageFragment pack) throws CoreException {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IContainer container = (IContainer)pack.getResource();
        if (container != null) {
            IResource[] members = container.members();
            int m = 0;
            while (m < members.length) {
                IFile file;
                IResource member = members[m];
                if (!(!(member instanceof IFile) || "class".equals((file = (IFile)member).getFileExtension()) && file.isDerived())) {
                    result.add(member);
                }
                ++m;
            }
        }
        return result.toArray(new IFile[result.size()]);
    }

    public static ResourceMapping create(IJavaElement element) {
        switch (element.getElementType()) {
            case 7: {
                return JavaElementResourceMapping.create((IType)element);
            }
            case 5: {
                return JavaElementResourceMapping.create((ICompilationUnit)element);
            }
            case 6: {
                return JavaElementResourceMapping.create((IClassFile)element);
            }
            case 4: {
                return JavaElementResourceMapping.create((IPackageFragment)element);
            }
            case 3: {
                return JavaElementResourceMapping.create((IPackageFragmentRoot)element);
            }
            case 2: {
                return JavaElementResourceMapping.create((IJavaProject)element);
            }
            case 1: {
                return JavaElementResourceMapping.create((IJavaModel)element);
            }
        }
        return null;
    }

    public static ResourceMapping create(IJavaModel model) {
        return new JavaModelResourceMapping(model);
    }

    public static ResourceMapping create(IJavaProject project) {
        return new JavaProjectResourceMapping(project);
    }

    public static ResourceMapping create(IPackageFragmentRoot root) {
        if (root.isExternal()) {
            return null;
        }
        return new PackageFragementRootResourceMapping(root);
    }

    public static ResourceMapping create(IPackageFragment pack) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)pack.getAncestor(3);
        if (!root.isArchive()) {
            return new PackageFragmentResourceMapping(pack);
        }
        return null;
    }

    public static ResourceMapping create(ICompilationUnit unit) {
        if ((unit = JavaModelUtil.toOriginal(unit)) == null) {
            return null;
        }
        return new CompilationUnitResourceMapping(unit);
    }

    public static ResourceMapping create(IClassFile classFile) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)classFile.getAncestor(3);
        if (!root.isArchive()) {
            return new ClassFileResourceMapping(classFile);
        }
        return null;
    }

    public static ResourceMapping create(IType type) {
        IJavaElement parent = type.getParent();
        if (parent instanceof ICompilationUnit) {
            return JavaElementResourceMapping.create((ICompilationUnit)parent);
        }
        return null;
    }

    public static ResourceMapping create(LogicalPackage logicalPackage) {
        IPackageFragment[] fragments = logicalPackage.getFragments();
        ArrayList<IPackageFragment> toProcess = new ArrayList<IPackageFragment>(fragments.length);
        int i = 0;
        while (i < fragments.length) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)fragments[i].getAncestor(3);
            if (!root.isArchive()) {
                toProcess.add(fragments[i]);
            }
            ++i;
        }
        if (toProcess.size() == 0) {
            return null;
        }
        return new LogicalPackageResourceMapping(toProcess.toArray(new IPackageFragment[toProcess.size()]));
    }

    private static final class JavaModelResourceMapping
    extends JavaElementResourceMapping {
        private final IJavaModel fJavaModel;

        JavaModelResourceMapping(IJavaModel model) {
            Assert.isNotNull(model);
            this.fJavaModel = model;
        }

        public Object getModelObject() {
            return this.fJavaModel;
        }

        public IProject[] getProjects() {
            IJavaProject[] projects = null;
            try {
                projects = this.fJavaModel.getJavaProjects();
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return new IProject[0];
            }
            IProject[] result = new IProject[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = projects[i].getProject();
                ++i;
            }
            return result;
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            IJavaProject[] projects = this.fJavaModel.getJavaProjects();
            ResourceTraversal[] result = new ResourceTraversal[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = new ResourceTraversal(new IResource[]{projects[i].getProject()}, 2, 0);
                ++i;
            }
            return result;
        }
    }

    private static final class JavaProjectResourceMapping
    extends JavaElementResourceMapping {
        private final IJavaProject fProject;

        JavaProjectResourceMapping(IJavaProject project) {
            Assert.isNotNull(project);
            this.fProject = project;
        }

        public Object getModelObject() {
            return this.fProject;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fProject.getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fProject.getProject()}, 2, 0)};
        }
    }

    private static final class PackageFragementRootResourceMapping
    extends JavaElementResourceMapping {
        private final IPackageFragmentRoot fRoot;

        PackageFragementRootResourceMapping(IPackageFragmentRoot root) {
            Assert.isNotNull(root);
            this.fRoot = root;
        }

        public Object getModelObject() {
            return this.fRoot;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fRoot.getJavaProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fRoot.getResource()}, 2, 0)};
        }
    }

    private static final class LocalPackageFragementTraversal
    extends ResourceTraversal {
        private final IPackageFragment fPack;

        public LocalPackageFragementTraversal(IPackageFragment pack) throws CoreException {
            super(new IResource[]{pack.getResource()}, 1, 0);
            this.fPack = pack;
        }

        public void accept(IResourceVisitor visitor) throws CoreException {
            IFile[] files = JavaElementResourceMapping.getPackageContent(this.fPack);
            IResource resource = this.fPack.getResource();
            if (resource != null) {
                visitor.visit(resource);
            }
            int i = 0;
            while (i < files.length) {
                visitor.visit((IResource)files[i]);
                ++i;
            }
        }
    }

    private static final class PackageFragmentResourceMapping
    extends JavaElementResourceMapping {
        private final IPackageFragment fPack;

        PackageFragmentResourceMapping(IPackageFragment pack) {
            Assert.isNotNull(pack);
            this.fPack = pack;
        }

        public Object getModelObject() {
            return this.fPack;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fPack.getJavaProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            if (context instanceof RemoteResourceMappingContext) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fPack.getResource()}, 1, 0)};
            }
            return new ResourceTraversal[]{new LocalPackageFragementTraversal(this.fPack)};
        }

        public void accept(ResourceMappingContext context, IResourceVisitor visitor, IProgressMonitor monitor) throws CoreException {
            if (context instanceof RemoteResourceMappingContext) {
                super.accept(context, visitor, monitor);
            } else {
                IFile[] files = JavaElementResourceMapping.getPackageContent(this.fPack);
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("", files.length + 1);
                IResource resource = this.fPack.getResource();
                if (resource != null) {
                    visitor.visit(resource);
                }
                monitor.worked(1);
                int i = 0;
                while (i < files.length) {
                    visitor.visit((IResource)files[i]);
                    monitor.worked(1);
                    ++i;
                }
            }
        }
    }

    private static final class CompilationUnitResourceMapping
    extends JavaElementResourceMapping {
        private final ICompilationUnit fUnit;

        CompilationUnitResourceMapping(ICompilationUnit unit) {
            Assert.isNotNull(unit);
            this.fUnit = unit;
        }

        public Object getModelObject() {
            return this.fUnit;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fUnit.getJavaProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fUnit.getResource()}, 1, 0)};
        }
    }

    private static final class ClassFileResourceMapping
    extends JavaElementResourceMapping {
        private final IClassFile fClassFile;

        ClassFileResourceMapping(IClassFile classFile) {
            this.fClassFile = classFile;
        }

        public Object getModelObject() {
            return this.fClassFile;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fClassFile.getJavaProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fClassFile.getResource()}, 1, 0)};
        }
    }

    private static final class LogicalPackageResourceMapping
    extends ResourceMapping {
        private final IPackageFragment[] fFragments;

        LogicalPackageResourceMapping(IPackageFragment[] fragments) {
            this.fFragments = fragments;
        }

        public Object getModelObject() {
            return this.fFragments;
        }

        public IProject[] getProjects() {
            HashSet<IProject> result = new HashSet<IProject>();
            int i = 0;
            while (i < this.fFragments.length) {
                result.add(this.fFragments[i].getJavaProject().getProject());
                ++i;
            }
            return result.toArray(new IProject[result.size()]);
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
            if (context instanceof RemoteResourceMappingContext) {
                int i = 0;
                while (i < this.fFragments.length) {
                    result.add(new ResourceTraversal(new IResource[]{this.fFragments[i].getResource()}, 1, 0));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.fFragments.length) {
                    result.add(new LocalPackageFragementTraversal(this.fFragments[i]));
                    ++i;
                }
            }
            return result.toArray(new ResourceTraversal[result.size()]);
        }

        public String getModelProviderId() {
            return "org.eclipse.jdt.ui.modelProvider";
        }
    }
}

