/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.deprecation;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.deprecation.DeprecationMessages;
import org.eclipse.jdt.internal.ui.refactoring.binary.StubRefactoringHistoryWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;

public final class FixDeprecationRefactoringWizard
extends StubRefactoringHistoryWizard {
    private static String DIALOG_SETTINGS_KEY = "FixDeprecationWizard";
    private final ICompilationUnit fCompilationUnit;
    private final int fLength;
    private boolean fNewSettings;
    private final int fOffset;
    private IPackageFragmentRoot fPackageFragmentRoot;
    private RefactoringHistory fRefactoringHistory = null;

    public FixDeprecationRefactoringWizard(boolean overview, ICompilationUnit unit, int offset, int length) {
        super(overview, DeprecationMessages.FixDeprecationRefactoringWizard_caption, DeprecationMessages.FixDeprecationRefactoringWizard_title, DeprecationMessages.FixDeprecationRefactoringWizard_description);
        Assert.isNotNull((Object)unit);
        Assert.isTrue((offset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((length >= 0 ? 1 : 0) != 0);
        this.fCompilationUnit = unit;
        this.fOffset = offset;
        this.fLength = length;
        this.setInput(new RefactoringHistoryProxy());
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_REFACTOR);
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fNewSettings = true;
        } else {
            this.fNewSettings = false;
            this.setDialogSettings(section);
        }
        this.setConfiguration(new RefactoringHistoryControlConfiguration(null, false, false){

            public String getProjectPattern() {
                return DeprecationMessages.FixDeprecationRefactoringWizard_project_pattern;
            }

            public String getWorkspaceCaption() {
                return DeprecationMessages.FixDeprecationRefactoringWizard_workspace_caption;
            }
        });
    }

    public boolean canFinish() {
        return super.canFinish() && this.fRefactoringHistory != null;
    }

    protected Refactoring createRefactoring(RefactoringDescriptor descriptor, RefactoringStatus status) throws CoreException {
        if (descriptor instanceof JavaRefactoringDescriptor) {
            String selection;
            IJavaElement element;
            JavaRefactoringDescriptor extended = (JavaRefactoringDescriptor)descriptor;
            String project = extended.getProject();
            HashMap<String, String> arguments = new HashMap<String, String>(extended.getArguments());
            String handle = (String)arguments.get("input");
            if (handle != null && !"".equals(handle) && (element = JavaRefactoringDescriptor.handleToElement(project, handle)) != null) {
                if (element instanceof ICompilationUnit) {
                    arguments.put("input", JavaRefactoringDescriptor.elementToHandle(project, (IJavaElement)this.fCompilationUnit));
                }
                project = this.fCompilationUnit.getJavaProject().getElementName();
            }
            if ((selection = (String)arguments.get("selection")) != null) {
                StringBuffer buffer = new StringBuffer(8);
                buffer.append(this.fOffset);
                buffer.append(' ');
                buffer.append(this.fLength);
                arguments.put("selection", buffer.toString());
            }
            return super.createRefactoring(new JavaRefactoringDescriptor(extended.getID(), project, extended.getDescription(), extended.getComment(), arguments, extended.getFlags()), status);
        }
        return super.createRefactoring(descriptor, status);
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fPackageFragmentRoot;
    }

    public RefactoringHistory getRefactoringHistory() {
        return this.fRefactoringHistory;
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (this.fNewSettings) {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
            section = settings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        return result;
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot root) {
        this.fPackageFragmentRoot = root;
    }

    public void setRefactoringHistory(RefactoringHistory history) {
        this.fRefactoringHistory = history;
    }

    private final class RefactoringHistoryProxy
    extends RefactoringHistory {
        RefactoringHistoryProxy() {
        }

        public RefactoringDescriptorProxy[] getDescriptors() {
            if (FixDeprecationRefactoringWizard.this.fRefactoringHistory != null) {
                return FixDeprecationRefactoringWizard.this.fRefactoringHistory.getDescriptors();
            }
            return new RefactoringDescriptorProxy[0];
        }

        public boolean isEmpty() {
            RefactoringDescriptorProxy[] proxies = this.getDescriptors();
            if (proxies != null) {
                return proxies.length == 0;
            }
            return true;
        }

        public RefactoringHistory removeAll(RefactoringHistory history) {
            throw new UnsupportedOperationException();
        }
    }
}

