/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.IJarPackageWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.ltk.ui.refactoring.history.IRefactoringHistoryControl;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

final class JarPackagePreviewPage
extends WizardPage
implements IJarPackageWizardPage {
    private static final String PAGE_NAME = "jarPreviewWizardPage";
    protected final RefactoringHistoryControlConfiguration fControlConfiguration;
    protected IRefactoringHistoryControl fHistoryControl = null;
    protected final JarPackageData fJarPackageData;

    public JarPackagePreviewPage(JarPackageData data, RefactoringHistoryControlConfiguration configuration) {
        super(PAGE_NAME);
        Assert.isNotNull(configuration);
        Assert.isNotNull(data);
        this.fControlConfiguration = configuration;
        this.fJarPackageData = data;
        this.setTitle(JarPackagerMessages.RefactoringPreviewPage_title);
        this.setDescription(JarPackagerMessages.RefactoringPreviewPage_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.fHistoryControl = (IRefactoringHistoryControl)RefactoringUI.createRefactoringHistoryControl((Composite)composite, (RefactoringHistoryControlConfiguration)this.fControlConfiguration);
        this.fHistoryControl.createControl();
        this.fHistoryControl.addCheckStateListener(new ICheckStateListener(){

            public final void checkStateChanged(CheckStateChangedEvent event) {
                JarPackagePreviewPage.this.fJarPackageData.setRefactoringDescriptors(JarPackagePreviewPage.this.fHistoryControl.getCheckedDescriptors());
                JarPackagePreviewPage.this.getContainer().updateButtons();
            }
        });
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.jar_preview_wizard_page_context");
    }

    public void finish() {
    }

    protected RefactoringHistory getRefactoringHistory() {
        final RefactoringHistory[] history = new RefactoringHistory[1];
        final IProject[] projects = this.fJarPackageData.getRefactoringProjects();
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    history[0] = JarPackagerUtil.getRefactoringHistory(projects, 0L, Long.MAX_VALUE, JarPackagePreviewPage.this.fJarPackageData.isExportStructuralOnly() ? 2 : 0, monitor);
                }
            });
        }
        catch (InvocationTargetException exception) {
            JavaPlugin.log(exception);
        }
        catch (InterruptedException interruptedException) {}
        return history[0];
    }

    public final void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.fJarPackageData.isRefactoringAware()) {
            if (visible) {
                RefactoringHistory history = this.getRefactoringHistory();
                if (history != null) {
                    this.fHistoryControl.setInput(history);
                    this.fHistoryControl.setCheckedDescriptors(this.fJarPackageData.getRefactoringDescriptors());
                }
            } else {
                this.fHistoryControl.setInput(null);
            }
        }
    }
}

