/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.MultiActionGroup;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class CommonLayoutActionGroup
extends MultiActionGroup {
    private boolean fHasContributedToViewMenu = false;
    private IAction fHierarchicalLayout = null;
    private IAction fFlatLayoutAction = null;

    public CommonLayoutActionGroup(StructuredViewer structuredViewer, IExtensionStateModel stateModel) {
        IAction[] actions = this.createActions(structuredViewer, stateModel);
        this.setActions(actions, stateModel.getBooleanProperty("isLayoutFlat") ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (!this.fHasContributedToViewMenu) {
            CommonLayoutActionGroup commonLayoutActionGroup = this;
            synchronized (commonLayoutActionGroup) {
                if (!this.fHasContributedToViewMenu) {
                    this.fHasContributedToViewMenu = true;
                    this.contributeToViewMenu(actionBars.getMenuManager());
                }
            }
        }
    }

    private void contributeToViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(PackagesMessages.LayoutActionGroup_label);
        Separator marker = new Separator("layout");
        viewMenu.add((IContributionItem)new Separator("additions"));
        viewMenu.add((IContributionItem)marker);
        viewMenu.appendToGroup("layout", (IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator("additions-end"));
        this.addActions((IMenuManager)layoutSubMenu);
    }

    private IAction[] createActions(StructuredViewer structuredViewer, IExtensionStateModel stateModel) {
        this.fFlatLayoutAction = new CommonLayoutAction(structuredViewer, stateModel, true);
        this.fFlatLayoutAction.setText(PackagesMessages.LayoutActionGroup_flatLayoutAction_label);
        JavaPluginImages.setLocalImageDescriptors(this.fFlatLayoutAction, "flatLayout.gif");
        this.fHierarchicalLayout = new CommonLayoutAction(structuredViewer, stateModel, false);
        this.fHierarchicalLayout.setText(PackagesMessages.LayoutActionGroup_hierarchicalLayoutAction_label);
        JavaPluginImages.setLocalImageDescriptors(this.fHierarchicalLayout, "hierarchicalLayout.gif");
        this.fHierarchicalLayout.setChecked(!stateModel.getBooleanProperty("isLayoutFlat"));
        this.fFlatLayoutAction.setChecked(stateModel.getBooleanProperty("isLayoutFlat"));
        return new IAction[]{this.fFlatLayoutAction, this.fHierarchicalLayout};
    }

    public void setFlatLayout(boolean flatLayout) {
        this.fHierarchicalLayout.setChecked(!flatLayout);
        this.fFlatLayoutAction.setChecked(flatLayout);
    }

    private static class CommonLayoutAction
    extends Action
    implements IAction {
        private final boolean fIsFlatLayout;
        private IExtensionStateModel fStateModel;
        private StructuredViewer fStructuredViewer;

        public CommonLayoutAction(StructuredViewer structuredViewer, IExtensionStateModel stateModel, boolean flat) {
            super("", 8);
            this.fStateModel = stateModel;
            this.fStructuredViewer = structuredViewer;
            this.fIsFlatLayout = flat;
            if (this.fIsFlatLayout) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.layout_flat_action");
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.layout_hierarchical_action");
            }
        }

        public void run() {
            if (this.fStateModel.getBooleanProperty("isLayoutFlat") != this.fIsFlatLayout) {
                this.fStateModel.setBooleanProperty("isLayoutFlat", this.fIsFlatLayout);
                this.fStructuredViewer.getControl().setRedraw(false);
                this.fStructuredViewer.refresh();
                this.fStructuredViewer.getControl().setRedraw(true);
            }
        }
    }
}

