/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentProvider;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class PackageExplorerContentProvider
extends StandardJavaElementContentProvider
implements ITreeContentProvider,
IElementChangedListener {
    protected static final int ORIGINAL = 0;
    protected static final int PARENT = 1;
    protected static final int GRANT_PARENT = 2;
    protected static final int PROJECT = 4;
    TreeViewer fViewer;
    private Object fInput;
    private boolean fIsFlatLayout;
    private PackageFragmentProvider fPackageFragmentProvider = new PackageFragmentProvider();
    private int fPendingChanges;

    public PackageExplorerContentProvider(boolean provideMembers) {
        super(provideMembers);
    }

    public PackageExplorerContentProvider(PackageExplorerPart part, boolean provideMembers) {
        super(provideMembers);
    }

    PackageFragmentProvider getPackageFragmentProvider() {
        return this.fPackageFragmentProvider;
    }

    protected Object getViewerInput() {
        return this.fInput;
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            if (this.inputDeleted()) {
                return;
            }
            this.processDelta(event.getDelta());
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private boolean inputDeleted() {
        if (this.fInput == null) {
            return false;
        }
        if (this.fInput instanceof IJavaElement && ((IJavaElement)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof IResource && ((IResource)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof WorkingSetModel) {
            return false;
        }
        this.postRefresh(this.fInput, 0, this.fInput);
        return true;
    }

    public void dispose() {
        super.dispose();
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this.fPackageFragmentProvider.dispose();
    }

    private boolean needsToDelegateGetChildren(Object element) {
        int type = -1;
        if (element instanceof IJavaElement) {
            type = ((IJavaElement)element).getElementType();
        }
        return !this.fIsFlatLayout && (type == 4 || type == 3 || type == 2 || element instanceof IFolder);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = NO_CHILDREN;
        try {
            if (parentElement instanceof IJavaModel) {
                return PackageExplorerContentProvider.concatenate(this.getJavaProjects((IJavaModel)parentElement), this.getNonJavaProjects((IJavaModel)parentElement));
            }
            if (parentElement instanceof ClassPathContainer) {
                return this.getContainerPackageFragmentRoots((ClassPathContainer)parentElement);
            }
            if (parentElement instanceof IProject) {
                return ((IProject)parentElement).members();
            }
            if (this.needsToDelegateGetChildren(parentElement)) {
                Object[] packageFragments = this.fPackageFragmentProvider.getChildren(parentElement);
                children = this.getWithParentsResources(packageFragments, parentElement);
            } else {
                children = super.getChildren(parentElement);
            }
            if (parentElement instanceof IJavaProject) {
                IJavaProject project = (IJavaProject)parentElement;
                return this.rootsAndContainers(project, children);
            }
            return children;
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    private Object[] rootsAndContainers(IJavaProject project, Object[] roots) throws JavaModelException {
        ArrayList<Object> result = new ArrayList<Object>(roots.length);
        HashSet<IClasspathEntry> containers = new HashSet<IClasspathEntry>(roots.length);
        HashSet<IPackageFragmentRoot> containedRoots = new HashSet<IPackageFragmentRoot>(roots.length);
        IClasspathEntry[] entries = project.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry != null && entry.getEntryKind() == 5) {
                IPackageFragmentRoot[] roots1 = project.findPackageFragmentRoots(entry);
                containedRoots.addAll(Arrays.asList(roots1));
                containers.add(entry);
            }
            ++i;
        }
        i = 0;
        while (i < roots.length) {
            if (roots[i] instanceof IPackageFragmentRoot) {
                if (!containedRoots.contains(roots[i])) {
                    result.add(roots[i]);
                }
            } else {
                result.add(roots[i]);
            }
            ++i;
        }
        Iterator each = containers.iterator();
        while (each.hasNext()) {
            IClasspathEntry element = (IClasspathEntry)each.next();
            result.add(new ClassPathContainer(project, element));
        }
        return result.toArray();
    }

    private Object[] getContainerPackageFragmentRoots(ClassPathContainer container) {
        return container.getChildren(container);
    }

    private Object[] getNonJavaProjects(IJavaModel model) throws JavaModelException {
        return model.getNonJavaResources();
    }

    public Object getParent(Object child) {
        if (this.needsToDelegateGetParent(child)) {
            return this.fPackageFragmentProvider.getParent(child);
        }
        return super.getParent(child);
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            IJavaProject project = root.getJavaProject();
            try {
                IClasspathEntry[] entries = project.getRawClasspath();
                int i = 0;
                while (i < entries.length) {
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() == 5 && ClassPathContainer.contains(project, entry, root)) {
                        return new ClassPathContainer(project, entry);
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        if (element instanceof ClassPathContainer) {
            return ((ClassPathContainer)element).getJavaProject();
        }
        return super.internalGetParent(element);
    }

    private boolean needsToDelegateGetParent(Object element) {
        int type = -1;
        if (element instanceof IJavaElement) {
            type = ((IJavaElement)element).getElementType();
        }
        return !this.fIsFlatLayout && type == 4;
    }

    private Object[] getWithParentsResources(Object[] existingObject, Object parent) {
        Object[] objects = super.getChildren(parent);
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (!(object instanceof IPackageFragment)) {
                list.add(object);
            }
            ++i;
        }
        if (existingObject != null) {
            list.addAll(Arrays.asList(existingObject));
        }
        return list.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fPackageFragmentProvider.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (TreeViewer)viewer;
        if (oldInput == null && newInput != null) {
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        } else if (oldInput != null && newInput == null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = newInput;
    }

    private void processDelta(IJavaElementDelta delta) throws JavaModelException {
        Object parent;
        IJavaProject proj;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IJavaElement element = delta.getElement();
        int elementType = element.getElementType();
        if (!(elementType == 1 || elementType == 2 || (proj = element.getJavaProject()) != null && proj.getProject().isOpen())) {
            return;
        }
        if (!this.fIsFlatLayout && elementType == 4) {
            this.fPackageFragmentProvider.processDelta(delta);
            if (this.processResourceDeltas(delta.getResourceDeltas(), element)) {
                return;
            }
            this.handleAffectedChildren(delta, element);
            return;
        }
        if (elementType == 5) {
            ICompilationUnit cu = (ICompilationUnit)element;
            if (!JavaModelUtil.isPrimary(cu)) {
                return;
            }
            if (!this.getProvideMembers() && cu.isWorkingCopy() && kind == 4) {
                return;
            }
            if (kind == 4 && !PackageExplorerContentProvider.isStructuralCUChange(flags)) {
                return;
            }
            if (!this.isOnClassPath(cu)) {
                return;
            }
        }
        if (elementType == 2) {
            if ((flags & 0x600) != 0) {
                this.postRefresh(element, 0, element);
                return;
            }
            if ((flags & 0x20000) != 0) {
                this.postRefresh(element, 0, element);
                return;
            }
        }
        if (kind == 2) {
            parent = this.internalGetParent(element);
            if (element instanceof IPackageFragment) {
                if (this.fViewer.testFindItem(parent) != null) {
                    this.postRefresh(parent, 1, element);
                }
                return;
            }
            this.postRemove(element);
            if (parent instanceof IPackageFragment) {
                this.postUpdateIcon((IJavaElement)((IPackageFragment)parent));
            }
            if (this.isPackageFragmentEmpty(element.getParent()) && this.fViewer.testFindItem(parent) != null) {
                this.postRefresh(this.internalGetParent(parent), 2, element);
            }
            return;
        }
        if (kind == 1) {
            parent = this.internalGetParent(element);
            if (parent instanceof IPackageFragment) {
                Object grandparent = this.internalGetParent(parent);
                if (parent.equals(this.fInput)) {
                    this.postRefresh(parent, 1, element);
                } else if (this.fViewer.testFindItem(parent) == null) {
                    this.postRefresh(grandparent, 2, element);
                } else {
                    this.postRefresh(parent, 1, element);
                }
                return;
            }
            this.postAdd(parent, element);
        }
        if (elementType == 5) {
            if (kind == 4) {
                this.postRefresh(element, 0, element);
                this.updateSelection(delta);
            }
            return;
        }
        if (elementType == 6) {
            return;
        }
        if (elementType == 3) {
            if ((flags & 0x8000) != 0) {
                this.postRefresh(element, 0, element);
                return;
            }
            if ((flags & 0x3000) != 0) {
                this.postUpdateIcon(element);
            }
            if (this.isClassPathChange(delta)) {
                this.postRefresh(element.getJavaProject(), 4, element);
                return;
            }
        }
        if (this.processResourceDeltas(delta.getResourceDeltas(), element)) {
            return;
        }
        this.handleAffectedChildren(delta, element);
    }

    private static boolean isStructuralCUChange(int flags) {
        return (flags & 8) != 0 || (flags & 0x4001) == 1;
    }

    void handleAffectedChildren(IJavaElementDelta delta, IJavaElement element) throws JavaModelException {
        IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
        if (affectedChildren.length > 1) {
            if (element instanceof IPackageFragment) {
                IJavaElement parent = (IJavaElement)this.internalGetParent(element);
                if (element.equals(this.fInput)) {
                    this.postRefresh(element, 0, element);
                } else {
                    this.postRefresh(parent, 1, element);
                }
                return;
            }
            if (element instanceof IPackageFragmentRoot) {
                Object toRefresh = this.skipProjectPackageFragmentRoot((IPackageFragmentRoot)element);
                this.postRefresh(toRefresh, 0, toRefresh);
            } else {
                this.postRefresh(element, 0, element);
            }
            return;
        }
        this.processAffectedChildren(affectedChildren);
    }

    protected void processAffectedChildren(IJavaElementDelta[] affectedChildren) throws JavaModelException {
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private boolean isOnClassPath(ICompilationUnit element) {
        IJavaProject project = element.getJavaProject();
        if (project == null || !project.exists()) {
            return false;
        }
        return project.isOnClasspath((IJavaElement)element);
    }

    private void updateSelection(IJavaElementDelta delta) {
        final IJavaElement addedElement = this.findAddedElement(delta);
        if (addedElement != null) {
            final StructuredSelection selection = new StructuredSelection((Object)addedElement);
            this.postRunnable(new Runnable(){

                public void run() {
                    Control ctrl = PackageExplorerContentProvider.this.fViewer.getControl();
                    if (ctrl != null && !ctrl.isDisposed() && PackageExplorerContentProvider.this.fViewer.testFindItem((Object)addedElement) != null) {
                        PackageExplorerContentProvider.this.fViewer.setSelection((ISelection)selection);
                    }
                }
            });
        }
    }

    private IJavaElement findAddedElement(IJavaElementDelta delta) {
        if (delta.getKind() == 1) {
            return delta.getElement();
        }
        IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        if (i < affectedChildren.length) {
            return this.findAddedElement(affectedChildren[i]);
        }
        return null;
    }

    private void postUpdateIcon(final IJavaElement element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackageExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    PackageExplorerContentProvider.this.fViewer.update((Object)element, new String[]{"org.eclipse.jface.image"});
                }
            }
        });
    }

    private boolean processResourceDelta(IResourceDelta delta, Object parent) {
        int status = delta.getKind();
        int flags = delta.getFlags();
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if ((status & 2) != 0) {
            if (parent instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(parent), 1, parent);
                return true;
            }
            this.postRemove(resource);
        }
        if ((status & 1) != 0) {
            if (parent instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(parent), 1, parent);
                return true;
            }
            this.postAdd(parent, resource);
        }
        if ((flags & 0x4000) != 0) {
            this.postProjectStateChanged(this.internalGetParent(parent));
            return true;
        }
        this.processResourceDeltas(delta.getAffectedChildren(), resource);
        return false;
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
    }

    private boolean processResourceDeltas(IResourceDelta[] deltas, Object parent) {
        if (deltas == null) {
            return false;
        }
        if (deltas.length > 1) {
            this.postRefresh(parent, 0, parent);
            return true;
        }
        int i = 0;
        while (i < deltas.length) {
            if (this.processResourceDelta(deltas[i], parent)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void postRefresh(Object root, int relation, Object affectedElement) {
        if (this.isParent(root, this.fInput)) {
            root = this.fInput;
        }
        ArrayList<Object> toRefresh = new ArrayList<Object>(1);
        toRefresh.add(root);
        this.augmentElementToRefresh(toRefresh, relation, affectedElement);
        this.postRefresh(toRefresh, true);
    }

    protected void augmentElementToRefresh(List toRefresh, int relation, Object affectedElement) {
    }

    boolean isParent(Object root, Object child) {
        Object parent = this.getParent(child);
        if (parent == null) {
            return false;
        }
        if (parent.equals(root)) {
            return true;
        }
        return this.isParent(root, parent);
    }

    protected void postRefresh(final List toRefresh, final boolean updateLabels) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackageExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    Iterator iter = toRefresh.iterator();
                    while (iter.hasNext()) {
                        PackageExplorerContentProvider.this.fViewer.refresh(iter.next(), updateLabels);
                    }
                }
            }
        });
    }

    protected void postAdd(final Object parent, final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackageExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed() && PackageExplorerContentProvider.this.fViewer.testFindItem(element) == null) {
                    PackageExplorerContentProvider.this.fViewer.add(parent, element);
                }
            }
        });
    }

    protected void postRemove(final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackageExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    PackageExplorerContentProvider.this.fViewer.remove(element);
                }
            }
        });
    }

    protected void postProjectStateChanged(final Object root) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackageExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    PackageExplorerContentProvider.this.fViewer.refresh(root, true);
                    PackageExplorerContentProvider.this.fViewer.setSelection(PackageExplorerContentProvider.this.fViewer.getSelection());
                }
            }
        });
    }

    void postRunnable(final Runnable r) {
        Control ctrl = this.fViewer.getControl();
        Runnable trackedRunnable = new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    r.run();
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    PackageExplorerContentProvider.this.removePendingChange();
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                    PackageExplorerContentProvider.this.removePendingChange();
                    return;
                }
            }
        };
        if (ctrl != null && !ctrl.isDisposed()) {
            this.addPendingChange();
            try {
                ctrl.getDisplay().asyncExec(trackedRunnable);
            }
            catch (RuntimeException e) {
                this.removePendingChange();
                throw e;
            }
            catch (Error e) {
                this.removePendingChange();
                throw e;
            }
        }
    }

    public synchronized boolean hasPendingChanges() {
        return this.fPendingChanges > 0;
    }

    private synchronized void addPendingChange() {
        ++this.fPendingChanges;
    }

    synchronized void removePendingChange() {
        --this.fPendingChanges;
        if (this.fPendingChanges < 0) {
            this.fPendingChanges = 0;
        }
    }
}

