/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.util.Assert;

public final class SerialVersionLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private static final String[] fgExecutableLocations = new String[]{"bin" + File.separatorChar + "javaw", "bin" + File.separatorChar + "javaw.exe", "jre" + File.separatorChar + "bin" + File.separatorChar + "javaw", "jre" + File.separatorChar + "bin" + File.separatorChar + "javaw.exe", "bin" + File.separatorChar + "java", "bin" + File.separatorChar + "java.exe", "jre" + File.separatorChar + "bin" + File.separatorChar + "java", "jre" + File.separatorChar + "bin" + File.separatorChar + "java.exe"};
    private String fErrorMessage = null;
    private long[] fSerialVersionID = new long[0];

    private static File findJavaExecutable(File location) {
        Assert.isNotNull((Object)location);
        File file = null;
        int index = 0;
        while (index < fgExecutableLocations.length) {
            file = new File(location, fgExecutableLocations[index]);
            if (file.isFile()) {
                return file;
            }
            ++index;
        }
        return null;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public long[] getSerialVersionIDs() {
        return this.fSerialVersionID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block7: {
            block8: {
                block6: {
                    block5: {
                        Assert.isNotNull((Object)configuration);
                        Assert.isNotNull((Object)monitor);
                        try {
                            monitor.beginTask(MessageFormat.format("{0}...", configuration.getName()), 100);
                            if (monitor.isCanceled()) {
                                Object var15_5 = null;
                                break block5;
                            }
                            monitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_verifying_launch_attributes);
                            String type = this.verifyMainTypeName(configuration);
                            IVMInstall install = this.verifyVMInstall(configuration);
                            SerialVersionRunner runner = new SerialVersionRunner(install);
                            monitor.worked(10);
                            monitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_setting_up);
                            String[] environment = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
                            String programArguments = this.getProgramArguments(configuration);
                            String vmArguments = this.getVMArguments(configuration);
                            ExecutionArguments execArguments = new ExecutionArguments(vmArguments, programArguments);
                            Map attributes = this.getVMSpecificAttributesMap(configuration);
                            String[] classpath = this.getClasspath(configuration);
                            monitor.worked(5);
                            VMRunnerConfiguration vmConfiguration = new VMRunnerConfiguration(type, classpath);
                            vmConfiguration.setProgramArguments(execArguments.getProgramArgumentsArray());
                            vmConfiguration.setEnvironment(environment);
                            vmConfiguration.setVMArguments(execArguments.getVMArgumentsArray());
                            vmConfiguration.setVMSpecificAttributesMap(attributes);
                            vmConfiguration.setBootClassPath(this.getBootpath(configuration));
                            if (monitor.isCanceled()) {
                                break block6;
                            }
                            monitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_launching_computation);
                            monitor.worked(5);
                            runner.run(vmConfiguration, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                            if (!monitor.isCanceled()) break block7;
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var15_8 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return;
                }
                Object var15_6 = null;
                monitor.done();
                return;
            }
            Object var15_7 = null;
            monitor.done();
            return;
        }
        Object var15_9 = null;
        monitor.done();
    }

    final class SerialVersionRunner
    extends AbstractVMRunner {
        private static final String TEMP_FILE_ENCODING = "utf-8";
        private static final String TEMP_FILE_NAME = "serials.tmp";
        private final IVMInstall fInstall;

        SerialVersionRunner(IVMInstall install) {
            Assert.isNotNull((Object)install);
            this.fInstall = install;
        }

        private String flattenClassPath(String[] path) {
            Assert.isNotNull((Object)path);
            int count = 0;
            if (path.length == 0) {
                return "";
            }
            StringBuffer buffer = new StringBuffer();
            int index = 0;
            while (index < path.length) {
                if (count > 0) {
                    buffer.append(File.pathSeparator);
                }
                buffer.append(path[index]);
                ++count;
                ++index;
            }
            return buffer.toString();
        }

        private String getJavaExecutable(VMRunnerConfiguration configuration) throws CoreException {
            Assert.isNotNull((Object)configuration);
            String command = null;
            Map map = configuration.getVMSpecificAttributesMap();
            if (map != null) {
                command = (String)map.get(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND);
            }
            if (command == null) {
                File executable = SerialVersionLaunchConfigurationDelegate.findJavaExecutable(this.fInstall.getInstallLocation());
                if (executable == null) {
                    this.abort(Messages.format(CorrectionMessages.SerialVersionHashProposal_unable_locate_executable, new String[]{this.fInstall.getName()}), null, 150);
                }
                return executable.getAbsolutePath();
            }
            String location = String.valueOf(this.fInstall.getInstallLocation().getAbsolutePath()) + File.separatorChar;
            File executable = new File(String.valueOf(location) + "bin" + File.separatorChar + command);
            if (executable.exists() && executable.isFile()) {
                return executable.getAbsolutePath();
            }
            if ((executable = new File(String.valueOf(executable.getAbsolutePath()) + ".exe")).exists() && executable.isFile()) {
                return executable.getAbsolutePath();
            }
            executable = new File(String.valueOf(location) + "jre" + File.separatorChar + "bin" + File.separatorChar + command);
            if (executable.exists() && executable.isFile()) {
                return executable.getAbsolutePath();
            }
            if ((executable = new File(String.valueOf(executable.getAbsolutePath()) + ".exe")).exists() && executable.isFile()) {
                return executable.getAbsolutePath();
            }
            this.abort(Messages.format(CorrectionMessages.SerialVersionHashProposal_wrong_executable, new String[]{command, this.fInstall.getName()}), null, 150);
            return null;
        }

        protected String getPluginIdentifier() {
            return JavaPlugin.getPluginId();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(VMRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
            block32: {
                block31: {
                    block30: {
                        Assert.isNotNull((Object)configuration);
                        Assert.isNotNull((Object)launch);
                        Assert.isNotNull((Object)monitor);
                        monitor.beginTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_launching_vm, 40);
                        try {
                            Process process;
                            block37: {
                                block34: {
                                    block35: {
                                        block36: {
                                            ArrayList<String> lines;
                                            block33: {
                                                String[] commandLine;
                                                String[] combinedClassPath;
                                                String[] classPath;
                                                String[] bootClassPath;
                                                ArrayList<String> arguments;
                                                block29: {
                                                    int index;
                                                    LibraryLocation[] locations;
                                                    monitor.worked(10);
                                                    monitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_constructing_command_line);
                                                    arguments = new ArrayList<String>();
                                                    arguments.add(this.getJavaExecutable(configuration));
                                                    String[] vmArguments = this.combineVmArgs(configuration, this.fInstall);
                                                    int index2 = 0;
                                                    while (true) {
                                                        if (index2 >= vmArguments.length) {
                                                            bootClassPath = configuration.getBootClassPath();
                                                            classPath = configuration.getClassPath();
                                                            combinedClassPath = null;
                                                            locations = null;
                                                            if (bootClassPath == null) {
                                                                locations = JavaRuntime.getLibraryLocations((IVMInstall)this.fInstall);
                                                                bootClassPath = new String[locations.length];
                                                                index = 0;
                                                                break;
                                                            }
                                                            break block29;
                                                        }
                                                        arguments.add(vmArguments[index2]);
                                                        ++index2;
                                                    }
                                                    while (index < locations.length) {
                                                        bootClassPath[index] = locations[index].getSystemLibraryPath().toOSString();
                                                        ++index;
                                                    }
                                                }
                                                if (monitor.isCanceled()) {
                                                    Object var22_12 = null;
                                                    break block30;
                                                }
                                                combinedClassPath = new String[bootClassPath.length + classPath.length];
                                                int offset = 0;
                                                int index = 0;
                                                while (true) {
                                                    if (index >= bootClassPath.length) break;
                                                    combinedClassPath[offset] = bootClassPath[index];
                                                    ++offset;
                                                    ++index;
                                                }
                                                index = 0;
                                                while (true) {
                                                    if (index >= classPath.length) {
                                                        if (combinedClassPath.length > 0) {
                                                            arguments.add("-classpath");
                                                            arguments.add(this.flattenClassPath(combinedClassPath));
                                                        }
                                                        break;
                                                    }
                                                    combinedClassPath[offset] = classPath[index];
                                                    ++offset;
                                                    ++index;
                                                }
                                                arguments.add(configuration.getClassToLaunch());
                                                String[] programArguments = configuration.getProgramArguments();
                                                int index3 = 0;
                                                while (true) {
                                                    if (index3 >= programArguments.length) {
                                                        commandLine = new String[arguments.size()];
                                                        arguments.toArray(commandLine);
                                                        if (!monitor.isCanceled()) break;
                                                        break block31;
                                                    }
                                                    arguments.add(programArguments[index3]);
                                                    ++index3;
                                                }
                                                monitor.worked(10);
                                                monitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_starting_vm);
                                                process = this.exec(commandLine, null);
                                                if (process == null) break block32;
                                                try {
                                                    process.waitFor();
                                                }
                                                catch (InterruptedException interruptedException) {}
                                                monitor.worked(10);
                                                String directory = System.getProperty("java.io.tmpdir");
                                                if (directory == null || "".equals(directory)) break block34;
                                                String separator = System.getProperty("file.separator");
                                                if (separator == null || "".equals(separator)) break block35;
                                                File file = new File(String.valueOf(directory) + separator + TEMP_FILE_NAME);
                                                if (!file.exists()) break block36;
                                                monitor.worked(40);
                                                file.deleteOnExit();
                                                BufferedReader reader = null;
                                                lines = new ArrayList<String>();
                                                try {
                                                    try {
                                                        reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), TEMP_FILE_ENCODING));
                                                        while (reader.ready()) {
                                                            String line = reader.readLine();
                                                            if (line == null || "".equals(line)) continue;
                                                            lines.add(line);
                                                        }
                                                    }
                                                    catch (IOException exception) {
                                                        SerialVersionLaunchConfigurationDelegate.this.fErrorMessage = exception.getLocalizedMessage();
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    Object var20_30 = null;
                                                    if (reader == null) throw throwable;
                                                    try {
                                                        reader.close();
                                                        throw throwable;
                                                    }
                                                    catch (IOException iOException) {}
                                                    throw throwable;
                                                }
                                                {
                                                    Object var20_31 = null;
                                                    if (reader == null) break block33;
                                                }
                                                try {}
                                                catch (IOException iOException) {}
                                                reader.close();
                                            }
                                            SerialVersionLaunchConfigurationDelegate.this.fSerialVersionID = new long[lines.size()];
                                            int index = 0;
                                            while (index < SerialVersionLaunchConfigurationDelegate.this.fSerialVersionID.length) {
                                                String line = (String)lines.get(index);
                                                try {
                                                    ((SerialVersionLaunchConfigurationDelegate)SerialVersionLaunchConfigurationDelegate.this).fSerialVersionID[index] = Long.parseLong(line);
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    ((SerialVersionLaunchConfigurationDelegate)SerialVersionLaunchConfigurationDelegate.this).fSerialVersionID[index] = 1L;
                                                    SerialVersionLaunchConfigurationDelegate.this.fErrorMessage = line;
                                                }
                                                ++index;
                                            }
                                            break block37;
                                        }
                                        SerialVersionLaunchConfigurationDelegate.this.fErrorMessage = CorrectionMessages.SerialVersionLaunchConfigurationDelegate_temp_file_not_exists;
                                        break block37;
                                    }
                                    SerialVersionLaunchConfigurationDelegate.this.fErrorMessage = CorrectionMessages.SerialVersionLaunchConfigurationDelegate_error_getting_separator_property;
                                    break block37;
                                }
                                SerialVersionLaunchConfigurationDelegate.this.fErrorMessage = CorrectionMessages.SerialVersionLaunchConfigurationDelegate_error_getting_temp_dir_property;
                            }
                            if (monitor.isCanceled()) {
                                process.destroy();
                            }
                            break block32;
                        }
                        catch (Throwable throwable) {
                            Object var22_14 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return;
                }
                Object var22_13 = null;
                monitor.done();
                return;
            }
            Object var22_15 = null;
            monitor.done();
        }
    }
}

