/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerDescriptor;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public final class CompletionProposalComputerRegistry {
    private static final String EXTENSION_POINT = "javaCompletionProposalComputer";
    private static CompletionProposalComputerRegistry fgSingleton = null;
    private final Map fDescriptorsByPartition = new HashMap();
    private final Map fPublicDescriptorsByPartition = new HashMap();
    private final List fDescriptors = new ArrayList();
    private final List fPublicDescriptors = Collections.unmodifiableList(this.fDescriptors);
    private final List fCategories = new ArrayList();
    private final List fPublicCategories = Collections.unmodifiableList(this.fCategories);
    private boolean fLoaded = false;

    public static synchronized CompletionProposalComputerRegistry getDefault() {
        if (fgSingleton == null) {
            fgSingleton = new CompletionProposalComputerRegistry();
        }
        return fgSingleton;
    }

    List getProposalComputerDescriptors(String partition) {
        this.ensureExtensionPointRead();
        List result = (List)this.fPublicDescriptorsByPartition.get(partition);
        return result != null ? result : Collections.EMPTY_LIST;
    }

    List getProposalComputerDescriptors() {
        this.ensureExtensionPointRead();
        return this.fPublicDescriptors;
    }

    public List getProposalCategories() {
        this.ensureExtensionPointRead();
        return this.fPublicCategories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureExtensionPointRead() {
        boolean reload;
        CompletionProposalComputerRegistry completionProposalComputerRegistry = this;
        synchronized (completionProposalComputerRegistry) {
            reload = !this.fLoaded;
            this.fLoaded = true;
        }
        if (reload) {
            this.reload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>(Arrays.asList(registry.getConfigurationElementsFor(JavaPlugin.getPluginId(), EXTENSION_POINT)));
        HashMap<String, ArrayList<CompletionProposalComputerDescriptor>> map = new HashMap<String, ArrayList<CompletionProposalComputerDescriptor>>();
        ArrayList<CompletionProposalComputerDescriptor> all = new ArrayList<CompletionProposalComputerDescriptor>();
        List categories = this.getCategories(elements);
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)iter.next();
            try {
                CompletionProposalComputerDescriptor desc = new CompletionProposalComputerDescriptor(element, this, categories);
                Set partitions = desc.getPartitions();
                Iterator it = partitions.iterator();
                while (it.hasNext()) {
                    String partition = (String)it.next();
                    ArrayList<CompletionProposalComputerDescriptor> list = (ArrayList<CompletionProposalComputerDescriptor>)map.get(partition);
                    if (list == null) {
                        list = new ArrayList<CompletionProposalComputerDescriptor>();
                        map.put(partition, list);
                    }
                    list.add(desc);
                }
                all.add(desc);
            }
            catch (InvalidRegistryObjectException x) {
                Object[] args = new Object[]{element.toString()};
                String message = MessageFormat.format(JavaTextMessages.CompletionProposalComputerRegistry_invalid_message, args);
                Status status = new Status(2, JavaPlugin.getPluginId(), 0, message, (Throwable)x);
                this.informUser((IStatus)status);
            }
        }
        CompletionProposalComputerRegistry completionProposalComputerRegistry = this;
        synchronized (completionProposalComputerRegistry) {
            this.fCategories.clear();
            this.fCategories.addAll(categories);
            Set partitions = map.keySet();
            this.fDescriptorsByPartition.keySet().retainAll(partitions);
            this.fPublicDescriptorsByPartition.keySet().retainAll(partitions);
            Iterator it = partitions.iterator();
            while (it.hasNext()) {
                String partition = (String)it.next();
                List old = (List)this.fDescriptorsByPartition.get(partition);
                List current = (List)map.get(partition);
                if (old != null) {
                    old.clear();
                    old.addAll(current);
                    continue;
                }
                this.fDescriptorsByPartition.put(partition, current);
                this.fPublicDescriptorsByPartition.put(partition, Collections.unmodifiableList(current));
            }
            this.fDescriptors.clear();
            this.fDescriptors.addAll(all);
        }
    }

    private List getCategories(List elements) {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        String preference = store.getString("content_assist_disabled_computers");
        HashSet<String> disabled = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(preference, "\u0000");
        while (tok.hasMoreTokens()) {
            disabled.add(tok.nextToken());
        }
        HashMap<String, Integer> ordered = new HashMap<String, Integer>();
        preference = store.getString("content_assist_category_order");
        tok = new StringTokenizer(preference, "\u0000");
        while (tok.hasMoreTokens()) {
            StringTokenizer inner = new StringTokenizer(tok.nextToken(), ":");
            String id = inner.nextToken();
            int rank = Integer.parseInt(inner.nextToken());
            ordered.put(id, new Integer(rank));
        }
        ArrayList<CompletionProposalCategory> categories = new ArrayList<CompletionProposalCategory>();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)iter.next();
            try {
                if (!element.getName().equals("proposalCategory")) continue;
                iter.remove();
                CompletionProposalCategory category = new CompletionProposalCategory(element, this);
                categories.add(category);
                category.setIncluded(!disabled.contains(category.getId()));
                Integer rank = (Integer)ordered.get(category.getId());
                if (rank == null) continue;
                int r = rank;
                boolean separate = r < 65535;
                category.setSeparateCommand(separate);
                category.setSortOrder(r);
            }
            catch (InvalidRegistryObjectException x) {
                Object[] args = new Object[]{element.toString()};
                String message = MessageFormat.format(JavaTextMessages.CompletionProposalComputerRegistry_invalid_message, args);
                Status status = new Status(2, JavaPlugin.getPluginId(), 0, message, (Throwable)x);
                this.informUser((IStatus)status);
            }
        }
        return categories;
    }

    void remove(CompletionProposalComputerDescriptor descriptor, IStatus status) {
        Set partitions = descriptor.getPartitions();
        Iterator it = partitions.iterator();
        while (it.hasNext()) {
            String partition = (String)it.next();
            List descriptors = (List)this.fDescriptorsByPartition.get(partition);
            if (descriptors == null) continue;
            descriptors.remove(descriptor);
        }
        this.informUser(status);
    }

    private void informUser(IStatus status) {
        JavaPlugin.log(status);
        String title = JavaTextMessages.CompletionProposalComputerRegistry_error_dialog_title;
        String message = status.getMessage();
        MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
    }
}

