/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.text.MessageFormat;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class WordIgnoreProposal
implements IJavaCompletionProposal {
    private IInvocationContext fContext;
    private String fWord;

    public WordIgnoreProposal(String word, IInvocationContext context) {
        this.fWord = word;
        this.fContext = context;
    }

    public final void apply(IDocument document) {
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.createSpellChecker(engine.getLocale(), PreferenceConstants.getPreferenceStore());
        if (checker != null) {
            checker.ignoreWord(this.fWord);
        }
    }

    public String getAdditionalProposalInfo() {
        return MessageFormat.format(JavaUIMessages.Spelling_ignore_info, WordCorrectionProposal.getHtmlRepresentation(this.fWord));
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return MessageFormat.format(JavaUIMessages.Spelling_ignore_label, this.fWord);
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.jdt.ui.never_translate.gif");
    }

    public final int getRelevance() {
        return -2147483647;
    }

    public final Point getSelection(IDocument document) {
        return new Point(this.fContext.getSelectionOffset(), this.fContext.getSelectionLength());
    }
}

