/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.List;
import org.eclipse.jdt.internal.ui.viewsupport.HistoryListAction;
import org.eclipse.jdt.internal.ui.viewsupport.ViewHistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

class HistoryDropDownAction
extends Action {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private ViewHistory fHistory;
    private Menu fMenu;

    public HistoryDropDownAction(ViewHistory history) {
        this.fHistory = history;
        this.fMenu = null;
        this.setMenuCreator(new HistoryMenuCreator());
        this.fHistory.configureHistoryDropDownAction((IAction)this);
    }

    public void run() {
        new HistoryListAction(this.fHistory).run();
    }

    private class HistoryAction
    extends Action {
        private final Object fElement;

        public HistoryAction(Object element, int accelerator) {
            Assert.isNotNull((Object)element);
            this.fElement = element;
            String label = HistoryDropDownAction.this.fHistory.getText(element);
            if (accelerator < 10) {
                label = "" + '&' + accelerator + ' ' + label;
            }
            this.setText(label);
            this.setImageDescriptor(HistoryDropDownAction.this.fHistory.getImageDescriptor(element));
        }

        public void run() {
            HistoryDropDownAction.this.fHistory.setActiveEntry(this.fElement);
        }
    }

    private class HistoryMenuCreator
    implements IMenuCreator {
        HistoryMenuCreator() {
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            Action clearAction;
            if (HistoryDropDownAction.this.fMenu != null) {
                HistoryDropDownAction.this.fMenu.dispose();
            }
            HistoryDropDownAction.this.fMenu = new Menu(parent);
            List entries = HistoryDropDownAction.this.fHistory.getHistoryEntries();
            boolean checkOthers = this.addEntryMenuItems(entries);
            if (entries.size() > 0) {
                new MenuItem(HistoryDropDownAction.this.fMenu, 2);
            }
            if ((clearAction = HistoryDropDownAction.this.fHistory.getClearAction()) != null) {
                this.addActionToMenu(HistoryDropDownAction.this.fMenu, clearAction);
            }
            HistoryListAction others = new HistoryListAction(HistoryDropDownAction.this.fHistory);
            others.setChecked(checkOthers);
            this.addActionToMenu(HistoryDropDownAction.this.fMenu, others);
            return HistoryDropDownAction.this.fMenu;
        }

        private boolean addEntryMenuItems(List entries) {
            if (entries.isEmpty()) {
                return false;
            }
            boolean checkOthers = true;
            int min = Math.min(entries.size(), 10);
            int i = 0;
            while (i < min) {
                Object entry = entries.get(i);
                HistoryAction action = new HistoryAction(entry, i + 1);
                boolean check = entry.equals(HistoryDropDownAction.this.fHistory.getCurrentEntry());
                action.setChecked(check);
                if (check) {
                    checkOthers = false;
                }
                this.addActionToMenu(HistoryDropDownAction.this.fMenu, action);
                ++i;
            }
            return checkOthers;
        }

        private void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }

        public void dispose() {
            HistoryDropDownAction.this.fHistory = null;
            if (HistoryDropDownAction.this.fMenu != null) {
                HistoryDropDownAction.this.fMenu.dispose();
                HistoryDropDownAction.this.fMenu = null;
            }
        }
    }
}

