/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.AddSourceFolderWizardPage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathWizard;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SetFilterWizardPage;
import org.eclipse.jface.wizard.IWizardPage;

public class AddSourceFolderWizard
extends BuildPathWizard {
    private AddSourceFolderWizardPage fAddFolderPage;
    private SetFilterWizardPage fFilterPage;
    private final boolean fLinkedMode;

    public AddSourceFolderWizard(CPListElement[] existingEntries, CPListElement newEntry, IPath outputLocation, boolean linkedMode) {
        super(existingEntries, newEntry, outputLocation, AddSourceFolderWizard.getTitel(newEntry, linkedMode), JavaPluginImages.DESC_WIZBAN_NEWSRCFOLDR);
        this.fLinkedMode = linkedMode;
    }

    private static String getTitel(CPListElement newEntry, boolean linkedMode) {
        if (newEntry.getPath() == null) {
            if (linkedMode) {
                return NewWizardMessages.NewSourceFolderCreationWizard_link_title;
            }
            return NewWizardMessages.NewSourceFolderCreationWizard_title;
        }
        return NewWizardMessages.NewSourceFolderCreationWizard_edit_title;
    }

    public void addPages() {
        super.addPages();
        this.fAddFolderPage = new AddSourceFolderWizardPage(this.getEntryToEdit(), this.getExistingEntries(), this.getOutputLocation(), this.fLinkedMode);
        this.addPage((IWizardPage)this.fAddFolderPage);
        this.fFilterPage = new SetFilterWizardPage(this.getEntryToEdit(), this.getExistingEntries(), this.getOutputLocation());
        this.addPage((IWizardPage)this.fFilterPage);
    }

    public List getInsertedElements() {
        List result = super.getInsertedElements();
        if (this.getEntryToEdit().getOrginalPath() == null) {
            result.add(this.getEntryToEdit());
        }
        return result;
    }

    public List getRemovedElements() {
        return this.fAddFolderPage.getRemovedElements();
    }

    public List getModifiedElements() {
        return this.fAddFolderPage.getModifiedElements();
    }

    public boolean performFinish() {
        this.getEntryToEdit().setAttribute("inclusion", this.fFilterPage.getInclusionPattern());
        this.getEntryToEdit().setAttribute("exclusion", this.fFilterPage.getExclusionPattern());
        this.setOutputLocation(this.fAddFolderPage.getOutputLocation());
        boolean res = super.performFinish();
        if (res) {
            this.selectAndReveal(this.fAddFolderPage.getCorrespondingResource());
        }
        return res;
    }
}

