/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import org.eclipse.jdt.internal.ui.workingsets.IWorkingSetActionGroup;
import org.eclipse.jdt.internal.ui.workingsets.ViewAction;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetShowActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionGroup;

public class ViewActionGroup
extends ActionGroup {
    public static final int SHOW_PROJECTS = 1;
    public static final int SHOW_WORKING_SETS = 2;
    public static final String MODE_CHANGED;
    private static final Integer INT_SHOW_PROJECTS;
    private static final Integer INT_SHOW_WORKING_SETS;
    private IPropertyChangeListener fChangeListener;
    private int fMode;
    private IMenuManager fMenuManager;
    private IWorkingSetActionGroup fActiveActionGroup;
    private WorkingSetShowActionGroup fShowActionGroup;
    private WorkingSetFilterActionGroup fFilterActionGroup;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.internal.ui.workingsets.ViewActionGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MODE_CHANGED = String.valueOf(clazz.getName()) + ".mode_changed";
        INT_SHOW_PROJECTS = new Integer(1);
        INT_SHOW_WORKING_SETS = new Integer(2);
    }

    public ViewActionGroup(int mode, IPropertyChangeListener changeListener, IWorkbenchPartSite site) {
        this.fChangeListener = changeListener;
        if (this.fChangeListener == null) {
            this.fChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                }
            };
        }
        this.fFilterActionGroup = new WorkingSetFilterActionGroup(site, this.fChangeListener);
        this.fShowActionGroup = new WorkingSetShowActionGroup(site);
        this.fMode = mode;
        this.fActiveActionGroup = this.showWorkingSets() ? this.fShowActionGroup : this.fFilterActionGroup;
    }

    public void dispose() {
        this.fFilterActionGroup.dispose();
        this.fShowActionGroup.dispose();
        this.fChangeListener = null;
        super.dispose();
    }

    public void setWorkingSetModel(WorkingSetModel model) {
        this.fShowActionGroup.setWorkingSetMode(model);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (this.fMenuManager == null) {
            this.fMenuManager = actionBars.getMenuManager();
            this.fillViewMenu(this.fMenuManager);
        }
        if (this.fActiveActionGroup == null) {
            this.fActiveActionGroup = this.fFilterActionGroup;
        }
        ((ActionGroup)this.fActiveActionGroup).fillActionBars(actionBars);
    }

    private void fillViewMenu(IMenuManager menu) {
        MenuManager showMenu = new MenuManager(WorkingSetMessages.ViewActionGroup_show_label);
        this.fillShowMenu((IMenuManager)showMenu);
        menu.add((IContributionItem)showMenu);
        menu.add((IContributionItem)new Separator("working_set_action_group"));
    }

    private void fillShowMenu(IMenuManager menu) {
        ViewAction projects = new ViewAction(this, 1);
        projects.setText(WorkingSetMessages.ViewActionGroup_projects_label);
        menu.add((IAction)projects);
        ViewAction workingSets = new ViewAction(this, 2);
        workingSets.setText(WorkingSetMessages.ViewActionGroup_workingSets_label);
        menu.add((IAction)workingSets);
        if (this.fMode == 1) {
            projects.setChecked(true);
        } else {
            workingSets.setChecked(true);
        }
    }

    public void fillFilters(StructuredViewer viewer) {
        ViewerFilter workingSetFilter = this.fFilterActionGroup.getWorkingSetFilter();
        if (this.showProjects()) {
            viewer.addFilter(workingSetFilter);
        } else if (this.showWorkingSets()) {
            viewer.removeFilter(workingSetFilter);
        }
    }

    public void setMode(int mode) {
        PropertyChangeEvent event;
        this.fMode = mode;
        this.fActiveActionGroup.cleanViewMenu(this.fMenuManager);
        if (mode == 1) {
            this.fActiveActionGroup = this.fFilterActionGroup;
            event = new PropertyChangeEvent((Object)this, MODE_CHANGED, (Object)INT_SHOW_WORKING_SETS, (Object)INT_SHOW_PROJECTS);
        } else {
            this.fActiveActionGroup = this.fShowActionGroup;
            event = new PropertyChangeEvent((Object)this, MODE_CHANGED, (Object)INT_SHOW_PROJECTS, (Object)INT_SHOW_WORKING_SETS);
        }
        this.fActiveActionGroup.fillViewMenu(this.fMenuManager);
        this.fMenuManager.updateAll(true);
        if (this.fChangeListener != null) {
            this.fChangeListener.propertyChange(event);
        }
    }

    public WorkingSetFilterActionGroup getFilterGroup() {
        return this.fFilterActionGroup;
    }

    public void restoreState(IMemento memento) {
        this.fFilterActionGroup.restoreState(memento);
    }

    public void saveState(IMemento memento) {
        this.fFilterActionGroup.saveState(memento);
    }

    private boolean showProjects() {
        return this.fMode == 1;
    }

    private boolean showWorkingSets() {
        return this.fMode == 2;
    }
}

