/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.variables;

import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValueModification;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.VariableValueEditorManager;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class AssignValueAction
extends SelectionProviderAction {
    private VariablesView variablesView;
    private ISourceViewer detailsViewer;

    public AssignValueAction(VariablesView varView, ISourceViewer detailViewer) {
        super((ISelectionProvider)varView.getViewer(), ActionMessages.AssignValueAction_1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IDebugHelpContextIds.ASSIGN_VALUE_ACTION);
        this.variablesView = varView;
        this.detailsViewer = detailViewer;
        this.setEnabled(false);
        this.variablesView.getSite().getKeyBindingService().registerAction((IAction)this);
    }

    public void selectionChanged(IStructuredSelection selection) {
        IValueModification valMod;
        boolean enabled = false;
        if (selection.size() == 1 && selection.getFirstElement() instanceof IValueModification && (valMod = (IValueModification)selection.getFirstElement()).supportsValueModification()) {
            super.selectionChanged(selection);
            enabled = true;
        }
        this.setEnabled(enabled);
    }

    public void run() {
        IVariable variable = (IVariable)this.getStructuredSelection().getFirstElement();
        Point selection = this.detailsViewer.getSelectedRange();
        String value = null;
        if (selection.y == 0) {
            value = this.detailsViewer.getDocument().get();
        } else {
            try {
                value = this.detailsViewer.getDocument().get(selection.x, selection.y);
            }
            catch (BadLocationException badLocationException) {}
        }
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        Shell activeShell = null;
        if (window != null) {
            activeShell = window.getShell();
        }
        String modelIdentifier = variable.getModelIdentifier();
        IVariableValueEditor editor = VariableValueEditorManager.getDefault().getVariableValueEditor(modelIdentifier);
        if (editor != null && editor.saveVariable(variable, value, activeShell)) {
            return;
        }
        try {
            if (variable.verifyValue(value)) {
                variable.setValue(value);
            } else if (activeShell != null) {
                DebugUIPlugin.errorDialog(activeShell, ActionMessages.AssignValueAction_2, MessageFormat.format(ActionMessages.AssignValueAction_3, value, variable.getName()), new StatusInfo(4, ActionMessages.AssignValueAction_4));
            }
        }
        catch (DebugException debugException) {
            MessageDialog.openError((Shell)activeShell, (String)ActionMessages.AssignValueAction_0, (String)ActionMessages.AssignValueAction_5);
        }
    }

    public String getActionDefinitionId() {
        return "org.eclipse.ui.file.save";
    }
}

