/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProcessPropertyPage
extends PropertyPage {
    protected Control createContents(Composite ancestor) {
        Font font = ancestor.getFont();
        this.noDefaultAndApplyButton();
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        IProcess proc = this.getProcess();
        GridData gd = new GridData(768);
        Label lbl = new Label(parent, 0);
        lbl.setText(DebugPreferencesMessages.ProcessPropertyPage_0);
        lbl.setLayoutData((Object)gd);
        lbl.setFont(font);
        Text text = new Text(parent, 8);
        text.setText(this.getTimeText(proc));
        text.setFont(font);
        gd = new GridData(768);
        gd.horizontalIndent = 10;
        text.setLayoutData((Object)gd);
        this.createVerticalSpacer(parent, 2);
        gd = new GridData(768);
        lbl = new Label(parent, 0);
        lbl.setText(DebugPreferencesMessages.ProcessPropertyPage_1);
        lbl.setFont(font);
        lbl.setLayoutData((Object)gd);
        text = new Text(parent, 72);
        text.setText(this.getPathText(proc));
        text.setFont(font);
        gd = new GridData(768);
        gd.horizontalIndent = 10;
        text.setLayoutData((Object)gd);
        this.createVerticalSpacer(parent, 2);
        gd = new GridData(768);
        lbl = new Label(parent, 0);
        lbl.setText(DebugPreferencesMessages.ProcessPropertyPage_Command_Line__1);
        lbl.setLayoutData((Object)gd);
        lbl.setFont(font);
        text = new Text(parent, 2632);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        gd.horizontalIndent = 10;
        text.setLayoutData((Object)gd);
        text.setFont(font);
        text.setText(this.getCommandLineText(proc));
        this.setTitle(DebugPreferencesMessages.ProcessPropertyPage_2);
        return parent;
    }

    private IProcess getProcess() {
        IProcess proc = null;
        IAdaptable obj = this.getElement();
        if (obj instanceof IDebugElement) {
            obj = ((IDebugElement)obj).getDebugTarget().getProcess();
        }
        if (obj instanceof IProcess) {
            proc = (IProcess)obj;
        }
        return proc;
    }

    private void createVerticalSpacer(Composite comp, int numlines) {
        Label lbl = new Label(comp, 0);
        GridData gd = new GridData(768);
        gd.heightHint = numlines;
        lbl.setLayoutData((Object)gd);
    }

    private String getPathText(IProcess proc) {
        String text = DebugPreferencesMessages.ProcessPropertyPage_3;
        if (proc != null) {
            String tmp = proc.getLabel();
            text = tmp.substring(0, tmp.lastIndexOf("("));
        }
        return text;
    }

    private String getTimeText(IProcess proc) {
        String text = DebugPreferencesMessages.ProcessPropertyPage_4;
        if (proc != null) {
            Pattern pattern = Pattern.compile("\\(.*\\)");
            Matcher matcher = pattern.matcher(proc.getLabel());
            matcher.find();
            text = matcher.group(0);
        }
        return text;
    }

    private String getCommandLineText(IProcess proc) {
        String cmdline = DebugPreferencesMessages.ProcessPropertyPage_5;
        if (proc != null) {
            cmdline = proc.getAttribute(IProcess.ATTR_CMDLINE);
        }
        return cmdline;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IDebugHelpContextIds.PROCESS_PROPERTY_PAGE);
    }
}

