/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.AbstractUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.TreeUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.provisional.IColumnPresenetationFactoryAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IColumnPresentation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.progress.WorkbenchJob;

public class AsynchronousTreeViewer
extends AsynchronousViewer
implements Listener {
    private Tree fTree;
    private List fPendingExpansion = new ArrayList();
    private IColumnPresentation fColumnPresentation = null;
    private Map fVisibleColumns = new HashMap();
    private Map fColumnSizes = new HashMap();
    private static final String COLUMN_SIZES = "COLUMN_SIZES";
    private static final String VISIBLE_COLUMNS = "VISIBLE_COLUMNS";
    private static final String SIZE = "SIZE";
    private static final String COLUMN = "COLUMN";
    static /* synthetic */ Class class$0;

    public AsynchronousTreeViewer(Composite parent) {
        this(parent, 268436226);
    }

    public AsynchronousTreeViewer(Composite parent, int style) {
        this(new Tree(parent, style));
    }

    public AsynchronousTreeViewer(Tree tree) {
        Assert.isTrue(((tree.getStyle() & 0x10000000) != 0 ? 1 : 0) != 0);
        this.fTree = tree;
        this.hookControl((Control)this.fTree);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Tree tree = (Tree)control;
        tree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                ((TreeItem)e.item).setExpanded(true);
                ModelNode node = AsynchronousTreeViewer.this.findNode(e.item);
                if (node != null) {
                    AsynchronousTreeViewer.this.internalRefresh(node);
                }
            }

            public void treeCollapsed(TreeEvent e) {
            }
        });
        tree.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem item = ((Tree)e.widget).getItem(new Point(e.x, e.y));
                if (item != null) {
                    if (item.getExpanded()) {
                        item.setExpanded(false);
                    } else {
                        item.setExpanded(true);
                        ModelNode node = AsynchronousTreeViewer.this.findNode((Widget)item);
                        if (node != null) {
                            AsynchronousTreeViewer.this.internalRefresh(node);
                        }
                    }
                }
            }
        });
    }

    public Tree getTree() {
        return this.fTree;
    }

    protected void updateHasChildren(ModelNode node) {
        ((AsynchronousTreeModel)this.getModel()).updateHasChildren(node);
    }

    public synchronized void expand(ISelection selection) {
        if (selection instanceof TreeSelection) {
            TreePath[] paths = ((TreeSelection)selection).getPaths();
            int i = 0;
            while (i < paths.length) {
                this.fPendingExpansion.add(paths[i]);
                ++i;
            }
            if (this.getControl().getDisplay().getThread() == Thread.currentThread()) {
                this.attemptExpansion();
            } else {
                WorkbenchJob job = new WorkbenchJob("attemptExpansion"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AsynchronousTreeViewer.this.attemptExpansion();
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    synchronized void attemptExpansion() {
        if (this.fPendingExpansion != null) {
            Iterator i = this.fPendingExpansion.iterator();
            while (i.hasNext()) {
                TreePath path = (TreePath)i.next();
                if (!this.attemptExpansion(path)) continue;
                i.remove();
            }
        }
    }

    synchronized boolean attemptExpansion(TreePath path) {
        int segmentCount = path.getSegmentCount();
        int j = segmentCount - 1;
        while (j >= 0) {
            Object element = path.getSegment(j);
            ModelNode[] nodes = this.getModel().getNodes(element);
            if (nodes != null) {
                int k = 0;
                while (k < nodes.length) {
                    ModelNode node = nodes[k];
                    TreePath treePath = node.getTreePath();
                    if (path.startsWith(treePath, null) && !node.isDisposed()) {
                        Widget widget = this.findItem(node);
                        if (widget == null) {
                            ModelNode parent = node.getParentNode();
                            ModelNode child = node;
                            widget = this.findItem(parent);
                            while (widget == null && parent != null) {
                                child = parent;
                                if ((parent = parent.getParentNode()) == null) continue;
                                widget = this.findItem(parent);
                                treePath = parent.getTreePath();
                            }
                            int childIndex = parent.getChildIndex(child);
                            if (childIndex < 0) {
                                return false;
                            }
                            TreeItem[] items = this.getItems(widget);
                            if (childIndex < items.length) {
                                widget = items[childIndex];
                                this.mapElement(child, widget);
                                widget.setData(child.getElement());
                                treePath = child.getTreePath();
                                node = child;
                            } else {
                                return false;
                            }
                        }
                        if (widget instanceof TreeItem) {
                            TreeItem treeItem = (TreeItem)widget;
                            if (treeItem.getExpanded()) {
                                return path.getSegmentCount() == treePath.getSegmentCount();
                            }
                            if (treeItem.getItemCount() > 0) {
                                this.updateChildren(node);
                                this.expand(treeItem);
                                return path.getSegmentCount() == treePath.getSegmentCount();
                            }
                        }
                    }
                    ++k;
                }
            }
            --j;
        }
        return false;
    }

    public Control getControl() {
        return this.fTree;
    }

    public synchronized void dispose() {
        if (this.fColumnPresentation != null) {
            this.buildColumns(null);
            this.fColumnPresentation.dispose();
        }
        super.dispose();
    }

    protected synchronized void inputChanged(Object input, Object oldInput) {
        this.fPendingExpansion.clear();
        super.inputChanged(input, oldInput);
        this.configureColumns(input);
    }

    public void refreshColumns() {
        PresentationContext context = (PresentationContext)this.getPresentationContext();
        if (this.fColumnPresentation != null) {
            this.buildColumns(this.fColumnPresentation);
            context.setColumns(this.getVisibleColumns());
        } else {
            context.setColumns(null);
        }
    }

    protected void configureColumns(Object input) {
        if (input != null) {
            IColumnPresenetationFactoryAdapter factory = this.getColumnPresenetationFactoryAdapter(input);
            PresentationContext context = (PresentationContext)this.getPresentationContext();
            String type = null;
            if (factory != null) {
                type = factory.getColumnPresentationId(context, input);
            }
            if (type != null) {
                IColumnPresentation presentation;
                if (this.fColumnPresentation != null) {
                    if (this.fColumnPresentation.getId().equals(type)) {
                        return;
                    }
                    this.fColumnPresentation.dispose();
                }
                if ((presentation = factory.createColumnPresentation(context, input)) != null) {
                    this.fColumnPresentation = presentation;
                    presentation.init(context);
                    this.buildColumns(presentation);
                }
            } else if (this.fColumnPresentation != null) {
                this.buildColumns(null);
                this.fColumnPresentation.dispose();
                this.fColumnPresentation = null;
            }
            context.setColumns(this.getVisibleColumns());
        }
    }

    protected void buildColumns(IColumnPresentation presentation) {
        this.persistColumnSizes();
        Tree tree = this.getTree();
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = columns[i];
            treeColumn.dispose();
            ++i;
        }
        if (presentation != null) {
            String[] columnIds = this.getVisibleColumns();
            int i2 = 0;
            while (i2 < columnIds.length) {
                String id = columnIds[i2];
                String header = presentation.getHeader(id);
                TreeColumn column = new TreeColumn(tree, 16384, i2);
                column.setMoveable(true);
                column.setText(header);
                ImageDescriptor image = presentation.getImageDescriptor(id);
                if (image != null) {
                    column.setImage(this.getImage(image));
                }
                column.setData((Object)id);
                ++i2;
            }
            tree.setHeaderVisible(true);
            tree.setLinesVisible(true);
        } else {
            tree.setHeaderVisible(false);
            tree.setLinesVisible(false);
        }
        columns = tree.getColumns();
        i = 0;
        while (i < columns.length) {
            Integer width = (Integer)this.fColumnSizes.get(columns[i].getData());
            if (width == null) {
                columns[i].pack();
            } else {
                columns[i].setWidth(width.intValue());
            }
            ++i;
        }
    }

    protected void persistColumnSizes() {
        Tree tree = this.getTree();
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = columns[i];
            Object id = treeColumn.getData();
            this.fColumnSizes.put(id, new Integer(treeColumn.getWidth()));
            ++i;
        }
    }

    protected IColumnPresenetationFactoryAdapter getColumnPresenetationFactoryAdapter(Object input) {
        if (input instanceof IColumnPresenetationFactoryAdapter) {
            return (IColumnPresenetationFactoryAdapter)input;
        }
        if (input instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)input;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IColumnPresenetationFactoryAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IColumnPresenetationFactoryAdapter)adaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    protected synchronized TreePath getTreePath(TreeItem item) {
        TreeItem parent = item;
        ArrayList<Object> path = new ArrayList<Object>();
        while (parent != null && !parent.isDisposed()) {
            Object parentElement = parent.getData();
            if (parentElement == null) {
                return new TreePath(new Object[0]);
            }
            path.add(0, parentElement);
            parent = parent.getParentItem();
        }
        path.add(0, this.fTree.getData());
        return new TreePath(path.toArray());
    }

    public TreePath[] getTreePaths(Object element) {
        ModelNode[] nodes = this.getModel().getNodes(element);
        if (nodes == null) {
            return new TreePath[0];
        }
        TreePath[] paths = new TreePath[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            paths[i] = nodes[i].getTreePath();
            ++i;
        }
        return paths;
    }

    protected void nodeContainerChanged(ModelNode node) {
        Widget widget = this.findItem(node);
        if (widget != null && !widget.isDisposed() && this.isVisible(widget)) {
            boolean expanded = true;
            if (node.isContainer() && this.getItemCount(widget) == 0) {
                this.setItemCount(widget, 1);
            }
            if (widget instanceof TreeItem) {
                expanded = ((TreeItem)widget).getExpanded();
            }
            if (expanded) {
                this.updateChildren(node);
            }
        }
        this.attemptPendingUpdates();
    }

    protected int getItemCount(Widget widget) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItemCount();
        }
        return ((Tree)widget).getItemCount();
    }

    protected void setItemCount(Widget widget, int itemCount) {
        if (widget == this.fTree) {
            this.fTree.setItemCount(itemCount);
        } else {
            ((TreeItem)widget).setItemCount(itemCount);
        }
    }

    protected Widget getChildWidget(Widget parent, int index) {
        TreeItem item;
        if (parent instanceof Tree) {
            Tree tree = (Tree)parent;
            if (index < tree.getItemCount()) {
                return tree.getItem(index);
            }
        } else if (parent instanceof TreeItem && index < (item = (TreeItem)parent).getItemCount()) {
            return item.getItem(index);
        }
        return null;
    }

    private TreeItem[] getItems(Widget widget) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItems();
        }
        return this.fTree.getItems();
    }

    protected Widget getParentWidget(Widget widget) {
        if (widget instanceof TreeItem) {
            TreeItem parentItem = ((TreeItem)widget).getParentItem();
            if (parentItem == null) {
                return this.getControl();
            }
            return parentItem;
        }
        return null;
    }

    protected int getChildIndex(Widget parent, Event event) {
        if (parent instanceof TreeItem) {
            return ((TreeItem)parent).indexOf((TreeItem)event.item);
        }
        if (parent instanceof Tree) {
            return ((Tree)parent).indexOf((TreeItem)event.item);
        }
        return -1;
    }

    private void expand(TreeItem child) {
        if (!child.getExpanded()) {
            child.setExpanded(true);
            TreeItem parent = child.getParentItem();
            if (parent != null) {
                this.expand(parent);
            }
        }
    }

    protected void clear(Widget widget) {
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            item.clearAll(true);
        } else {
            this.fTree.clearAll(true);
        }
    }

    protected boolean isVisible(Widget widget) {
        if (widget instanceof Tree) {
            return true;
        }
        TreeItem item = (TreeItem)widget;
        Rectangle itemBounds = item.getBounds();
        return !NOT_VISIBLE.equals((Object)itemBounds);
    }

    protected ISelection newSelectionFromWidget() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return StructuredSelection.EMPTY;
        }
        List list = this.getSelectionFromWidget();
        return new TreeSelection((TreePath[])list.toArray());
    }

    protected synchronized List getSelectionFromWidget() {
        TreeItem[] selection = this.fTree.getSelection();
        TreePath[] paths = new TreePath[selection.length];
        int i = 0;
        while (i < selection.length) {
            paths[i] = this.getTreePath(selection[i]);
            ++i;
        }
        return Arrays.asList(paths);
    }

    protected void internalRefresh(ModelNode node) {
        super.internalRefresh(node);
        this.updateHasChildren(node);
    }

    public void reveal(Object element) {
        ModelNode[] nodes = this.getModel().getNodes(element);
        if (nodes != null) {
            int i = 0;
            while (i < nodes.length) {
                ModelNode node = nodes[i];
                Widget widget = this.findItem(node);
                if (widget instanceof TreeItem) {
                    TreeItem item = (TreeItem)widget;
                    Tree tree = (Tree)this.getControl();
                    tree.showItem(item);
                    return;
                }
                ++i;
            }
        }
    }

    protected synchronized ISelection doAttemptSelectionToWidget(ISelection selection, boolean reveal) {
        ArrayList<TreePath> remaining = new ArrayList<TreePath>();
        if (!selection.isEmpty()) {
            ArrayList<Widget> toSelect = new ArrayList<Widget>();
            ArrayList<ModelNode> theNodes = new ArrayList<ModelNode>();
            ArrayList<Object> theElements = new ArrayList<Object>();
            TreeSelection treeSelection = (TreeSelection)selection;
            TreePath[] paths = treeSelection.getPaths();
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                if (path != null) {
                    ModelNode[] nodes = this.getModel().getNodes(path.getLastSegment());
                    boolean selected = false;
                    if (nodes != null) {
                        int j = 0;
                        while (j < nodes.length) {
                            Widget widget;
                            Widget widget2;
                            ModelNode node = nodes[j];
                            if (node.correspondsTo(path) && (widget2 = this.findItem(node)) != null && !widget2.isDisposed()) {
                                toSelect.add(widget2);
                                theNodes.add(node);
                                theElements.add(path.getLastSegment());
                                selected = true;
                                break;
                            }
                            ModelNode parent = node.getParentNode();
                            ModelNode child = node;
                            if (parent != null && (widget = this.findItem(parent)) != null && !widget.isDisposed()) {
                                TreeItem[] items;
                                int childIndex = parent.getChildIndex(child);
                                if (childIndex < 0 || childIndex >= (items = this.getItems(widget)).length) break;
                                widget = items[childIndex];
                                this.mapElement(child, widget);
                                widget.setData(child.getElement());
                                toSelect.add(widget);
                                theNodes.add(child);
                                theElements.add(child.getElement());
                                selected = true;
                            }
                            ++j;
                        }
                    }
                    if (!selected) {
                        remaining.add(path);
                    }
                }
                ++i;
            }
            if (!toSelect.isEmpty()) {
                TreeItem[] items = toSelect.toArray(new TreeItem[toSelect.size()]);
                int i2 = 0;
                while (i2 < items.length) {
                    TreeItem item = items[i2];
                    Object element = theElements.get(i2);
                    if (!item.isDisposed() && item.getData() != element) {
                        ModelNode theNode = (ModelNode)theNodes.get(i2);
                        Widget mapped = this.findItem(theNode);
                        if (mapped == null) {
                            return selection;
                        }
                        theNode.remap(element);
                        item.setData(element);
                    }
                    ++i2;
                }
                this.fTree.setSelection(items);
                if (reveal) {
                    this.fTree.showItem(items[0]);
                }
            }
        } else {
            this.fTree.setSelection(new TreeItem[0]);
        }
        return new TreeSelection(remaining.toArray(new TreePath[remaining.size()]));
    }

    public void collapseAll() {
        TreeItem[] items = this.fTree.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (item.getExpanded()) {
                this.collapse(item);
            }
            ++i;
        }
    }

    protected void collapse(TreeItem item) {
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem child = items[i];
            if (child.getExpanded()) {
                this.collapse(child);
            }
            ++i;
        }
        item.setExpanded(false);
    }

    protected void setColors(Widget widget, RGB[] foregrounds, RGB[] backgrounds) {
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            Color[] fgs = this.getColor(foregrounds);
            int i = 0;
            while (i < fgs.length) {
                item.setForeground(i, fgs[i]);
                ++i;
            }
            Color[] bgs = this.getColor(backgrounds);
            int i2 = 0;
            while (i2 < bgs.length) {
                item.setBackground(i2, bgs[i2]);
                ++i2;
            }
        }
    }

    protected void setFonts(Widget widget, FontData[] fontData) {
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            Font[] fonts = this.getFonts(fontData);
            int i = 0;
            while (i < fonts.length) {
                item.setFont(i, fonts[i]);
                ++i;
            }
        }
    }

    protected boolean acceptsSelection(ISelection selection) {
        return selection instanceof TreeSelection;
    }

    protected ISelection getEmptySelection() {
        return new TreeSelection(new TreePath[0]);
    }

    public void add(TreePath treePath) {
        ((AsynchronousTreeModel)this.getModel()).add(treePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TreePath treePath) {
        AsynchronousTreeViewer asynchronousTreeViewer = this;
        synchronized (asynchronousTreeViewer) {
            Iterator i = this.fPendingExpansion.iterator();
            while (i.hasNext()) {
                TreePath expansionPath = (TreePath)i.next();
                if (!expansionPath.startsWith(treePath, null)) continue;
                i.remove();
            }
        }
        ((AsynchronousTreeModel)this.getModel()).remove(treePath);
    }

    protected void setLabels(Widget widget, String[] text, ImageDescriptor[] image) {
        TreeItem item;
        if (widget instanceof TreeItem && !(item = (TreeItem)widget).isDisposed()) {
            item.setText(text);
            item.setImage(this.getImages(image));
        }
    }

    protected AsynchronousModel createModel() {
        return new AsynchronousTreeModel(this);
    }

    public void nodeChanged(ModelNode node) {
        Widget widget = this.findItem(node);
        if (widget != null && !widget.isDisposed()) {
            if (widget instanceof TreeItem && !this.isVisible(widget)) {
                this.clear(widget);
                return;
            }
            widget.setData(node.getElement());
            this.mapElement(node, widget);
            this.internalRefresh(node);
            this.attemptPendingUpdates();
        }
    }

    protected void attemptPendingUpdates() {
        this.attemptExpansion();
        super.attemptPendingUpdates();
    }

    public AbstractUpdatePolicy createUpdatePolicy() {
        return new TreeUpdatePolicy();
    }

    protected synchronized void unmapAllElements() {
        super.unmapAllElements();
        Tree tree = this.getTree();
        if (!tree.isDisposed()) {
            TreeItem[] items = tree.getItems();
            int i = 0;
            while (i < items.length) {
                items[i].dispose();
                ++i;
            }
            this.clear((Widget)tree);
        }
    }

    public IColumnPresentation getColumnPresentation() {
        return this.fColumnPresentation;
    }

    public String[] getVisibleColumns() {
        IColumnPresentation presentation = this.getColumnPresentation();
        if (presentation != null) {
            String[] columns = (String[])this.fVisibleColumns.get(presentation.getId());
            if (columns == null) {
                return presentation.getInitialColumns();
            }
            return columns;
        }
        return null;
    }

    public void setVisibleColumns(String[] ids) {
        IColumnPresentation presentation = this.getColumnPresentation();
        if (presentation != null) {
            this.fVisibleColumns.remove(presentation.getId());
            if (ids != null) {
                String[] columns = presentation.getInitialColumns();
                if (columns.length == ids.length) {
                    int i = 0;
                    while (i < columns.length) {
                        if (!ids[i].equals(columns[i])) {
                            this.fVisibleColumns.put(presentation.getId(), ids);
                            break;
                        }
                        ++i;
                    }
                } else {
                    this.fVisibleColumns.put(presentation.getId(), ids);
                }
            }
            this.refreshColumns();
        }
    }

    public void saveState(IMemento memento) {
        Map.Entry entry;
        Iterator iterator;
        this.persistColumnSizes();
        if (!this.fColumnSizes.isEmpty()) {
            iterator = this.fColumnSizes.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                IMemento sizes = memento.createChild(COLUMN_SIZES, (String)entry.getKey());
                sizes.putInteger(SIZE, ((Integer)entry.getValue()).intValue());
            }
        }
        if (!this.fVisibleColumns.isEmpty()) {
            iterator = this.fVisibleColumns.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                String id = (String)entry.getKey();
                IMemento visible = memento.createChild(VISIBLE_COLUMNS, id);
                String[] columns = (String[])entry.getValue();
                visible.putInteger(SIZE, columns.length);
                int i = 0;
                while (i < columns.length) {
                    visible.putString(COLUMN + Integer.toString(i), columns[i]);
                    ++i;
                }
            }
        }
    }

    public void initState(IMemento memento) {
        String id;
        IMemento child;
        IMemento[] mementos = memento.getChildren(COLUMN_SIZES);
        int i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            Integer size = child.getInteger(SIZE);
            if (size != null) {
                this.fColumnSizes.put(id, size);
            }
            ++i;
        }
        mementos = memento.getChildren(VISIBLE_COLUMNS);
        i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            Integer integer = child.getInteger(SIZE);
            if (integer != null) {
                int length = integer;
                String[] columns = new String[length];
                int j = 0;
                while (j < length) {
                    columns[j] = child.getString(COLUMN + Integer.toString(j));
                    ++j;
                }
                this.fVisibleColumns.put(id, columns);
            }
            ++i;
        }
    }
}

