/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.provisional;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.ILabelRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.progress.UIJob;

public abstract class AsynchronousLabelAdapter
implements IAsynchronousLabelAdapter {
    public void retrieveLabel(final Object element, final IPresentationContext context, final ILabelRequestMonitor result) {
        Object job = null;
        job = this.requiresUIJob() ? new UIJob("Retrieving labels"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AsynchronousLabelAdapter.this.computeLabels(element, context, result);
                return Status.OK_STATUS;
            }
        } : new Job("Retrieving labels"){

            protected IStatus run(IProgressMonitor monitor) {
                AsynchronousLabelAdapter.this.computeLabels(element, context, result);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected boolean requiresUIJob() {
        return false;
    }

    protected void computeLabels(Object element, IPresentationContext context, ILabelRequestMonitor monitor) {
        if (!monitor.isCanceled()) {
            IStatus status = Status.OK_STATUS;
            try {
                monitor.setLabels(this.getLabels(element, context));
                if (!monitor.isCanceled()) {
                    monitor.setImageDescriptors(this.getImageDescriptors(element, context));
                }
                if (!monitor.isCanceled()) {
                    monitor.setFontDatas(this.getFontDatas(element, context));
                }
                if (!monitor.isCanceled()) {
                    monitor.setBackgrounds(this.getBackgrounds(element, context));
                }
                if (!monitor.isCanceled()) {
                    monitor.setForegrounds(this.getForegrounds(element, context));
                }
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
            if (!monitor.isCanceled()) {
                monitor.setStatus(status);
                monitor.done();
            }
        }
    }

    protected abstract String[] getLabels(Object var1, IPresentationContext var2) throws CoreException;

    protected abstract ImageDescriptor[] getImageDescriptors(Object var1, IPresentationContext var2) throws CoreException;

    protected abstract FontData[] getFontDatas(Object var1, IPresentationContext var2) throws CoreException;

    protected abstract RGB[] getForegrounds(Object var1, IPresentationContext var2) throws CoreException;

    protected abstract RGB[] getBackgrounds(Object var1, IPresentationContext var2) throws CoreException;
}

