/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.viewers.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.EventHandlerModelProxy;

public class ProcessProxy
extends EventHandlerModelProxy {
    private IProcess fProcess;
    private DebugEventHandler fProcessEventHandler = new DebugEventHandler(this){

        protected boolean handlesEvent(DebugEvent event) {
            return event.getSource().equals(ProcessProxy.this.fProcess);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleChange(DebugEvent event) {
            ModelDelta delta = null;
            ProcessProxy processProxy = ProcessProxy.this;
            synchronized (processProxy) {
                if (!this.isDisposed()) {
                    ModelDelta node = delta = new ModelDelta(DebugPlugin.getDefault().getLaunchManager(), 0);
                    node = node.addNode(ProcessProxy.this.fProcess.getLaunch(), 0);
                    node.addNode(ProcessProxy.this.fProcess, 2048);
                }
            }
            if (delta != null && !this.isDisposed()) {
                ProcessProxy.this.fireModelChanged(delta);
            }
        }

        protected void handleCreate(DebugEvent event) {
        }
    };

    public synchronized void dispose() {
        super.dispose();
        this.fProcess = null;
    }

    public ProcessProxy(IProcess process) {
        this.fProcess = process;
    }

    protected synchronized boolean containsEvent(DebugEvent event) {
        return event.getSource().equals(this.fProcess);
    }

    protected DebugEventHandler[] createEventHandlers() {
        return new DebugEventHandler[]{this.fProcessEventHandler};
    }
}

