/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.views.launch.ImageImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class DebugElementHelper {
    private static DelegatingModelPresentation fgPresenetation;
    private static Map fgImages;

    static {
        fgImages = new HashMap();
    }

    public static void dispose() {
        fgImages.clear();
        if (fgPresenetation != null) {
            fgPresenetation.dispose();
            fgPresenetation = null;
        }
    }

    public static ImageDescriptor getImageDescriptor(Object object) {
        Image image = DebugElementHelper.getPresentation().getImage(object);
        return DebugElementHelper.getImageDescriptor(image);
    }

    public static ImageDescriptor getImageDescriptor(Image image) {
        if (image != null) {
            ImageDescriptor descriptor = (ImageDescriptor)fgImages.get(image);
            if (descriptor == null) {
                descriptor = new ImageImageDescriptor(image);
                fgImages.put(image, descriptor);
            }
            return descriptor;
        }
        return null;
    }

    public static String getLabel(Object o) {
        return DebugElementHelper.getPresentation().getText(o);
    }

    public static DelegatingModelPresentation getPresentation() {
        if (fgPresenetation == null) {
            fgPresenetation = new DelegatingModelPresentation();
        }
        return fgPresenetation;
    }

    public static RGB getForeground(Object element) {
        Color color = DebugElementHelper.getPresentation().getForeground(element);
        if (color != null) {
            return color.getRGB();
        }
        return null;
    }

    public static RGB getBackground(Object element) {
        Color color = DebugElementHelper.getPresentation().getBackground(element);
        if (color != null) {
            return color.getRGB();
        }
        return null;
    }

    public static FontData getFont(Object element) {
        Font font = DebugElementHelper.getPresentation().getFont(element);
        if (font != null) {
            return font.getFontData()[0];
        }
        return null;
    }
}

