/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.core.BreakpointManager;
import org.eclipse.debug.internal.ui.importexport.breakpoints.ImportExportMessages;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;

public class ImportBreakpointsOperation
implements IRunnableWithProgress {
    private boolean fOverwriteAll = false;
    private String fFileName = null;
    private boolean fCreateWorkingSets = false;
    private ArrayList fAdded = new ArrayList();
    private BreakpointManager fManager = (BreakpointManager)DebugPlugin.getDefault().getBreakpointManager();

    public ImportBreakpointsOperation(String fileName, boolean overwrite, boolean createWorkingSets) {
        this.fFileName = fileName;
        this.fOverwriteAll = overwrite;
        this.fCreateWorkingSets = createWorkingSets;
    }

    public void run(final IProgressMonitor monitor) throws InvocationTargetException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor wmonitor) throws CoreException {
                try {
                    XMLMemento memento = XMLMemento.createReadRoot((Reader)new FileReader(ImportBreakpointsOperation.this.fFileName));
                    IMemento[] nodes = memento.getChildren("breakpoint");
                    IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
                    IMemento node = null;
                    monitor.beginTask(ImportExportMessages.ImportOperation_0, nodes.length);
                    int i = 0;
                    while (i < nodes.length) {
                        if (!monitor.isCanceled()) {
                            node = nodes[i].getChild("resource");
                            IResource resource = workspace.findMember(node.getString("path"));
                            if (resource != null) {
                                node = nodes[i].getChild("marker");
                                IMarker marker = ImportBreakpointsOperation.this.findGeneralMarker(resource, node.getString("lineNumber"), node.getString("type"), node.getInteger("charStart"));
                                if (marker == null) {
                                    marker = resource.createMarker(node.getString("type"));
                                    ImportBreakpointsOperation.this.restoreBreakpoint(marker, nodes[i]);
                                } else if (ImportBreakpointsOperation.this.fOverwriteAll) {
                                    marker.setAttributes(null);
                                    ImportBreakpointsOperation.this.restoreBreakpoint(marker, nodes[i]);
                                }
                            }
                        } else {
                            return;
                        }
                        monitor.worked(i + 1);
                        ++i;
                    }
                    ImportBreakpointsOperation.this.fManager.addBreakpoints(ImportBreakpointsOperation.this.fAdded.toArray(new IBreakpoint[ImportBreakpointsOperation.this.fAdded.size()]));
                }
                catch (FileNotFoundException e) {
                    throw new CoreException((IStatus)new Status(4, IDebugUIConstants.PLUGIN_ID, 120, MessageFormat.format(ImportExportMessages.ImportBreakpointsOperation_0, ImportBreakpointsOperation.this.fFileName), (Throwable)e));
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void restoreBreakpoint(IMarker marker, IMemento node) throws CoreException {
        IMemento[] childnodes = null;
        IMemento child = null;
        child = node.getChild("marker");
        marker.setAttribute("lineNumber", (Object)child.getInteger("lineNumber"));
        marker.setAttribute("type", (Object)child.getString("type"));
        marker.setAttribute("charStart", (Object)child.getString("charStart"));
        childnodes = child.getChildren("attrib");
        String workingsets = "";
        int j = 0;
        while (j < childnodes.length) {
            String name = childnodes[j].getString("name");
            String value = childnodes[j].getString("value");
            if (value != null & name != null) {
                if (name.equals("workingset_name")) {
                    workingsets = value;
                }
                try {
                    marker.setAttribute(name, (Object)Integer.valueOf(value));
                }
                catch (NumberFormatException numberFormatException) {
                    if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true")) {
                        marker.setAttribute(name, (Object)Boolean.valueOf(value));
                    }
                    marker.setAttribute(name, (Object)value);
                }
            }
            ++j;
        }
        IBreakpoint breakpoint = this.fManager.createBreakpoint(marker);
        breakpoint.setEnabled(Boolean.valueOf(node.getString("enabled")).booleanValue());
        breakpoint.setPersisted(Boolean.valueOf(node.getString("persistant")).booleanValue());
        breakpoint.setRegistered(Boolean.valueOf(node.getString("registered")).booleanValue());
        this.fAdded.add(breakpoint);
        if (this.fCreateWorkingSets) {
            String[] names = workingsets.split("\\<;#>");
            int m = 1;
            while (m < names.length) {
                this.createWorkingSet(names[m], (IAdaptable)breakpoint);
                ++m;
            }
        }
    }

    private void createWorkingSet(String setname, IAdaptable element) {
        IWorkingSetManager wsmanager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet set = wsmanager.getWorkingSet(setname);
        if (set == null) {
            set = wsmanager.createWorkingSet(setname, new IAdaptable[0]);
            set.setId("org.eclipse.debug.ui.breakpointWorkingSet");
            wsmanager.addWorkingSet(set);
        }
        if (!this.setContainsBreakpoint(set, (IBreakpoint)element)) {
            IAdaptable[] elements = set.getElements();
            IAdaptable[] newElements = new IAdaptable[elements.length + 1];
            newElements[newElements.length - 1] = element;
            System.arraycopy(elements, 0, newElements, 0, elements.length);
            set.setElements(newElements);
        }
    }

    private boolean setContainsBreakpoint(IWorkingSet set, IBreakpoint breakpoint) {
        IAdaptable[] elements = set.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(breakpoint)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IMarker findGeneralMarker(IResource resource, String line, String type, Integer charstart) throws CoreException {
        IMarker[] markers = resource.findMarkers(null, false, 0);
        if (type != null) {
            int i = 0;
            while (i < markers.length) {
                Object localline = markers[i].getAttribute("lineNumber");
                String localtype = markers[i].getType();
                if (type.equals(localtype)) {
                    if (localline != null & line != null) {
                        if (line.equals(localline.toString())) {
                            Integer markerCharstart = (Integer)markers[i].getAttribute("charStart");
                            if (charstart == null ? markerCharstart == null : charstart.equals(markerCharstart)) {
                                return markers[i];
                            }
                        }
                    } else {
                        return markers[i];
                    }
                }
                ++i;
            }
        }
        return null;
    }
}

