/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.fieldassist;

import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class ComboContentAdapter
implements IControlContentAdapter {
    public String getControlContents(Control control) {
        return ((Combo)control).getText();
    }

    public void setControlContents(Control control, String text, int cursorPosition) {
        ((Combo)control).setText(text);
        ((Combo)control).setSelection(new Point(cursorPosition, cursorPosition));
    }

    public void insertControlContents(Control control, String text, int cursorPosition) {
        Combo combo = (Combo)control;
        String contents = combo.getText();
        Point selection = combo.getSelection();
        StringBuffer sb = new StringBuffer();
        sb.append(contents.substring(0, selection.x));
        sb.append(text);
        if (selection.y < contents.length()) {
            sb.append(contents.substring(selection.y, contents.length()));
        }
        combo.setText(sb.toString());
        selection.x += cursorPosition;
        selection.y = selection.x;
        combo.setSelection(selection);
    }

    public int getCursorPosition(Control control) {
        return ((Combo)control).getSelection().x;
    }

    public Rectangle getInsertionBounds(Control control) {
        Combo combo = (Combo)control;
        int position = combo.getSelection().y;
        String contents = combo.getText();
        GC gc = new GC((Drawable)combo);
        gc.setFont(combo.getFont());
        Point extent = gc.textExtent(contents.substring(0, Math.min(position, contents.length())));
        gc.dispose();
        return new Rectangle(combo.getClientArea().x + extent.x, combo.getClientArea().y, 1, combo.getClientArea().height);
    }
}

