/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.Diff;
import org.eclipse.compare.internal.patch.Hunk;
import org.eclipse.compare.internal.patch.LineReader;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;

public class Patcher {
    private static final boolean DEBUG = false;
    private static final String DEV_NULL = "/dev/null";
    protected static final String REJECT_FILE_EXTENSION = ".rej";
    protected static final String MARKER_TYPE = "org.eclipse.compare.rejectedPatchMarker";
    private static DateFormat[] DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("EEE MMM dd kk:mm:ss yyyy"), new SimpleDateFormat("yyyy/MM/dd kk:mm:ss"), new SimpleDateFormat("EEE MMM dd kk:mm:ss yyyy", Locale.US)};
    private String fName;
    protected Diff[] fDiffs;
    private IResource fTarget;
    private int fStripPrefixSegments;
    private int fFuzz;
    private boolean fIgnoreWhitespace = false;
    private boolean fIgnoreLineDelimiter = true;
    private boolean fPreserveLineDelimiters = false;
    private boolean fReverse = false;
    private boolean fAdjustShift = true;

    void setName(String name) {
        this.fName = name;
    }

    String getName() {
        return this.fName;
    }

    public Diff[] getDiffs() {
        return this.fDiffs;
    }

    IPath getPath(Diff diff) {
        IPath path = diff.getPath();
        if (this.fStripPrefixSegments > 0 && this.fStripPrefixSegments < path.segmentCount()) {
            path = path.removeFirstSegments(this.fStripPrefixSegments);
        }
        return path;
    }

    boolean setStripPrefixSegments(int strip) {
        if (strip != this.fStripPrefixSegments) {
            this.fStripPrefixSegments = strip;
            return true;
        }
        return false;
    }

    int getStripPrefixSegments() {
        return this.fStripPrefixSegments;
    }

    boolean setFuzz(int fuzz) {
        if (fuzz != this.fFuzz) {
            this.fFuzz = fuzz;
            return true;
        }
        return false;
    }

    public boolean setReversed(boolean reverse) {
        if (this.fReverse != reverse) {
            this.fReverse = reverse;
            int i = 0;
            while (i < this.fDiffs.length) {
                this.fDiffs[i].reverse();
                ++i;
            }
            return true;
        }
        return false;
    }

    boolean setIgnoreWhitespace(boolean ignoreWhitespace) {
        if (ignoreWhitespace != this.fIgnoreWhitespace) {
            this.fIgnoreWhitespace = ignoreWhitespace;
            return true;
        }
        return false;
    }

    public void parse(LineReader lr, String line) throws IOException {
        ArrayList diffs = new ArrayList();
        boolean reread = false;
        String diffArgs = null;
        String fileName = null;
        boolean bl = reread = line != null;
        while (true) {
            if (!reread) {
                line = lr.readLine();
            }
            reread = false;
            if (line == null) break;
            if (line.length() < 4) continue;
            if (line.startsWith("Index: ")) {
                fileName = line.substring(7).trim();
                continue;
            }
            if (line.startsWith("diff")) {
                diffArgs = line.substring(4).trim();
                continue;
            }
            if (line.startsWith("--- ")) {
                line = this.readUnifiedDiff(diffs, lr, line, diffArgs, fileName);
                fileName = null;
                diffArgs = null;
                reread = true;
                continue;
            }
            if (!line.startsWith("*** ")) continue;
            line = this.readContextDiff(diffs, lr, line, diffArgs, fileName);
            fileName = null;
            diffArgs = null;
            reread = true;
        }
        lr.close();
        this.fDiffs = diffs.toArray(new Diff[diffs.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readUnifiedDiff(List diffs, LineReader reader, String line, String args, String fileName) throws IOException {
        String string;
        String[] oldArgs = this.split(line.substring(4));
        line = reader.readLine();
        if (line == null) return line;
        if (!line.startsWith("+++ ")) {
            return line;
        }
        String[] newArgs = this.split(line.substring(4));
        Diff diff = new Diff(this.extractPath(oldArgs, 0, fileName), this.extractDate(oldArgs, 1), this.extractPath(newArgs, 0, fileName), this.extractDate(newArgs, 1));
        diffs.add(diff);
        int[] oldRange = new int[2];
        int[] newRange = new int[2];
        ArrayList<String> lines = new ArrayList<String>();
        try {
            block7: while (true) {
                if ((line = reader.readLine()) == null) {
                    String string2 = null;
                    Object var16_18 = null;
                    if (lines.size() > 0) {
                        new Hunk(diff, oldRange, newRange, lines);
                    }
                    diff.finish();
                    return string2;
                }
                if (reader.lineContentLength(line) == 0) continue;
                char c = line.charAt(0);
                switch (c) {
                    case '@': {
                        if (!line.startsWith("@@ ")) break block7;
                        if (lines.size() > 0) {
                            new Hunk(diff, oldRange, newRange, lines);
                            lines.clear();
                        }
                        this.extractPair(line, '-', oldRange);
                        this.extractPair(line, '+', newRange);
                        continue block7;
                    }
                    case ' ': 
                    case '+': 
                    case '-': {
                        lines.add(line);
                        continue block7;
                    }
                    case '\\': {
                        int end;
                        if (line.indexOf("newline at end") <= 0) break block7;
                        int lastIndex = lines.size();
                        if (lastIndex <= 0) continue block7;
                        line = (String)lines.get(lastIndex - 1);
                        char lc = line.charAt(end = line.length() - 1);
                        if (lc == '\n') {
                            if (--end > 0 && line.charAt(end - 1) == '\r') {
                                --end;
                            }
                        } else if (lc == '\r') {
                            --end;
                        }
                        line = line.substring(0, end + 1);
                        lines.set(lastIndex - 1, line);
                        continue block7;
                    }
                }
                break;
            }
            string = line;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            if (lines.size() > 0) {
                new Hunk(diff, oldRange, newRange, lines);
            }
            diff.finish();
            throw throwable;
        }
        Object var16_19 = null;
        if (lines.size() > 0) {
            new Hunk(diff, oldRange, newRange, lines);
        }
        diff.finish();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readContextDiff(List diffs, LineReader reader, String line, String args, String fileName) throws IOException {
        String string;
        String[] oldArgs = this.split(line.substring(4));
        line = reader.readLine();
        if (line == null) return line;
        if (!line.startsWith("--- ")) {
            return line;
        }
        String[] newArgs = this.split(line.substring(4));
        Diff diff = new Diff(this.extractPath(oldArgs, 0, fileName), this.extractDate(oldArgs, 1), this.extractPath(newArgs, 0, fileName), this.extractDate(newArgs, 1));
        diffs.add(diff);
        int[] oldRange = new int[2];
        int[] newRange = new int[2];
        ArrayList<String> oldLines = new ArrayList<String>();
        ArrayList newLines = new ArrayList();
        ArrayList<String> lines = oldLines;
        try {
            block7: while (true) {
                if ((line = reader.readLine()) == null) {
                    String string2 = line;
                    Object var15_17 = null;
                    if (oldLines.size() > 0 || newLines.size() > 0) {
                        new Hunk(diff, oldRange, newRange, this.unifyLines(oldLines, newLines));
                    }
                    diff.finish();
                    return string2;
                }
                int l = line.length();
                if (l == 0) continue;
                if (l <= 1) break;
                switch (line.charAt(0)) {
                    case '*': {
                        if (line.startsWith("***************")) {
                            if (oldLines.size() <= 0 && newLines.size() <= 0) continue block7;
                            new Hunk(diff, oldRange, newRange, this.unifyLines(oldLines, newLines));
                            oldLines.clear();
                            newLines.clear();
                            continue block7;
                        }
                        if (!line.startsWith("*** ")) break block7;
                        this.extractPair(line, ' ', oldRange);
                        oldRange[1] = oldRange[1] - oldRange[0] + 1;
                        lines = oldLines;
                        continue block7;
                    }
                    case ' ': 
                    case '!': 
                    case '+': {
                        if (line.charAt(1) != ' ') break block7;
                        lines.add(line);
                        continue block7;
                    }
                    case '-': {
                        if (line.charAt(1) == ' ') {
                            lines.add(line);
                            continue block7;
                        }
                        if (!line.startsWith("--- ")) break block7;
                        this.extractPair(line, ' ', newRange);
                        newRange[1] = newRange[1] - newRange[0] + 1;
                        lines = newLines;
                        continue block7;
                    }
                }
                break;
            }
            string = line;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            if (oldLines.size() > 0 || newLines.size() > 0) {
                new Hunk(diff, oldRange, newRange, this.unifyLines(oldLines, newLines));
            }
            diff.finish();
            throw throwable;
        }
        Object var15_18 = null;
        if (oldLines.size() > 0 || newLines.size() > 0) {
            new Hunk(diff, oldRange, newRange, this.unifyLines(oldLines, newLines));
        }
        diff.finish();
        return string;
    }

    private List unifyLines(List oldLines, List newLines) {
        ArrayList<String> result = new ArrayList<String>();
        String[] ol = oldLines.toArray(new String[oldLines.size()]);
        String[] nl = newLines.toArray(new String[newLines.size()]);
        int oi = 0;
        int ni = 0;
        block0: while (true) {
            char oc = '\u0000';
            String o = null;
            if (oi < ol.length) {
                o = ol[oi];
                oc = o.charAt(0);
            }
            char nc = '\u0000';
            String n = null;
            if (ni < nl.length) {
                n = nl[ni];
                nc = n.charAt(0);
            }
            if (oc == '\u0000' && nc == '\u0000') break;
            if (oc == '-') {
                do {
                    result.add(String.valueOf('-') + o.substring(2));
                } while (++oi < ol.length && (o = ol[oi]).charAt(0) == '-');
                continue;
            }
            if (nc == '+') {
                do {
                    result.add(String.valueOf('+') + n.substring(2));
                } while (++ni < nl.length && (n = nl[ni]).charAt(0) == '+');
                continue;
            }
            if (oc == '!' && nc == '!') {
                do {
                    result.add(String.valueOf('-') + o.substring(2));
                } while (++oi < ol.length && (o = ol[oi]).charAt(0) == '!');
                do {
                    result.add(String.valueOf('+') + n.substring(2));
                } while (++ni < nl.length && (n = nl[ni]).charAt(0) == '!');
                continue;
            }
            if (oc == ' ' && nc == ' ') {
                do {
                    Assert.isTrue((boolean)o.equals(n), (String)"non matching context lines");
                    result.add(String.valueOf(' ') + o.substring(2));
                    if (++oi >= ol.length || ++ni >= nl.length) continue block0;
                    o = ol[oi];
                    n = nl[ni];
                } while (o.charAt(0) == ' ' && n.charAt(0) == ' ');
                continue;
            }
            if (oc == ' ') {
                do {
                    result.add(String.valueOf(' ') + o.substring(2));
                } while (++oi < ol.length && (o = ol[oi]).charAt(0) == ' ');
                continue;
            }
            if (nc == ' ') {
                do {
                    result.add(String.valueOf(' ') + n.substring(2));
                } while (++ni < nl.length && (n = nl[ni]).charAt(0) == ' ');
                continue;
            }
            Assert.isTrue((boolean)false, (String)("unexpected char <" + oc + "> <" + nc + ">"));
        }
        return result;
    }

    private String[] split(String line) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(line, "\t");
        while (st.hasMoreElements()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            l.add(token);
        }
        return l.toArray(new String[l.size()]);
    }

    private long extractDate(String[] args, int n) {
        if (n < args.length) {
            String line = args[n];
            int i = 0;
            while (i < DATE_FORMATS.length) {
                DATE_FORMATS[i].setLenient(true);
                try {
                    Date date = DATE_FORMATS[i].parse(line);
                    return date.getTime();
                }
                catch (ParseException parseException) {
                    ++i;
                }
            }
        }
        return -1L;
    }

    private IPath extractPath(String[] args, int n, String path2) {
        if (n < args.length) {
            String path = args[n];
            if (DEV_NULL.equals(path)) {
                return null;
            }
            int pos = path.lastIndexOf(58);
            if (pos >= 0) {
                path = path.substring(0, pos);
            }
            if (path2 != null && !path2.equals(path)) {
                path = path2;
            }
            return new Path(path);
        }
        return null;
    }

    private void extractPair(String line, char start, int[] pair) {
        pair[1] = -1;
        pair[0] = -1;
        int startPos = line.indexOf(start);
        if (startPos < 0) {
            return;
        }
        int endPos = (line = line.substring(startPos + 1)).indexOf(32);
        if (endPos < 0) {
            return;
        }
        int comma = (line = line.substring(0, endPos)).indexOf(44);
        if (comma >= 0) {
            pair[0] = Integer.parseInt(line.substring(0, comma));
            pair[1] = Integer.parseInt(line.substring(comma + 1));
        } else {
            pair[0] = Integer.parseInt(line);
            pair[1] = 1;
        }
    }

    public void patch(Diff diff, List lines, List failedHunks) {
        int shift = 0;
        Iterator iter = diff.fHunks.iterator();
        while (iter.hasNext()) {
            Hunk hunk = (Hunk)iter.next();
            hunk.fMatches = false;
            shift = this.patch(hunk, lines, shift, failedHunks);
        }
    }

    private int patch(Hunk hunk, List lines, int shift, List failedHunks) {
        if (this.tryPatch(hunk, lines, shift)) {
            if (hunk.isEnabled()) {
                shift += this.doPatch(hunk, lines, shift);
            }
        } else {
            boolean found = false;
            int i = 1;
            while (i <= this.fFuzz) {
                if (this.tryPatch(hunk, lines, shift - i)) {
                    if (this.fAdjustShift) {
                        shift -= i;
                    }
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                i = 1;
                while (i <= this.fFuzz) {
                    if (this.tryPatch(hunk, lines, shift + i)) {
                        if (this.fAdjustShift) {
                            shift += i;
                        }
                        found = true;
                        break;
                    }
                    ++i;
                }
            }
            if (found) {
                shift += this.doPatch(hunk, lines, shift);
            } else if (failedHunks != null) {
                failedHunks.add(hunk);
            }
        }
        return shift;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryPatch(Hunk hunk, List lines, int shift) {
        int pos = hunk.fOldStart + shift;
        int deleteMatches = 0;
        int i = 0;
        while (i < hunk.fLines.length) {
            block10: {
                String s = hunk.fLines[i];
                Assert.isTrue((s.length() > 0 ? 1 : 0) != 0);
                String line = s.substring(1);
                char controlChar = s.charAt(0);
                if (controlChar == ' ') {
                    if (pos < 0 || pos >= lines.size()) {
                        return false;
                    }
                    if (!this.linesMatch(line, (String)lines.get(pos))) return false;
                    ++pos;
                } else {
                    if (controlChar == '-') {
                        while (true) {
                            if (pos < 0 || pos >= lines.size()) {
                                return false;
                            }
                            if (this.linesMatch(line, (String)lines.get(pos))) {
                                ++deleteMatches;
                                ++pos;
                                break block10;
                            }
                            if (deleteMatches <= 0) {
                                return false;
                            }
                            ++pos;
                        }
                    }
                    if (controlChar != '+') {
                        Assert.isTrue((boolean)false, (String)("tryPatch: unknown control character: " + controlChar));
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private int doPatch(Hunk hunk, List lines, int shift) {
        int pos = hunk.fOldStart + shift;
        int i = 0;
        while (i < hunk.fLines.length) {
            block11: {
                String s = hunk.fLines[i];
                Assert.isTrue((s.length() > 0 ? 1 : 0) != 0);
                String line = s.substring(1);
                char controlChar = s.charAt(0);
                if (controlChar == ' ') {
                    while (true) {
                        Assert.isTrue((pos < lines.size() ? 1 : 0) != 0, (String)"doPatch: inconsistency in context");
                        if (this.linesMatch(line, (String)lines.get(pos))) {
                            ++pos;
                            break block11;
                        }
                        ++pos;
                    }
                }
                if (controlChar == '-') {
                    while (true) {
                        Assert.isTrue((pos < lines.size() ? 1 : 0) != 0, (String)"doPatch: inconsistency in deleted lines");
                        if (this.linesMatch(line, (String)lines.get(pos))) break;
                        ++pos;
                    }
                    lines.remove(pos);
                } else if (controlChar == '+') {
                    if (hunk.fOldLength == 0 && pos + 1 < lines.size()) {
                        lines.add(pos + 1, line);
                    } else {
                        lines.add(pos, line);
                    }
                    ++pos;
                } else {
                    Assert.isTrue((boolean)false, (String)("doPatch: unknown control character: " + controlChar));
                }
            }
            ++i;
        }
        hunk.fMatches = true;
        return hunk.fNewLength - hunk.fOldLength;
    }

    public void applyAll(IProgressMonitor pm, Shell shell, String title) throws CoreException {
        int i;
        IFile singleFile = null;
        IContainer container = null;
        if (this.fTarget instanceof IContainer) {
            container = (IContainer)this.fTarget;
        } else if (this.fTarget instanceof IFile) {
            singleFile = (IFile)this.fTarget;
            container = singleFile.getParent();
        } else {
            Assert.isTrue((boolean)false);
        }
        ArrayList<IFile> list = new ArrayList<IFile>();
        if (singleFile != null) {
            list.add(singleFile);
        } else {
            i = 0;
            while (i < this.fDiffs.length) {
                Diff diff = this.fDiffs[i];
                if (diff.isEnabled()) {
                    switch (diff.getType()) {
                        case 3: {
                            list.add(this.createPath(container, this.getPath(diff)));
                        }
                    }
                }
                ++i;
            }
        }
        if (!Utilities.validateResources(list, shell, title)) {
            return;
        }
        if (pm != null) {
            String message = PatchMessages.Patcher_Task_message;
            pm.beginTask(message, this.fDiffs.length * 10);
        }
        i = 0;
        while (i < this.fDiffs.length) {
            int workTicks = 10;
            Diff diff = this.fDiffs[i];
            if (diff.isEnabled()) {
                IPath path = this.getPath(diff);
                if (pm != null) {
                    pm.subTask(path.toString());
                }
                IFile file = singleFile != null ? singleFile : this.createPath(container, path);
                ArrayList failed = new ArrayList();
                List result = null;
                int type = diff.getType();
                switch (type) {
                    case 1: {
                        result = this.apply(diff, file, true, failed);
                        this.store(this.createString(result), file, (IProgressMonitor)new SubProgressMonitor(pm, workTicks));
                        workTicks -= 10;
                        break;
                    }
                    case 2: {
                        file.delete(true, true, (IProgressMonitor)new SubProgressMonitor(pm, workTicks));
                        workTicks -= 10;
                        break;
                    }
                    case 3: {
                        result = this.apply(diff, file, false, failed);
                        this.store(this.createString(result), file, (IProgressMonitor)new SubProgressMonitor(pm, workTicks));
                        workTicks -= 10;
                    }
                }
                if (failed.size() > 0) {
                    IPath pp = null;
                    if (path.segmentCount() > 1) {
                        pp = path.removeLastSegments(1);
                        pp = pp.append(String.valueOf(path.lastSegment()) + REJECT_FILE_EXTENSION);
                    } else {
                        pp = new Path(String.valueOf(path.lastSegment()) + REJECT_FILE_EXTENSION);
                    }
                    file = this.createPath(container, pp);
                    if (file != null) {
                        this.store(this.getRejected(failed), file, pm);
                        try {
                            IMarker marker = file.createMarker(MARKER_TYPE);
                            marker.setAttribute("message", (Object)PatchMessages.Patcher_Marker_message);
                            marker.setAttribute("priority", 2);
                        }
                        catch (CoreException coreException) {}
                    }
                }
            }
            if (pm != null) {
                if (pm.isCanceled()) break;
                if (workTicks > 0) {
                    pm.worked(workTicks);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List load(IFile file, boolean create) {
        List lines;
        block12: {
            lines = null;
            if (!create && file != null) {
                InputStream is = null;
                try {
                    try {
                        is = file.getContents();
                        InputStreamReader streamReader = null;
                        try {
                            streamReader = new InputStreamReader(is, Utilities.getCharset((IResource)file));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            streamReader = new InputStreamReader(is);
                        }
                        BufferedReader reader = new BufferedReader(streamReader);
                        LineReader lr = new LineReader(reader);
                        if (!"carbon".equals(SWT.getPlatform())) {
                            lr.ignoreSingleCR();
                        }
                        lines = lr.readLines();
                    }
                    catch (CoreException coreException) {}
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var8_10 = null;
                    if (is == null) break block12;
                }
                try {}
                catch (IOException iOException) {}
                is.close();
            }
        }
        if (lines != null) return lines;
        return new ArrayList();
    }

    List apply(Diff diff, IFile file, boolean create, List failedHunks) {
        List lines = this.load(file, create);
        this.patch(diff, lines, failedHunks);
        return lines;
    }

    /*
     * Exception decompiling
     */
    protected void store(String contents, IFile file, IProgressMonitor pm) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 93->97)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String createString(List lines) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = lines.iterator();
        if (this.fPreserveLineDelimiters) {
            while (iter.hasNext()) {
                sb.append((String)iter.next());
            }
        } else {
            String lineSeparator = System.getProperty("line.separator");
            while (iter.hasNext()) {
                String line = (String)iter.next();
                int l = Patcher.length(line);
                if (l < line.length()) {
                    sb.append(line.substring(0, l));
                    sb.append(lineSeparator);
                    continue;
                }
                sb.append(line);
            }
        }
        return sb.toString();
    }

    String getRejected(List failedHunks) {
        if (failedHunks.size() <= 0) {
            return null;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        Iterator iter = failedHunks.iterator();
        while (iter.hasNext()) {
            Hunk hunk = (Hunk)iter.next();
            sb.append(hunk.getRejectedDescription());
            sb.append(lineSeparator);
            sb.append(hunk.getContent());
        }
        return sb.toString();
    }

    protected IFile createPath(IContainer container, IPath path) throws CoreException {
        if (path.segmentCount() > 1) {
            IFolder f = container.getFolder(path.uptoSegment(1));
            if (!f.exists()) {
                f.create(false, true, null);
            }
            return this.createPath((IContainer)f, path.removeFirstSegments(1));
        }
        return container.getFile(path);
    }

    private static String stripWhiteSpace(String s) {
        StringBuffer sb = new StringBuffer();
        int l = s.length();
        int i = 0;
        while (i < l) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private boolean linesMatch(String line1, String line2) {
        if (this.fIgnoreWhitespace) {
            return Patcher.stripWhiteSpace(line1).equals(Patcher.stripWhiteSpace(line2));
        }
        if (this.fIgnoreLineDelimiter) {
            int l2;
            int l1 = Patcher.length(line1);
            if (l1 != (l2 = Patcher.length(line2))) {
                return false;
            }
            return line1.regionMatches(0, line2, 0, l1);
        }
        return line1.equals(line2);
    }

    static int length(String s) {
        int l = s.length();
        if (l > 0) {
            char c = s.charAt(l - 1);
            if (c == '\r') {
                return l - 1;
            }
            if (c == '\n') {
                if (l > 1 && s.charAt(l - 2) == '\r') {
                    return l - 2;
                }
                return l - 1;
            }
        }
        return l;
    }

    int calculateFuzz(Hunk hunk, List lines, int shift, IProgressMonitor pm, int[] fuzz) {
        hunk.fMatches = false;
        if (this.tryPatch(hunk, lines, shift)) {
            shift += this.doPatch(hunk, lines, shift);
            fuzz[0] = 0;
        } else {
            boolean found = false;
            int hugeFuzz = lines.size();
            fuzz[0] = -2;
            int i = 1;
            while (i <= hugeFuzz) {
                if (pm.isCanceled()) {
                    fuzz[0] = -1;
                    return 0;
                }
                if (this.tryPatch(hunk, lines, shift - i)) {
                    fuzz[0] = i;
                    if (this.fAdjustShift) {
                        shift -= i;
                    }
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                i = 1;
                while (i <= hugeFuzz) {
                    if (pm.isCanceled()) {
                        fuzz[0] = -1;
                        return 0;
                    }
                    if (this.tryPatch(hunk, lines, shift + i)) {
                        fuzz[0] = i;
                        if (this.fAdjustShift) {
                            shift += i;
                        }
                        found = true;
                        break;
                    }
                    ++i;
                }
            }
            if (found) {
                shift += this.doPatch(hunk, lines, shift);
            }
        }
        return shift;
    }

    public IResource getTarget() {
        return this.fTarget;
    }

    public void setTarget(IResource target) {
        this.fTarget = target;
    }

    public IFile existsInTarget(IPath path) {
        IContainer c;
        if (this.fTarget instanceof IFile) {
            IFile file = (IFile)this.fTarget;
            if (this.matches(file.getFullPath(), path)) {
                return file;
            }
        } else if (this.fTarget instanceof IContainer && (c = (IContainer)this.fTarget).exists(path)) {
            return c.getFile(path);
        }
        return null;
    }

    private boolean matches(IPath fullpath, IPath path) {
        IPath p = fullpath;
        while (path.segmentCount() <= p.segmentCount()) {
            if (p.equals((Object)path)) {
                return true;
            }
            p = p.removeFirstSegments(1);
        }
        return false;
    }

    public int calculatePrefixSegmentCount() {
        int length = 99;
        if (this.fDiffs != null) {
            int i = 0;
            while (i < this.fDiffs.length) {
                Diff diff = this.fDiffs[i];
                if (diff.fOldPath != null) {
                    length = Math.min(length, diff.fOldPath.segmentCount());
                }
                if (diff.fNewPath != null) {
                    length = Math.min(length, diff.fNewPath.segmentCount());
                }
                ++i;
            }
        }
        return length;
    }
}

