/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.team.internal.core.Messages;

public class LocalFileRevision
extends FileRevision {
    private IFileState state;
    private IFile file;
    private IFileRevision baseRevision;

    public LocalFileRevision(IFileState state) {
        this.state = state;
        this.file = null;
        this.baseRevision = null;
    }

    public LocalFileRevision(IFile file) {
        this.file = file;
        this.baseRevision = null;
        this.state = null;
    }

    public String getContentIdentifier() {
        if (this.file != null) {
            return this.baseRevision == null ? NLS.bind((String)Messages.LocalFileRevision_currentVersion, (Object)"") : NLS.bind((String)Messages.LocalFileRevision_currentVersion, (Object)this.baseRevision.getContentIdentifier());
        }
        return "";
    }

    public String getAuthor() {
        return "";
    }

    public String getComment() {
        if (this.file != null) {
            return Messages.LocalFileRevision_currentVersionTag;
        }
        return Messages.LocalFileRevision_localRevisionTag;
    }

    public ITag[] getTags() {
        return new ITag[0];
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        if (this.file != null) {
            return this.file;
        }
        return this.state;
    }

    public String getName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return this.state.getName();
    }

    public long getTimestamp() {
        if (this.file != null) {
            return this.file.getLocalTimeStamp();
        }
        return this.state.getModificationTime();
    }

    public void setBaseRevision(IFileRevision baseRevision) {
        this.baseRevision = baseRevision;
    }

    public boolean isPropertyMissing() {
        return true;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) {
        return this;
    }
}

