/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.mapping;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.IStorageMerger;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.StorageMergerRegistry;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.mapping.IStreamMergerDelegate;

public class DelegatingStorageMerger
implements IStorageMerger {
    private static IStreamMergerDelegate mergerDelegate;
    private static DelegatingStorageMerger instance;
    private final IContentType contentType;

    private DelegatingStorageMerger() {
        this.contentType = null;
    }

    public DelegatingStorageMerger(IContentType contentType) {
        this.contentType = contentType;
    }

    public static void setMergerDelegate(IStreamMergerDelegate merger) {
        mergerDelegate = merger;
    }

    public static IStorageMerger getInstance() {
        if (instance == null) {
            instance = new DelegatingStorageMerger();
        }
        return instance;
    }

    public IStatus merge(OutputStream output, String outputEncoding, IStorage ancestor, IStorage target, IStorage other, IProgressMonitor monitor) throws CoreException {
        IStorageMerger merger = this.findMerger(target);
        if (merger == null) {
            return new Status(2, "org.eclipse.team.core", 1, Messages.DelegatingStorageMerger_0, null);
        }
        if (ancestor == null && !merger.canMergeWithoutAncestor()) {
            return new Status(2, "org.eclipse.team.core", 1, NLS.bind((String)Messages.MergeContext_1, (Object[])new String[]{target.getFullPath().toString()}), null);
        }
        return merger.merge(output, outputEncoding, ancestor, target, other, monitor);
    }

    private IStorageMerger findMerger(IStorage target) throws CoreException {
        IStorageMerger merger = null;
        if (this.contentType != null) {
            merger = this.getMerger(this.contentType);
            if (merger != null) {
                return merger;
            }
            TeamPlugin.log(4, NLS.bind((String)"Storage merger for {0} not available", (Object)this.contentType.getId()), null);
        }
        CoreException exception = null;
        try {
            IContentType type = DelegatingStorageMerger.getContentType(target);
            if (type != null) {
                merger = this.getMerger(type);
            }
        }
        catch (CoreException e) {
            exception = e;
        }
        if (merger == null && (merger = this.getMerger(target.getName())) == null) {
            int type = Team.getFileContentManager().getType(target);
            if (type == 1) {
                merger = this.getTextMerger();
            }
            if (merger == null) {
                merger = this.findAndWrapStreamMerger(target);
            }
        }
        if (exception != null) {
            if (merger == null) {
                throw exception;
            }
            TeamPlugin.log(exception);
        }
        return merger;
    }

    private IStorageMerger findAndWrapStreamMerger(IStorage target) {
        if (mergerDelegate != null) {
            IStorageMerger merger = mergerDelegate.findMerger(target);
            return merger;
        }
        return null;
    }

    private IStorageMerger getTextMerger() {
        return new DelegatingStorageMerger(Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text"));
    }

    private IStorageMerger getMerger(String name) {
        String extension = DelegatingStorageMerger.getExtension(name);
        if (extension != null) {
            return StorageMergerRegistry.getInstance().createStreamMerger(extension);
        }
        return null;
    }

    public static String getExtension(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return name.substring(index + 1);
    }

    private IStorageMerger getMerger(IContentType type) {
        IStorageMerger merger = StorageMergerRegistry.getInstance().createStreamMerger(type);
        return merger;
    }

    public static IContentType getContentType(IStorage target) throws CoreException {
        if (target instanceof IFile) {
            IFile file = (IFile)target;
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription != null) {
                IContentType contentType = contentDescription.getContentType();
                return contentType;
            }
        } else {
            IContentTypeManager manager = Platform.getContentTypeManager();
            try {
                IContentType type = manager.findContentTypeFor(target.getContents(), target.getName());
                return type;
            }
            catch (IOException e) {
                String name = target.getName();
                if (target.getFullPath() != null) {
                    name = target.getFullPath().toString();
                }
                throw new TeamException((IStatus)new Status(4, "org.eclipse.team.core", 2, NLS.bind((String)Messages.DelegatingStorageMerger_1, (Object)name), (Throwable)e));
            }
        }
        return null;
    }

    public boolean canMergeWithoutAncestor() {
        return false;
    }
}

