/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.mapping;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.diff.provider.ThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiff;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;

public class SyncInfoToDiffConverter {
    public static int asDiffFlags(int syncInfoFlags) {
        if (syncInfoFlags == 0) {
            return 0;
        }
        int kind = SyncInfo.getChange(syncInfoFlags);
        int diffFlags = 0;
        switch (kind) {
            case 1: {
                diffFlags = 1;
                break;
            }
            case 2: {
                diffFlags = 2;
                break;
            }
            case 3: {
                diffFlags = 4;
            }
        }
        int direction = SyncInfo.getDirection(syncInfoFlags);
        switch (direction) {
            case 8: {
                diffFlags |= 0x200;
                break;
            }
            case 4: {
                diffFlags |= 0x100;
                break;
            }
            case 12: {
                diffFlags |= 0x300;
            }
        }
        return diffFlags;
    }

    public static IDiff getDeltaFor(SyncInfo info) {
        if (info.getComparator().isThreeWay()) {
            ITwoWayDiff local = SyncInfoToDiffConverter.getLocalDelta(info);
            ITwoWayDiff remote = SyncInfoToDiffConverter.getRemoteDelta(info);
            return new ThreeWayDiff(local, remote);
        }
        if (info.getKind() != 0) {
            IResourceVariant remote = info.getRemote();
            IResource local = info.getLocal();
            int kind = remote == null ? 2 : (!local.exists() ? 1 : 4);
            if (local.getType() == 1) {
                IFileRevision after = SyncInfoToDiffConverter.asFileState(remote);
                IFileRevision before = FileRevision.getFileRevisionFor((IFile)local);
                return new ResourceDiff(info.getLocal(), kind, 0, before, after);
            }
            return new ResourceDiff(info.getLocal(), kind);
        }
        return null;
    }

    private static ITwoWayDiff getRemoteDelta(SyncInfo info) {
        int direction = SyncInfo.getDirection(info.getKind());
        if (direction == 8 || direction == 12) {
            IResourceVariant ancestor = info.getBase();
            IResourceVariant remote = info.getRemote();
            int kind = ancestor == null ? 1 : (remote == null ? 2 : 4);
            if (info.getLocal().getType() == 1) {
                IFileRevision before = SyncInfoToDiffConverter.asFileState(ancestor);
                IFileRevision after = SyncInfoToDiffConverter.asFileState(remote);
                return new ResourceDiff(info.getLocal(), kind, 0, before, after);
            }
            return new ResourceDiff(info.getLocal(), kind);
        }
        return null;
    }

    private static IFileRevision asFileState(IResourceVariant variant) {
        if (variant == null) {
            return null;
        }
        return new ResourceVariantFileRevision(variant);
    }

    private static ITwoWayDiff getLocalDelta(SyncInfo info) {
        int direction = SyncInfo.getDirection(info.getKind());
        if (direction == 4 || direction == 12) {
            IResourceVariant ancestor = info.getBase();
            IResource local = info.getLocal();
            int kind = ancestor == null ? 1 : (!local.exists() ? 2 : 4);
            if (local.getType() == 1) {
                IFileRevision before = SyncInfoToDiffConverter.asFileState(ancestor);
                IFileRevision after = FileRevision.getFileRevisionFor((IFile)local);
                return new ResourceDiff(info.getLocal(), kind, 0, before, after);
            }
            return new ResourceDiff(info.getLocal(), kind);
        }
        return null;
    }

    public static IResourceVariant getRemoteVariant(IThreeWayDiff twd) {
        IResourceDiff diff = (IResourceDiff)twd.getRemoteChange();
        if (diff != null) {
            return ((ResourceVariantFileRevision)diff.getAfterState()).getVariant();
        }
        diff = (IResourceDiff)twd.getLocalChange();
        if (diff != null) {
            return ((ResourceVariantFileRevision)diff.getBeforeState()).getVariant();
        }
        return null;
    }

    public static IResourceVariant getBaseVariant(IThreeWayDiff twd) {
        IResourceDiff diff = (IResourceDiff)twd.getRemoteChange();
        if (diff != null) {
            return ((ResourceVariantFileRevision)diff.getBeforeState()).getVariant();
        }
        diff = (IResourceDiff)twd.getLocalChange();
        if (diff != null) {
            return ((ResourceVariantFileRevision)diff.getBeforeState()).getVariant();
        }
        return null;
    }

    public static final class ResourceVariantFileRevision
    extends FileRevision {
        private final IResourceVariant variant;

        private ResourceVariantFileRevision(IResourceVariant variant) {
            this.variant = variant;
        }

        public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
            return this.variant.getStorage(monitor);
        }

        public String getName() {
            return this.variant.getName();
        }

        public String getContentIdentifier() {
            return this.variant.getContentIdentifier();
        }

        public IResourceVariant getVariant() {
            return this.variant;
        }

        public boolean isPropertyMissing() {
            return false;
        }

        public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
            return this;
        }
    }
}

